##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2007  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Widgets
#
##########################################################################

ccModule('Widgets');

##########################################################################

rc(<<EOF);

// aX - X position of control (lower left corner)
// aY - Y position of control (lower left corner)
// aWidth - width of the control (atleast 2 pixels)
// aHeight - height of the control
// aLevel - level to be displayed in VU bar (0 - 32767)
static void drawVuBar(ContextPtr aContext,int aX, int aY, int aWidth, int aHeight, int aLevel) {
	static int vuColors[4] = {0x004400, 0x44CC44, 0x000044, 0x4444CC};
	int halfWidth = aWidth / 2;
	int steps = aHeight / halfWidth;
	int redSteps = (steps * 3) / 4;
	int vuSteps = 32768 / (steps + 1);
	int vu = 0;
	int i;

	guiSelectPen1Color(aContext, -1);
	for(i = 0; i<steps ; i++) {
		vu += vuSteps;
		guiSelectFillColor(aContext, vuColors[((aLevel > vu)?1:0) + ((i>=redSteps)?2:0)]);
		guiDrawRect(aContext, aX, aY+1-(i+1)*halfWidth, aX+aWidth, aY-i*halfWidth);
	}
}

EOF