##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Virtual midi keyboard
#
##########################################################################

ccModule('Virtual midi keyboard');

setvar('int', 'theVirtualMidiKeyboardPort', '1');
setvar('int', 'theVirtualMidiKeyboardChannel', '1');

cc('showVirtualMidiKeyboard', 'guiShowWindow(virtualMidiKeyboardWindow);');
cc('theVirtualMidiKeyboardPort', 'configPanelWindowRefresh=true;');
cc('theVirtualMidiKeyboardChannel', 'configPanelWindowRefresh=true;');


cc('stfLoad', 'if (strcmp("VirtualMidiKeyboard", loadInfo->headerTitle)==0) { int c; readStfInteger(loadInfo, &c); setTheVirtualMidiKeyboardPort(c); readStfInteger(loadInfo, &c); setTheVirtualMidiKeyboardChannel(c); }');
cc('stfSave', 'storeStfBegin(loadInfo, "VirtualMidiKeyboard"); storeStfInteger(loadInfo, theVirtualMidiKeyboardPort); storeStfInteger(loadInfo, theVirtualMidiKeyboardChannel); storeStfEnd(loadInfo);');


rc(<<EOF);
static int virtualMidiKeyboardNoteTable[128];
static int virtualMidiKeyboardCurrentNote = 0;
static void virtualMidiKeyboardHandler(ContextPtr aContext) {
	int xp, xs, ys;
	int i, note=0;

	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH:
		guiSelectFillColor(aContext, 0x00FFFFFF);
		guiSelectPen1Color(aContext, 0x00FFFFFF);
		guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);

		guiClearAreaList(aContext);

		ys = aContext->guiClientRect.bottom;
		if (ys < 50) ys = 50;
		xs = ys / 8;

		// White keys
		guiSelectPen1Color(aContext, 0x00000000);
		xp = aContext->guiClientRect.right / 2 - 37*xs;
		for(i=0;i<128;i++) {
			if ((i\%12) == 0 || (i\%12) == 2 || (i\%12) == 4 || (i\%12) == 5 || (i\%12) == 7 || (i\%12) == 9 || (i\%12) == 11) {
				guiSelectFillColor(aContext, (virtualMidiKeyboardCurrentNote-1 == note)?0x0000FFFF:0x00FFFFFF);
				guiDrawRect(aContext, xp, aContext->guiClientRect.top, xp+xs, aContext->guiClientRect.bottom);
				guiAddArea(aContext, xp, aContext->guiClientRect.top, xp+xs, aContext->guiClientRect.bottom);
				virtualMidiKeyboardNoteTable[note++] = i;
				xp += xs;
			}
		}

		// Black keys
		xp = (aContext->guiClientRect.right+xs) / 2 - 37*xs;
		for(i=0;i<128;i++) {
			if ((i\%12) == 1 || (i\%12) == 3 || (i\%12) == 6 || (i\%12) == 8 || (i\%12) == 10) {
				guiSelectFillColor(aContext, (virtualMidiKeyboardCurrentNote-1 == note)?0x00008888:0x00000000);
				guiDrawRect(aContext, xp+1, aContext->guiClientRect.top, xp+xs-1, aContext->guiClientRect.bottom * 3 / 5);
				guiAddArea(aContext, xp+1, aContext->guiClientRect.top, xp+xs-1, aContext->guiClientRect.bottom * 3 / 5);
				virtualMidiKeyboardNoteTable[note++] = i;
				xp += xs;
			}
			if ((i\%12) == 5 || (i\%12) == 11) {
				xp += xs;
			}
		}
		break;
	case GUIEVENT_MOUSEBUTTON1DOWN:
		virtualMidiKeyboardCurrentNote = aContext->id;
		if (virtualMidiKeyboardCurrentNote
		&& (0 < theVirtualMidiKeyboardPort)
		&& (0 < theVirtualMidiKeyboardChannel)) {
			routeMidiMessage(theVirtualMidiKeyboardPort, 0x90 + (theVirtualMidiKeyboardChannel-1), virtualMidiKeyboardNoteTable[virtualMidiKeyboardCurrentNote-1], 0x40);
			virtualMidiKeyboardWindowRefresh = true;
		}
		break;
	case GUIEVENT_MOUSEBUTTON1UP:
		if (virtualMidiKeyboardCurrentNote
		&& (0 < theVirtualMidiKeyboardPort)
		&& (0 < theVirtualMidiKeyboardChannel)) {
			routeMidiMessage(theVirtualMidiKeyboardPort, 0x90 + (theVirtualMidiKeyboardChannel-1), virtualMidiKeyboardNoteTable[virtualMidiKeyboardCurrentNote-1], 0x00);
			virtualMidiKeyboardCurrentNote = 0;
			virtualMidiKeyboardWindowRefresh = true;
		}
		break;
	case GUIEVENT_CLOSE:
		guiHideWindow(virtualMidiKeyboardWindow);
		break;
	default:
		break;
	};
}
EOF


genWindow('virtualMidiKeyboardWindow', 'virtualmidikeyboard', '"Virtual MIDI keyboard"', 'virtualMidiKeyboardHandler', '400', '100', 0, 0, undef);
cc('windowInit', "guiDoubleBuffer(virtualMidiKeyboardWindow, true);");



