##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Transport control
#
##########################################################################

ccModule('Transport Control');

cc('showTransport', 'guiShowWindow(transportWindow);');
cc('thePlayMode', 'transportWindowRefresh=true;');
cc('theRecordMode', 'transportWindowRefresh=true;');
cc('theRewindTicker', 'transportWindowRefresh=true;');

rv('volatile int theNewLeftVuValue;');
rv('volatile int theNewRightVuValue;');

setvar('int', 'theRewindTicker', '0');

rs(<<EOF);
static void updateVuMeter(int aLeftVuValue, int aRightVuValue) {
	theNewLeftVuValue = aLeftVuValue;
	theNewRightVuValue = aRightVuValue;
}
EOF
	
rc(<<EOF);
// Draw the 4 transport icons: STOP PAUSE RECORD PLAY
static void DrawTransportIcons(ContextPtr aContext, int xoffs, int yoffs) {
	GuiRect myRect;
	int pressed;
	bool grayedPlay=true;
	bool grayedOthers=true;

	if (theCurrentProject>=0) {
		grayedOthers=false;
		if (theCurrentProject==thePlayingProject || thePlayingProject<0) {
			grayedPlay=false;
		}
	}

	// Rewind icon
	{
		pressed=(theRewindTicker>0)?1:0;//((CaptureMode==CAPTURE_STOP)?1:0);
		myRect.left=xoffs+2;
		myRect.right=xoffs+30;
		myRect.top=yoffs+2;
		myRect.bottom=yoffs+30;
		guiSelectFillColor(aContext, -1);
		guiDraw3dRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom, theRewindTicker>0);
		guiAddArea(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
		guiSelectPen1Color(aContext, (grayedOthers)?0x888888:0xBB0000);
		guiSelectFillColor(aContext, (grayedOthers)?0x888888:0xBB0000);
		GuiPoint pt[3]={{pressed+myRect.right-6, pressed+yoffs+8}, {pressed+myRect.left+6, pressed+yoffs+16}, {pressed+myRect.right-6, pressed+yoffs+24}};
		guiPolygon(aContext, pt, 3);
		myRect.left+=pressed+4;
		myRect.right+=pressed-22;
		myRect.top+=pressed+6;
		myRect.bottom+=pressed-6;
		guiDrawRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
	}

	// Draw stop icon
	{
		pressed=(thePlayMode==PLAYMODE_STOP)?1:0;
		myRect.left=32+xoffs+2;
		myRect.right=32+xoffs+30;
		myRect.top=yoffs+2;
		myRect.bottom=yoffs+30;
		guiSelectFillColor(aContext, -1);
		guiDraw3dRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom, thePlayMode==PLAYMODE_STOP);
		guiAddArea(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
		myRect.left+=pressed+6;
		myRect.right+=pressed-6;
		myRect.top+=pressed+6;
		myRect.bottom+=pressed-6;
		guiSelectPen1Color(aContext, (grayedOthers)?0x888888:0xBB0000);
		guiSelectFillColor(aContext, (grayedOthers)?0x888888:0xBB0000);
		guiDrawRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
	}

	// Draw play icon
	{
		pressed=(thePlayMode==PLAYMODE_PLAY)?1:0;
		myRect.left=64+xoffs+2;
		myRect.right=64+xoffs+30;
		myRect.top=yoffs+2;
		myRect.bottom=yoffs+30;
		guiSelectFillColor(aContext, -1);
		guiDraw3dRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom, thePlayMode==PLAYMODE_PLAY);
		guiAddArea(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
		guiSelectPen1Color(aContext, (grayedPlay)?0x888888:0x00AA00);
		guiSelectFillColor(aContext, (grayedPlay)?0x888888:0x00AA00);
		GuiPoint pt[3]={{pressed+myRect.left+6, pressed+yoffs+8}, {pressed+myRect.right-6, pressed+yoffs+16}, {pressed+myRect.left+6, pressed+yoffs+24}};
		guiPolygon(aContext, pt, 3);
	}

	// Draw record icon
	pressed=(theRecordMode==RECORDMODE_RECORD)?1:0;
	myRect.left=96+xoffs+2;
	myRect.right=96+xoffs+30;
	myRect.top=yoffs+2;
	myRect.bottom=yoffs+30;
	guiSelectFillColor(aContext, -1);
	guiDraw3dRect(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom, theRecordMode==RECORDMODE_RECORD);
	guiAddArea(aContext, myRect.left, myRect.top, myRect.right, myRect.bottom);
	guiSelectPen1Color(aContext, 0x0000BB);
	guiSelectFillColor(aContext, 0x0000BB);
	guiDrawEllipse(aContext, pressed+96+xoffs+8, pressed+yoffs+8, pressed+96+xoffs+24, pressed+yoffs+24);
}

static void drawTransportVU(ContextPtr aContext) {
	drawVuBar(aContext,  4, 60, 10, 64, VU_Left);
	drawVuBar(aContext, 16, 60, 10, 64, VU_Right);
}

static void drawTransportWindow(ContextPtr aContext) {
	guiClearAreaList(aContext);
	guiSelectFillColor(aContext, -1);
	guiDraw3dFill(
		aContext,
		aContext->guiClientRect.left,
		aContext->guiClientRect.top,
		aContext->guiClientRect.right,
		aContext->guiClientRect.bottom);

	drawTransportVU(aContext);

	// transport ICONS
	DrawTransportIcons(aContext, 32, 0);

	// Pattern position
	guiSelectPen1Color(aContext, 0);
	guiSelectPotFont(aContext);
	guiDrawTransparent(aContext);
	guiSetTextAlignment(aContext, alignTopLeft);

	char tmpstr[256];
//  sprintf(tmpstr, " SongPos: %d  Pattern: %d  Row: %d", copySongPos, songOrders[copySongPos], copyRow);
	sprintf(tmpstr, "DSP code: %d  calls: %d", theDspOptBufferIndex, theDspOptCallCount);
	guiDrawText(aContext, 32, 32, tmpstr, strlen(tmpstr));
	sprintf(tmpstr, " Tempo: %d / %d  Time: %02d:%02d:%02d", copyTempo, copyTicks, copyPlayTime/3600, (copyPlayTime/60)%60, copyPlayTime%60);
	guiDrawText(aContext, 32, 48, tmpstr, strlen(tmpstr));
}

static void transportHandler(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH:
		guiClearAreaList(aContext);
		drawTransportWindow(aContext);
		break;
	case GUIEVENT_MOUSEBUTTON1DOWN:
		switch(aContext->id) {
		case 1:
			setTheRewindTicker(2);
			resetPlayback();
			break;
		case 2:
			setPlayMode(PLAYMODE_STOP);
			break;
		case 3:
			setPlayMode(PLAYMODE_PLAY);
			break;
		case 4:
			if (theRecordMode!=RECORDMODE_STOP) {
				setRecordMode(RECORDMODE_STOP);
			} else {
				setRecordMode(RECORDMODE_RECORD);
			}
			break;
		default:
			break;
		}
		break;
	case GUIEVENT_TIMERTICK:
//    VU_Left = InterlockedExchange(&VU_newLeft, -1);
//    VU_Right = InterlockedExchange(&VU_newRight, -1);

		if (VU_Left!=theNewLeftVuValue || VU_Right!=theNewRightVuValue) {
			VU_Left=theNewLeftVuValue;
			VU_Right=theNewRightVuValue;
			drawTransportVU(aContext);

		}

		flushCaptureFile();

		if (theRewindTicker>0) {
			theRewindTicker--;
			if (theRewindTicker==0) {
				transportWindowRefresh=true;
			}
		}
		
//    if (copySongPos!=curSongPos || copyRow!=curRow || (curPlayTime/44100)!=copyPlayTime) {
//      copyPlayTime=curPlayTime/44100;
//      copySongPos=curSongPos;
//      copyRow=curRow;
//      copyTempo=curTempo;
//      copyTicks=curTicks;

//      GuiRect myRect={32,32,224,64};
//      guiRefreshWindow(aContext->currentWindow, &myRect);
//    }
		break;
	case GUIEVENT_KEYDOWN:
		switch(aContext->id) {
		case VK_ESCAPE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		} break;
	case GUIEVENT_CLOSE:
		guiHideWindow(aContext->currentWindow);
		break;
	default:
		break;
	}
}
EOF

rv('int VU_Left=0;');
rv('int VU_Right=0;');
rv('int copyPlayTime;');
# rv('int copySongPos;');
# rv('int copyRow;');
rv('int copyTempo;');
rv('int copyTicks;');

genWindow('transportWindow', 'TRANSPORTWINDOW', '"Transport Control"', 'transportHandler', 256, 64, 0, 0, 1);
cc('windowInit', "guiRunTimer(transportWindow, 100);");
