##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Track/Midi/Audio/Video sequencer
#
##########################################################################

ccModule('Track Sequencer');

cc('ProjectStruct', 'SequencerPtr sequencers;');
cc('ProjectStruct', 'int maxSequencers;');

# Songs -> Patterns -> Sections -> Phrases -> Events
#            Tracks -> Sections -> Phrases -> Events
#
# Event:
#    - Set tempo / metronoom
#    - Midi noteon/off/cc etc
#    - Play audio file + speed
#    - Change volume
#    - Play video/multimedia file
#    - Display picture
#    - Perform scripted action

rv('const char * const newSequencerName="new sequencer";');


my @PatternStructDef=(
	'int refCount;',
	'int maxTracks;',
);

my @SongStructDef=(
	'int maxPatterns;',
	'Pattern *patterns;',
);

my @TrackStructDef=(
	'bool selected;',
);

my @SequencerStructDef=(
	'bool selected;',
	'bool unfolded;',
	'Track *tracks;',
	'int maxTracks;',
);

genEnumStruct("struct", "Pattern", \@PatternStructDef);
genEnumStruct("struct", "Song", \@SongStructDef);
genEnumStruct("struct", "Track", \@TrackStructDef);
genEnumStruct("struct", "Sequencer", \@SequencerStructDef);





my @trackElementStructDef=('bool inUse;', 'bool selected;');
genEnumStruct("struct", "TrackElement", \@trackElementStructDef);

#my @trackStructDef=(
#	'bool selected;',
#	'char *trackName;',
#	'TrackElementPtr elements;',
#	'int maxElements;'
#);
#genEnumStruct("struct", "Track", \@trackStructDef);

rc(<<EOF);
static int createSequencer(void) {
	char tmpName[256];
	int n;

	if (projects==NULL) {
		createProject(newProjectName);
	}

	n=projects[theCurrentProject].maxSequencers++;
	projects[theCurrentProject].sequencers=(SequencerPtr)realloc(projects[theCurrentProject].sequencers, projects[theCurrentProject].maxSequencers*sizeof(Sequencer));
	memset(&(projects[theCurrentProject].sequencers[n]), 0, sizeof(Sequencer));
	selectSequencer(theCurrentProject, n, false);
	return n;
}

#if 0
static int createTrack(void) {
	char tmpName[256];
	int n;

	if (projects==NULL) {
		createProject(newProjectName);
	}

	n=projects[theCurrentProject].maxTracks++;
	projects[theCurrentProject].tracks=(TrackPtr)realloc(projects[theCurrentProject].tracks, projects[theCurrentProject].maxTracks*sizeof(Track));
	memset(&(projects[theCurrentProject].tracks[n]), 0, sizeof(Track));
	sprintf(tmpName, "track %d", n+1);
	projects[theCurrentProject].tracks[n].trackName=strdup(tmpName);
	selectProjectBrowserItem(theCurrentProject, -1, -1, n, false);
	return n;
}
#endif

static int firstTimelineArea;
static void processTimeline(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
      firstTimelineArea=guiGetAreaListLen(aContext);

		guiSelectFillColor(aContext, -1);
		guiDraw3dFill(
			aContext,
			aContext->guiClientRect.left,
			aContext->guiClientRect.top,
			aContext->guiClientRect.right,
			aContext->guiClientRect.bottom);
#if 0
      if (theCurrentProject>=0) {
        int y=0;
        int i;

        for(i=0; i<projects[theCurrentProject].maxTracks; i++) {
          GuiRect trackrect;
          char tmpstr[256];

          trackrect.left=0;
          trackrect.right=96;
          trackrect.top=(y++)*64+32;
          trackrect.bottom=trackrect.top+64;
          guiAddArea(aContext, trackrect.left, trackrect.top, trackrect.right, trackrect.bottom);
          if (projects[theCurrentProject].tracks[i].selected) {
            guiSelectFillColor(aContext, 0x00FFFF);
          } else {
            guiSelectFillColor(aContext, 0xFFFFFF);
          }
          guiDraw3dRect(aContext, &trackrect, EDGE_ETCHED);

  //        DrawEdge(context->hdc, &trackrect, EDGE_ETCHED, BF_MIDDLE | BF_RECT);
          trackrect.left=96;
          trackrect.right=aContext->guiClientRect.right;
          guiSelectFillColor(aContext, -1);
          guiDraw3dRect(aContext, &trackrect, EDGE_SUNKEN);
  //        DrawEdge(context->hdc, &trackrect, EDGE_SUNKEN, BF_MIDDLE | BF_RECT);

          guiDrawTransparent(aContext);
          guiSetTextAlignment(aContext, alignTopLeft);
          guiSelectPotFont(aContext);
          sprintf(tmpstr, "A/V Track %d", i+1);
          trackrect.top+=4;
          trackrect.left=4;
          trackrect.right=92;
          guiDrawText(aContext, trackrect.left, trackrect.top, tmpstr, strlen(tmpstr));
        }
      }

    } break;
	case GUIEVENT_MOUSEBUTTON1DOWN: {
      if (theCurrentProject>=0) {
        int areaNr=firstTimelineArea;
        int i;

        for(i=0; i<projects[theCurrentProject].maxTracks; i++) {
          if ((++areaNr) == aContext->id) {
            selectProjectBrowserItem(theCurrentProject, -1, -1, i, false);
          }
        }
      }
#endif
		} break;
	default:
		break;
	}  
}
EOF
