##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Script engine
#
##########################################################################

gModule('Script engine');

$fth=1;

$rd .= "#define FTH_DSTACKSIZE (256)\n";
$rd .= "#define FTH_RSTACKSIZE (256)\n";
$rd .= "#define FTH_ERROR_DSTACKOVERFLOW (1)\n";
$rd .= "#define FTH_ERROR_DSTACKUNDERFLOW (2)\n";
$rd .= "#define FTH_ERROR_RSTACKOVERFLOW (4)\n";
$rd .= "struct _Interpreter;\n";
$rd .= "typedef void (*interpreterFunctionPtr)(_Interpreter *);\n";
my @interpreterDictinaryDef=(
	'struct _Dictionary *prev;',
	'int useCount;',
	'const char *name;',
	'int *tokenList;',
	'interpreterFunctionPtr function;'
);
genEnumStruct("struct", "Dictionary", \@interpreterDictinaryDef);

my @interpreterStructDef=(
	'DictionaryPtr dictionary;',
	'int pc;',
	'int error;',
	'int dsp;',
	'int rsp;',
	'int dstk[FTH_DSTACKSIZE];',
	'int rstk[FTH_RSTACKSIZE];'
);
genEnumStruct("struct", "Interpreter", \@interpreterStructDef);

rv('InterpreterPtr theRootInterpreter;');

rc(<<EOF);
static int fthDPop(InterpreterPtr aInterpreter) {
	if (aInterpreter->dsp > 0) {
		return aInterpreter->dstk[--aInterpreter->dsp];
	}
	aInterpreter->error |= FTH_ERROR_DSTACKUNDERFLOW;
	return 0;
} 

static void fthDPush(InterpreterPtr aInterpreter, int aValue) {
	if (aInterpreter->dsp < FTH_DSTACKSIZE) {
		aInterpreter->dstk[aInterpreter->dsp++] = aValue;
	} else {
		aInterpreter->error |= FTH_ERROR_DSTACKOVERFLOW;
	}
}

static void fthAdd(InterpreterPtr aInterpreter) {
	int vTop=fthDPop(aInterpreter);
	int vBottom=fthDPop(aInterpreter);
	fthDPush(aInterpreter, vBottom + vTop);
}

static void fthSub(InterpreterPtr aInterpreter) {
	int vTop=fthDPop(aInterpreter);
	int vBottom=fthDPop(aInterpreter);
	fthDPush(aInterpreter, vBottom - vTop);
}

static void fthMul(InterpreterPtr aInterpreter) {
	int vTop=fthDPop(aInterpreter);
	int vBottom=fthDPop(aInterpreter);
	fthDPush(aInterpreter, vBottom * vTop);
}

static void addDictionaryEntry(InterpreterPtr aInterpreter, const char *aName, void (*function)(InterpreterPtr)) {
	DictionaryPtr newEntry=(DictionaryPtr)malloc(sizeof(Dictionary));
	newEntry->prev=aInterpreter->dictionary;
	newEntry->useCount=1;
	newEntry->name=strdup(aName);
	newEntry->tokenList=NULL;
	newEntry->function=function;
	aInterpreter->dictionary=newEntry;
}

static void createDefaultDictionary(InterpreterPtr aInterpreter) {
	addDictionaryEntry(aInterpreter, "+", fthAdd);
	addDictionaryEntry(aInterpreter, "-", fthSub);
	addDictionaryEntry(aInterpreter, "*", fthMul);
}

static DictionaryPtr findWord(InterpreterPtr aInterpreter, const char *aString, int seperator, int *readPosition) {
	DictionaryPtr currentEntry=aInterpreter->dictionary;
	int i;

	while (string[(*readPosition)] == seperator) {
		(*readPosition) += i;
	}	
	while (currentEntry) {
		i=0;
		while(currentEntry->name && currentEntry->name[i] && tolower(aString[(*readPosition)+i]) == tolower(currentEntry->name[i])) {
			i++;
		}
		if (i>0 && currentEntry->name[i]='\0' && (aString[(*readPosition)+i]==seperator || aString[(*readPosition)+i]=='\0')) {
			/* We found a match */
			(*readPosition) += i;
			break;			
		}
		currentEntry->prev;
	}
	return currentEntry;
}

static InterpreterPtr createInterpreter(InterpreterPtr rootInterpreter) {
	InterpreterPtr myInterpreter=(InterpreterPtr)malloc(sizeof(Interpreter));
	if (rootInterpreter) {
		myInterpreter->dictionary = rootInterpreter->dictionary;
	} else {
		myInterpreter->dictionary = NULL;
	}
	if (myInterpreter->dictionary) {
		myInterpreter->dictionary->useCount++;
	}
	return myInterpreter;
}

static void deleteInterpreter(InterpreterPtr aInterpreter) {
	/* Delete dictionary if this is the only user */
	while (aInterpreter->dictionary && (--(aInterpreter->dictionary->useCount))==0) {
		DictionaryPtr theDictionary=aInterpreter->dictionary;

		aInterpreter->dictionary = theDictionary->prev;
		free((void*)theDictionary->name);
		free(theDictionary);
	}
	free(aInterpreter);
}

static void runInterpreterScript(IntpereterPtr aInterpreter, const char aScript) {
	int posiition=0;
}


EOF

push(@initFunctions, 'theRootInterpreter = createInterpreter(NULL);');
push(@initFunctions, 'createDefaultDictionary(theRootInterpreter);');
push(@termFunctions, 'deleteInterpreter(theRootInterpreter);');
