##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Sample editor and sample load and storage
#
##########################################################################

cc('ProjectStruct', 'SamplePtr samples;');
cc('ProjectStruct', 'int maxSamples;');

gEnum('SampleEncoding');
cc('SampleEncodingEnum', 'SAMPLE_ENCODING_NONE');
cc('SampleEncodingEnum', 'SAMPLE_ENCODING_WAV');
cc('SampleEncodingEnum', 'SAMPLE_ENCODING_MP3');
cc('SampleEncodingEnum', 'SAMPLE_ENCODING_OGG');

gStruct('Sample');
cc('SampleStruct', 'bool selected;');
cc('SampleStruct', 'FILE *file;');
cc('SampleStruct', 'SampleEncoding encoding;');
cc('SampleStruct', 'int sampleRate;');
cc('SampleStruct', 'int noofBits;');
cc('SampleStruct', 'int noofChannels;');
cc('SampleStruct', 'int noofSamples;');
cc('SampleStruct', 'int storedNoofSamples;');

rs(<<EOF);
static void createSampleFile(Sample *sample, const char *filename) {
	sample->storedNoofSamples=0;
	switch(sample->encoding) {
	case SAMPLE_ENCODING_WAV:
		sample->file=fopen(filename, "wb");
		if (sample->file) {
			long bytespersec = sample->sampleRate * sample->noofChannels * (sample->noofBits/8);
			fprintf(sample->file, "RIFF____WAVEfmt %c%c%c%c%c%c%c%c", 0x10, 0, 0, 0, 1, 0, sample->noofChannels, 0);
			fwrite(&(sample->sampleRate), 4, 1, sample->file);
			fwrite(&bytespersec, 4, 1, sample->file);
			fprintf(sample->file, "%c%c%c%cdata____", 4, 0, sample->noofBits, 0);
		}
		break;
	case SAMPLE_ENCODING_MP3:
		createMp3File(sample, filename);
		break;
	default:
		break;
	}
}

static void closeSampleFile(Sample *sample) {
  if (sample->file) {
    switch(sample->encoding) {
    case SAMPLE_ENCODING_WAV: {
        long size;
        size=sample->storedNoofSamples*(sample->noofBits/8) + 0x24;
        fseek(sample->file, 0x04, SEEK_SET);
        fwrite(&size, 4, 1, sample->file);
        size=sample->storedNoofSamples*(sample->noofBits/8);
        fseek(sample->file, 0x28, SEEK_SET);
        fwrite(&size, 4, 1, sample->file);
      } break;
    case SAMPLE_ENCODING_MP3: {
        closeMp3File(sample);
      } break;
    default:
      break;
    }
    fclose(sample->file);
    sample->file=NULL;
  }
}

static void writeSampleData(Sample *sample, void *sampleData, int nrSamples) {
	if (sample->file) {
		switch(sample->encoding) {
		case SAMPLE_ENCODING_WAV:
			sample->storedNoofSamples+=fwrite(sampleData, sample->noofBits/8, nrSamples, sample->file);
			break;
		case SAMPLE_ENCODING_MP3:
			writeMp3Data(sample, sampleData, nrSamples);
			break;
		default:
			break;
		}
	}
}
EOF

rc(<<EOF);
static void processSampleEditor(ContextPtr aContext) {
}
EOF
