##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Project Browser window
#
##########################################################################

ccModule('Project Browser');

cc('showProjectBrowser', 'guiShowWindow(projectBrowserWindow);');
cc('thePlayMode', 'projectBrowserWindowRefresh=true;');

cc('ProjectStruct', 'bool selected;');
cc('ProjectStruct', 'bool unfolded;');
cc('ProjectStruct', 'bool modifiedFlag;');
cc('ProjectStruct', 'char *projectName;');
cc('ProjectStruct', 'char *projectPath;');
cc('ProjectStruct', 'DspObject *dsp;');
cc('ProjectStruct', 'TrackPtr tracks;');
cc('ProjectStruct', 'int maxTracks;');
cc('ProjectStruct', 'int patchCount;');

rv('const char * const newProjectName="new project";');
rv('ProjectPtr projects;');
rv('int maxProjects;');
rv('int thePlayingProject=-1;');
rv('int theCurrentProject=-1;');
rv('int currentPatch=-1;');
rv('int currentSample=-1;');
rv('int projectBrowserPos;');

rs(<<EOF);
static void selectProjectBrowserItem(int aProject, int aPatch, int aObject, int aTrack, bool multiSelect) {
	int i,j,k;
	int p=0;

//  projectBrowserPos=-1;
	//currentPatch=-1;
	for(i=0;i<maxProjects;i++) {
		if (aProject==i && aProject!=theCurrentProject) {
			theCurrentProject=i;
			if (projects[i].maxPatches>0) {
				currentPatch=0;
			} else {
				currentPatch=-1;
			}
			mainWindowRefresh=true;
		}
		if (aProject==i && aPatch==-1 && aTrack==-1) {
			projects[i].selected = true;
			projectBrowserPos = p;
		} else {
			if (!multiSelect) {
				projects[i].selected=false;
			}
		}
		p++;

		// Force selected item visible
		if (aProject==i
		&& ((0<=aPatch) || (0 <= aTrack))) {
			projects[i].unfolded = true;
		}

		// Patches
		for(j=0;j<projects[i].maxPatches;j++) {
			if (aProject==i && aPatch==j && j!=currentPatch) {
				currentPatch=j;
				patchConfigWindowRefresh=true;
				mainWindowRefresh=true;
			}
			if ((aProject == i)
			&& (aPatch == j)
			&& (0 > aObject)) {
				projects[i].patches[j].selected=true;
				if (projects[i].unfolded) {
					projectBrowserPos = p;
				}
			} else {
				if (!multiSelect && projects[i].patches[j].selected) {
					projects[i].patches[j].selected=false;
					patchConfigWindowRefresh=true;
				}
			}
			if (projects[i].unfolded) {
				p++;
			}
			for(k=0;k<projects[i].patches[j].maxObjects;k++) {
				if (aProject==i && aPatch==j && aObject==k) {
					if (!projects[i].patches[j].objects[k].selected) {
						projects[i].patches[j].objects[k].selected=true;
						refreshObject(projects[i].patches+j, projects[i].patches[j].objects+k);
//						mainWindowRefresh=true;
					}
				} else {
					if (!multiSelect && projects[i].patches[j].objects[k].selected) {
						projects[i].patches[j].objects[k].selected=false;
						refreshObject(projects[i].patches+j, projects[i].patches[j].objects+k);
//						mainWindowRefresh=true;
					}
				}
				if (projects[i].patches[j].unfolded) {
					p++;
				}
			}
		}

#if 0
		// Tracks
		for(j=0;j<projects[i].maxTracks;j++) {
			if (project==i && track==j) {
				projects[i].tracks[j].selected=true;
				if (projects[i].unfolded) {
					projectBrowserPos = p;
				}
			} else {
				if (!multiSelect && projects[i].tracks[j].selected) {
					projects[i].tracks[j].selected=false;
				}
			}
			if (projects[i].unfolded) {
				p++;
			}
		}
#endif
	}

	projectBrowserWindowRefresh=true;
}

static void selectProject(int aProject, bool multiSelect) {
	selectProjectBrowserItem(aProject, -1, -1, -1, multiSelect);
}

static void selectPatch(int aProject, int aPatch, bool multiSelect) {
}

static void selectSequencer(int aProject, int aSequencer, bool multiSelect) {
	// !!! temp solution to redraw the window during debugging
	projectBrowserWindowRefresh=true;
}

static int createProject(const char *projectName) {
	int n=-1;

	logprintf("createProject\\n");

	n=maxProjects;
	maxProjects++;
	lockMutex(theAudioMutex);
	lockMutex(midiMutex);
	projects=(ProjectPtr)realloc(projects, maxProjects*sizeof(Project));
	unlockMutex(midiMutex);
	unlockMutex(theAudioMutex);
	memset(&(projects[n]), 0, sizeof(Project));
	projects[n].dsp=(DspObject*)calloc(maxDspObjects, sizeof(DspObject));
	if (projectName) {
		projects[n].projectName=strdup(projectName);
	}
	currentPatch=-1;
	selectProject(n, false);
	transportWindowRefresh=true;

	logprintf("createProject returns %d\\n", n);
	return n;
}

static void setProjectModifiedFlag(int aProject, bool aModifiedFlag) {
	if (projects[aProject].modifiedFlag != aModifiedFlag) {
		projects[aProject].modifiedFlag = aModifiedFlag;
		projectBrowserWindowRefresh = true;
	}
}

static void setProjectModified(int aProject) {
	setProjectModifiedFlag(aProject, true);
}

static void setProjectPath(int project, const char *aPath) {
	if (project>=0 && project<maxProjects) {
		if (projects[project].projectPath) {
			free(projects[project].projectPath);
			projects[project].projectPath=NULL;
			projectBrowserWindowRefresh=true;
		}
		if (aPath) {
			projects[project].projectPath=strdup(aPath);
			projectBrowserWindowRefresh=true;
		}
	}
}
EOF

rc(<<EOF);
static void deleteProject(int project) {
	int i;

	if (thePlayingProject == project) {
		setPlayMode(PLAYMODE_STOP);
	}
	if (theCurrentProject == project) {
		patchConfigWindowRefresh = true;
		mainWindowRefresh = true;
	} 

	for(i=0;i<projects[project].maxPatches;i++) {
		deleteSynFactoryObjects(project, i, true);
		if (projects[project].patches[i].patchName) {
			free(projects[project].patches[i].patchName);
		}
	}

	free(projects[project].dsp);
	if (projects[project].patches) {
		free(projects[project].patches);
	}
	if (projects[project].projectPath) {
		free(projects[project].projectPath);
	}
	if (projects[project].projectName) {
		free(projects[project].projectName);
	}
	lockMutex(theAudioMutex);
	lockMutex(midiMutex);
	maxProjects--;
	for(i=project;i<maxProjects;i++) {
		projects[i]=projects[i+1];
	}
	projects=(ProjectPtr)realloc(projects, maxProjects*sizeof(Project));
	if (thePlayingProject >= project) {
		thePlayingProject--;
	}
	if (theCurrentProject>=maxProjects) {
		theCurrentProject=maxProjects-1;
	}
	if (theCurrentProject>=0) {
		currentPatch=projects[theCurrentProject].maxPatches-1;
	} else {
		currentPatch=-1;
	}
	unlockMutex(midiMutex);
	unlockMutex(theAudioMutex);
	projectBrowserWindowRefresh=true;
}

static void deleteSelected(void) {
	int i=0;

	while(i<maxProjects) {
		if (projects[i].selected) {
			deleteProject(i);
		} else {
			int j=0;
			while (j<projects[i].maxPatches) {
				deleteSynFactoryObjects(i, j, projects[i].patches[j].selected);
				if (projects[i].patches[j].selected) {
					for(int k=j;k<projects[i].maxPatches-1;k++) {
						projects[i].patches[k]=projects[i].patches[k+1];
					}
					projects[i].maxPatches--;
					projects[i].patches=(SynFactoryPatchPtr)realloc(projects[i].patches, projects[i].maxPatches*sizeof(SynFactoryPatch));
					if (theCurrentProject==i && currentPatch>=projects[i].maxPatches) {
						currentPatch=projects[i].maxPatches-1;
					}

					projectBrowserWindowRefresh=true;
					mainWindowRefresh=true;
					patchConfigWindowRefresh=true;
				} else {
					j++;
				}
			}
			i++;
		}
	}
}

static void projectBrowserAddHitArea(ContextPtr aContext, int y) {
	guiAddArea(aContext, aContext->guiClientRect.left, y, aContext->guiClientRect.right, y+14);
}

static void drawExpandBox(ContextPtr aContext, int x, int y, bool expanded) {
	guiSelectFillColor(aContext, -1);
	guiDrawRect(aContext, x, y, x+14, y+12);
	guiDrawLine(aContext, x+4, y+6, x+11, y+6);
	if (!expanded) {
		guiDrawLine(aContext,  x+7, y+3, x+7, y+10);
	}
}

static int projectBrowserBackground(bool cursor, bool selected) {
	if (cursor) {
		if (selected) {
			return 0x00AAAA;
		} else {
			return 0xAAAAAA;
		}
	} else {
		if (selected) {
			return 0x00FFFF;
		} else {
			return 0xFFFFFF;
		}
	}
}

static void projectBrowserHandler(ContextPtr aContext) {
	static bool recalcCursor=false;
	static int maxy=0;
	static int maxysize=0;
	
	static int maxXSize=0;

	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
			int color;
			int y=-guiGetVScrollPos(aContext->currentWindow);
			int ycursor=0;
			int i;
			int j;

			guiClearAreaList(aContext);

			guiSelectFillColor(aContext, 0xFFFFFF);
			guiSelectPen1Color(aContext, -1);
			guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);

			guiSelectPotFont(aContext);
			guiDrawTransparent(aContext);
			guiSelectPen1Color(aContext, 0);

//			if (maxProjects>0) {
//				guiDrawText(aContext, 2, y, "Projects:");
//				y+=14;
//			}

			for(i=0;i<maxProjects;i++) {
				int textColor;

				if (theCurrentProject==i) {
					textColor=0;
				} else if (thePlayingProject == i) {
					textColor=0x448844;
				} else {
					textColor=0x888888;
				}

				guiSelectPen1Color(aContext, textColor);
				drawExpandBox(aContext, 2, y, projects[i].unfolded);

				color=projectBrowserBackground(projectBrowserPos==guiGetAreaListLen(aContext), projects[i].selected);
				if (projectBrowserPos==guiGetAreaListLen(aContext)) ycursor=y;

				guiSelectPen1Color(aContext, -1);
				guiSelectFillColor(aContext, color);
				guiDrawRect(aContext, 18, y, aContext->guiClientRect.right, y+14);
				if (thePlayingProject == i) {
					expandString(projects[i].projectName, (projects[i].modifiedFlag)?" *":NULL, " (", projects[i].projectPath, ") [playing]");
				} else {
					expandString(projects[i].projectName, (projects[i].modifiedFlag)?" *":NULL, " (", projects[i].projectPath, ")");
				}
				guiSelectPen1Color(aContext, textColor);
				guiDrawText(aContext, 20, y, theExpandedString, theExpandedStringLength);
				projectBrowserAddHitArea(aContext, y);
				y+=14;

				if (projects[i].unfolded) {
					if (projects[i].maxPatches>0) {
						guiSelectFillColor(aContext, 0xFFFFFF);
						guiDrawText(aContext, 40, y, strings[STRING_PATCHES_COLON][theCurrentLanguage]);
						y+=14;
						for(j=0;j<projects[i].maxPatches;j++) {
							int k;

							color=projectBrowserBackground(projectBrowserPos==guiGetAreaListLen(aContext), projects[i].patches[j].selected);
							if (projectBrowserPos==guiGetAreaListLen(aContext)) ycursor=y;

							if (theCurrentProject==i && currentPatch==j) {
								guiDrawText(aContext, 40, y, "==>", 3);	
							}

							drawExpandBox(aContext, 62, y, projects[i].patches[j].unfolded);

							guiSelectPen1Color(aContext, -1);
							guiSelectFillColor(aContext, color);
							guiDrawRect(aContext, 80, y, aContext->guiClientRect.right, y+14);
							if (0 == projects[i].patches[j].maxObjects) {
								expandString(projects[i].patches[j].patchName, " (empty)", NULL, NULL, NULL);
							} else {
								char tmpstr[256];
								sprintf(tmpstr, " (%d ", projects[i].patches[j].maxObjects);
								expandString(projects[i].patches[j].patchName, tmpstr, strings[(projects[i].patches[j].maxObjects==1)?STRING_MODULE:STRING_MODULES][theCurrentLanguage], ")", NULL);
							}
							guiSelectPen1Color(aContext, textColor);
							guiDrawText(aContext, 80, y, theExpandedString, theExpandedStringLength);
							projectBrowserAddHitArea(aContext, y);
							y+=14;
							if (projects[i].patches[j].unfolded) {
								guiSelectFillColor(aContext, 0xFFFFFF);
								for(k=0;k<projects[i].patches[j].maxObjects;k++) {
									color=projectBrowserBackground(projectBrowserPos==guiGetAreaListLen(aContext), projects[i].patches[j].objects[k].selected);
									if (projectBrowserPos==guiGetAreaListLen(aContext)) ycursor=y;
									guiSelectFillColor(aContext, color);
									if (objectTitles[projects[i].patches[j].objects[k].objectType]) {
										guiSelectPen1Color(aContext, -1);
										guiSelectFillColor(aContext, color);
										guiDrawRect(aContext, 100, y, aContext->guiClientRect.right, y+14);
										expandString(objectTitles[projects[i].patches[j].objects[k].objectType], NULL, NULL, NULL, NULL);
										guiSelectPen1Color(aContext, textColor);
										guiDrawText(aContext, 100, y, theExpandedString, theExpandedStringLength);
										projectBrowserAddHitArea(aContext, y);
										y+=14;
									}
								}
							}
						}
					}
					if (projects[i].maxSequencers>0) {
						int j;

						guiSelectFillColor(aContext, 0xFFFFFF);
						guiDrawText(aContext, 40, y, strings[STRING_SEQUENCERS_COLON][theCurrentLanguage]);
						y+=14;
						for(j=0;j<projects[i].maxSequencers;j++) {
							expandString("sequencer", NULL, NULL, NULL, NULL);
							guiDrawText(aContext, 80, y, theExpandedString, theExpandedStringLength);
							drawExpandBox(aContext, 62, y, true);
							y+=14;
						}
					}
#if 0
					if (projects[i].maxTracks>0) {
						guiSelectFillColor(aContext, 15);
						guiDrawText(aContext, 40, y, "Tracks:");
						y+=14;
						for(j=0;j<projects[i].maxTracks;j++) {
							if (projects[i].tracks[j].selected) {
								color=0x00FFFF;
							} else {
								color=0xFFFFFF;
							}
							if (projectBrowserPos == guiGetAreaListLen(aContext)) {
								color-=8;
							}
							guiSelectFillColor(aContext, color);
							expandString(projects[i].tracks[j].trackName, NULL, NULL, NULL, NULL);
							guiDrawText(aContext, 60, y, theExpandedString, theExpandedStringLength);
							projectBrowserAddHitArea(aContext, y);
							y+=14;
						}
					}
#endif

					if (projects[i].maxSamples>0) {
						guiSelectFillColor(aContext, 0xFFFFFF);
						guiDrawText(aContext, 40, y, "Samples", 7);
						y+=14;
					}
				}
			}


			if (y+guiGetVScrollPos(aContext->currentWindow)!=maxy || aContext->guiClientRect.bottom!=maxysize) {
				maxy=y+guiGetVScrollPos(aContext->currentWindow);
				maxysize=aContext->guiClientRect.bottom;
				guiVScrollRange(aContext->currentWindow, 0, maxy, maxysize);
				recalcCursor=true;
			}
			if (recalcCursor) {
				if (ycursor<0) {
					guiSetVScrollPos(aContext->currentWindow, guiGetVScrollPos(aContext->currentWindow)+ycursor);
				} else if (ycursor+14>aContext->guiClientRect.bottom && aContext->guiClientRect.bottom>14) {
					guiSetVScrollPos(aContext->currentWindow, guiGetVScrollPos(aContext->currentWindow)+ycursor-aContext->guiClientRect.top);
				}
				recalcCursor=false;
			}
		} break;
		case GUIEVENT_MOUSEBUTTON1DOWN: {
			int i;
			int areaCount=0;

			for(i=0;i<maxProjects;i++) {
				areaCount++;
				if (aContext->id==areaCount) {
					if (aContext->mouseClientX<20) {
						projects[i].unfolded = !projects[i].unfolded;
					}
					selectProject(i, ctrlPressed());
					transportWindowRefresh=true;
					break;
				}
				if (projects[i].unfolded) {
					int j;

#if 0
					for(j=0;j<projects[i].maxTracks;j++) {
						areaCount++;
						if (aContext->id==areaCount) {
							selectProjectBrowserItem(i, -1, -1, j, ctrlPressed());
							break;
						}
					}
#endif
					for(j=0;j<projects[i].maxPatches;j++) {
						areaCount++;
						if (aContext->id == areaCount) {
							if (aContext->mouseClientX<80) {
								projects[i].patches[j].unfolded = !projects[i].patches[j].unfolded;
							}
							selectProjectBrowserItem(i, j, -1, -1, ctrlPressed());
							break;
						}
						if (projects[i].patches[j].unfolded) {
							int k;

							for(k=0;k<projects[i].patches[j].maxObjects;k++) {
								if (++areaCount == aContext->id) {
									selectProjectBrowserItem(i, j, k, -1, ctrlPressed());
									break;
								}
							}
						}
					}
				}
			}
		} break;
		case GUIEVENT_MOUSEBUTTON1DCLK: {
			int i;
			int areaCount=0;

			for(i=0;i<maxProjects;i++) {
				areaCount++;
				if (aContext->id == areaCount) {
					projects[i].unfolded = !projects[i].unfolded;
					projectBrowserWindowRefresh=true;
					break;
				}
				if (projects[i].unfolded) {
					int j;

#if 0
					for(j=0;j<projects[i].maxTracks;j++) {
						areaCount++;
						if (aContext->id==areaCount) {
							selectProjectBrowserItem(i, -1, -1, j, ctrlPressed());
							break;
						}
					}
#endif
					for(j=0;j<projects[i].maxPatches;j++) {
						if (++areaCount == aContext->id == areaCount) {
							selectProjectBrowserItem(i, j, -1, -1, ctrlPressed());
							break;
						}
						if (projects[i].patches[j].unfolded) {
							int k;

							for(k=0;k<projects[i].patches[j].maxObjects;k++) {
								if (++areaCount == aContext->id) {
									selectProjectBrowserItem(i, j, k, -1, ctrlPressed());
									break;
								}
							}
						}
					}
				}
			}
		} break;
		case GUIEVENT_CHAR:
			switch(aContext->id) {
			case 3:
				// Ignore repeated events when key is held down
				if (!aContext->keyRepeatFlag) {
					saveStfToClipboard();
				}
				break;
			case 4:
				// Ignore repeated events when key is held down
				if (!aContext->keyRepeatFlag) {
					cloneSelected();
				}
				break;
			case 22:
				// Ignore repeated events when key is held down
				if (!aContext->keyRepeatFlag) {
					loadFromClipboard();
				}
				break;
			case 24:
				// Ignore repeated events when key is held down
				if (!aContext->keyRepeatFlag) {
					saveStfToClipboard();
					deleteSelected();
				}
				break;
			default:
				break;
			}
			break;
		case GUIEVENT_KEYDOWN: {
			switch(aContext->id) {
			case VK_ESCAPE:
				guiHideWindow(aContext->currentWindow);
				break;
			case VK_RETURN: {
					int i,j,k;
					int pos=0;

					for(i=0;i<maxProjects;i++) {
						if (projectBrowserPos == pos) {
							projects[i].unfolded = !projects[i].unfolded;
							selectProject(i, ctrlPressed());
							transportWindowRefresh=true;
							goto leaveProjectBrowserReturn;
						}
						pos++;
						if (projects[i].unfolded) {
							for(j=0;j<projects[i].maxTracks;j++) {
								if (projectBrowserPos==pos) {
									selectProjectBrowserItem(i, -1, -1, j, ctrlPressed());
									goto leaveProjectBrowserReturn;
								}
								pos++;
							}
							for(j=0;j<projects[i].maxPatches;j++) {
								if (projectBrowserPos==pos) {
									projects[i].patches[j].unfolded = !projects[i].patches[j].unfolded;
									selectProjectBrowserItem(i, j, -1, -1, ctrlPressed());
									goto leaveProjectBrowserReturn;
								}
								pos++;
								if (projects[i].patches[j].unfolded) {
									for(k=0;k<projects[i].patches[j].maxObjects;k++) {
										if (pos++ == projectBrowserPos) {
											selectProjectBrowserItem(i, j, k, -1, ctrlPressed());
											goto leaveProjectBrowserReturn;
										}
									}
								}
							}
						}
					}
				} leaveProjectBrowserReturn: break;
			case VK_SPACE: {
					int i,j,k;
					int pos=0;

					for(i=0;i<maxProjects;i++) {
						if (projectBrowserPos == pos) {
							selectProjectBrowserItem(i, -1, -1, -1, ctrlPressed());
							transportWindowRefresh=true;
							goto leaveProjectBrowserSpace;
						}
						pos++;
						if (projects[i].unfolded) {
							for(j=0;j<projects[i].maxTracks;j++) {
								if (projectBrowserPos==pos) {
									selectProjectBrowserItem(i, -1, -1, j, ctrlPressed());
									goto leaveProjectBrowserSpace;
								}
								pos++;
							}
							for(j=0;j<projects[i].maxPatches;j++) {
								if (projectBrowserPos==pos) {
									selectProjectBrowserItem(i, j, -1, -1, ctrlPressed());
									goto leaveProjectBrowserSpace;
								}
								pos++;
								if (projects[i].patches[j].unfolded) {
									for(k=0;k<projects[i].patches[j].maxObjects;k++) {
										if (pos++ == projectBrowserPos) {
											selectProjectBrowserItem(i, j, k, -1, ctrlPressed());
											goto leaveProjectBrowserSpace;
										}
									}
								}
							}
						}
					}  
				} leaveProjectBrowserSpace: break;
			case VK_UP:
				if (projectBrowserPos>0) {
					projectBrowserPos--;
					projectBrowserWindowRefresh=true;
					recalcCursor=true;
				}
				break;
			case VK_DOWN:
				if (projectBrowserPos<guiGetAreaListLen(aContext)-1) {
					projectBrowserPos++;
					projectBrowserWindowRefresh=true;
					recalcCursor=true;
				}
				break;
			case VK_DELETE:
				deleteSelected();
				break;
			default:
				break;
			}
		} break;
	case GUIEVENT_CLOSE:
		guiHideWindow(aContext->currentWindow);
		break;
	default:
		break;
	}
}
EOF

# if (defined($fth)) {
#	rc(<<EOF);
#static void fthTheCurrentProject(InterpreterPtr aInterpreter) {
#	fthDPush(aInterpreter, theCurrentProject);
#}
#EOF
#	cc('mainInit', 'addDictionaryEntry(theRootInterpreter, "theCurrentProject", fthTheCurrentProject);');
#}

genWindow('projectBrowserWindow', 'PROJECTWINDOW', '"Project Browser"', 'projectBrowserHandler', undef, undef, 1, 0, undef);
