##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Audio output scope
#
##########################################################################

ccModule('Audio Output Scope');

cc('showAudioOutputScope', 'guiShowWindow(scopeWindow);');

rd('const int SCOPEBUFSIZE=1024;');
rv('int scopeMode=0;');
rv('signed short DSP_ScopeL[SCOPEBUFSIZE]; // Scope buffer for left channel');
rv('signed short DSP_ScopeR[SCOPEBUFSIZE]; // Scope buffer for right channel');
rv('volatile unsigned int DSP_ScopePosition=0; // Current position within buffers');

rc(<<EOF);
static void drawScopeTopBottom(ContextPtr aContext) {
	int cnt;
	int yRange;

//  clientRect=myRect;
	guiSelectPen1Color(aContext, 0x000000);
	guiSelectFillColor(aContext, 0x000000);
	guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);
	yRange=((aContext->guiClientRect.bottom-16)/4);

	guiSelectPen1Color(aContext, 0xFFFFFF);
	guiDrawLineFrom(aContext, 0, yRange-(DSP_ScopeL[0]*yRange)/32768);
	for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
		guiDrawLineTo(aContext, (cnt*aContext->guiClientRect.right)/SCOPEBUFSIZE, yRange-(DSP_ScopeL[cnt]*yRange)/32768);
	}

	guiDrawLineFrom(aContext, 0, 3*yRange+16-(DSP_ScopeR[0]*yRange)/32768);
	for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
		guiDrawLineTo(aContext, (cnt*aContext->guiClientRect.right)/SCOPEBUFSIZE, 3*yRange+16-(DSP_ScopeR[cnt]*yRange)/32768);
	}

	// Draw base lines
	guiSelectPen1Color(aContext, 0x00BB00);
	guiDrawLine(aContext, 0, yRange, aContext->guiClientRect.right,   yRange);
	guiDrawLine(aContext, 0, 3*yRange+16, aContext->guiClientRect.right, 3*yRange+16);

	guiSelectTitleFont(aContext);
	guiDrawTransparent(aContext);
	guiSetTextAlignment(aContext, alignBottomLeft);
	guiSelectPen1Color(aContext, 0x00BB00);
	guiDrawText(aContext, 2, 0, aContext->guiClientRect.right, yRange, "Left");
	guiDrawText(aContext, 2, 0, aContext->guiClientRect.right, 3*yRange+16, "Right");

	DSP_ScopePosition = 0;
}


static void drawScopeLeftRight(ContextPtr aContext) {
	int cnt;
	int yRange;
	int xRange;

	guiSelectPen1Color(aContext, 0x000000);
	guiSelectFillColor(aContext, 0x000000);
	guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);
	yRange=(aContext->guiClientRect.bottom/2);
	xRange=((aContext->guiClientRect.right-16)/2);

	guiSelectPen1Color(aContext, 0xFFFFFF);
	guiDrawLineFrom(aContext, 0, yRange-(DSP_ScopeL[0]*yRange)/32768);
	for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
		guiDrawLineTo(aContext, (cnt*xRange)/SCOPEBUFSIZE, yRange-(DSP_ScopeL[cnt]*yRange)/32768);
	}

	guiDrawLineFrom(aContext, xRange+16, yRange-(DSP_ScopeR[0]*yRange)/32768);
	for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
		guiDrawLineTo(aContext, (cnt*xRange)/SCOPEBUFSIZE+xRange+16, yRange-(DSP_ScopeR[cnt]*yRange)/32768);
	}

	// Draw base lines
	guiSelectPen1Color(aContext, 0x00BB00);
	guiDrawLine(aContext, 0, yRange, xRange, yRange);
	guiDrawLine(aContext, xRange+16, yRange, aContext->guiClientRect.right, yRange);

//  guiSelectPen1Color(aContext, 7);
	guiSelectTitleFont(aContext);
	guiDrawTransparent(aContext);
	guiSetTextAlignment(aContext, alignBottomLeft);
	guiSelectPen1Color(aContext, 0x00BB00);
	guiDrawText(aContext, 2, 0, aContext->guiClientRect.right, yRange, "Left");
	guiDrawText(aContext, xRange+18, 0, aContext->guiClientRect.right, yRange, "Right");

	DSP_ScopePosition = 0;
}
EOF

rc(<<EOF);
static void outputScopeHandler(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
			switch(scopeMode) {
			case 0:
				drawScopeTopBottom(aContext);
				break;
			case 1:
				drawScopeLeftRight(aContext);
				break;
			default:
				scopeMode=0;
				drawScopeTopBottom(aContext);
				break;
			}
		} break;
//  case GUIEVENT_MOUSEBUTTON1DOWN:
	case GUIEVENT_MOUSEBUTTON2DOWN:
		scopeMode=1-scopeMode;
		scopeWindowRefresh=true;
		break;
	case GUIEVENT_TIMERTICK:
		if (DSP_ScopePosition==4*SCOPEBUFSIZE) {
			scopeWindowRefresh=true;
		}
		break;
	case GUIEVENT_KEYDOWN:
		switch(aContext->id) {
		case VK_ESCAPE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		} break;
	case GUIEVENT_CLOSE:
		guiHideWindow(scopeWindow);
		break;
	default:
		break;
	}
}
EOF

genWindow('scopeWindow', 'SCOPEWINDOW2', '"Audio Output Scope"', 'outputScopeHandler', undef, undef, 0, 0, undef);
cc('windowInit', "guiRunTimer(scopeWindow, 100);");
cc('windowInit', "guiDoubleBuffer(scopeWindow, true);");
cc('stfSave', 'storeStfBegin(loadInfo, "AudioOutputScopeMode"); storeStfInteger(loadInfo, scopeMode); storeStfEnd(loadInfo);');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "AudioOutputScopeMode")==0) { readStfInteger(loadInfo, &scopeMode); }');
