##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Operating system suppport for Microsoft Windows.
#
##########################################################################

ccModule('Operating System support for Microsoft Windows');

sysInclude('windows.h');
sysInclude('windowsx.h');
sysInclude('commdlg.h');
sysInclude('stdlib.h');
sysInclude('stdio.h');
sysInclude('math.h');
sysInclude('string.h');
sysInclude('assert.h');

# VC6.0 specific includes
ri('#ifdef _MSC_VER');
sysInclude('process.h');
# ri('#pragma comment(linker,"/opt:nowin98 /MAP /MAPINFO:FIXUPS")');
ri('#pragma warning(disable:4100)');
ri('#pragma warning(disable:4711)');
ri('#pragma warning(disable:4996)');
ri('#endif');

rd(<<EOF);
#define lockMutex(object) EnterCriticalSection(&object)
#define unlockMutex(object) LeaveCriticalSection(&object)
EOF

sub mutex {
	my $mutexName=shift;

	rv("CRITICAL_SECTION $mutexName;");
	cc('mainInit', "InitializeCriticalSection(&$mutexName);");
	cci('mainTerm', "DeleteCriticalSection(&$mutexName);");
}

