##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Operating system suppport for Linux.
#
##########################################################################

ccModule('Operating System support for Linux');

sysInclude('unistd.h');
sysInclude('stdlib.h');
sysInclude('stdarg.h');
sysInclude('pthread.h');
sysInclude('stdio.h');
sysInclude('math.h');
sysInclude('string.h');
sysInclude('assert.h');

rd(<<EOF);
#define lockMutex(object) pthread_mutex_lock(&object)
#define unlockMutex(object) pthread_mutex_unlock(&object)

#ifndef stricmp
#define stricmp strcasecmp
#endif

#ifndef strnicmp
#define strnicmp strncasecmp
#endif

static inline int min(int a, int b) {
	return (a>b)?b:a;
}

static inline int max(int a, int b) {
	return (a>b)?a:b;
}
EOF


sub mutex {
	my $mutexName=shift;

	rv("pthread_mutex_t $mutexName;");
	cc('mainInit', "pthread_mutex_init(&$mutexName, NULL);");
	cci('mainTerm', "pthread_mutex_destroy(&$mutexName);");

}
