##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Lowlevel midi routines for Microsoft Windows.
#
##########################################################################

ccModule('Lowlevel midi routines for Win32.');


my @midiStructDef=('unsigned char fromPort;', 'unsigned char command;', 'unsigned char data1;', 'unsigned char data2;');
genEnumStruct("struct", "MidiMessage", \@midiStructDef);

rv('int noofMidiInDevices;');
rv('int noofMidiOutDevices;');
rv('const char **midiInDeviceNames;');
rv('const char **midiOutDeviceNames;');
rv('int *midiInPorts;');
rv('int *midiOutPorts;');

rv('HMIDIIN *midiInHandles;');
rv('HMIDIOUT *midiOutHandles;');


rc(<<EOF);
static void CALLBACK midiInProc(HMIDIIN hMidiIn, UINT wMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2) {
	if (wMsg==MIM_DATA) {
		routeMidiMessage((dwParam1&0x00FFFFFF)|(midiInPorts[dwInstance]<<24));
	}
}

static void setMidiInPort(int device, int port) {
	if (device>=0 && device<noofMidiInDevices) {
		lockMutex(midiMutex);
		if (port==0 && midiInPorts[device]>0) {
			midiInReset(midiInHandles[device]);
			midiInClose(midiInHandles[device]);
			midiInHandles[device]=NULL;
		}
		if (port>0 && midiInPorts[device]==0) {
			if (midiInOpen(&(midiInHandles[device]), device, (DWORD)midiInProc, device, CALLBACK_FUNCTION)==MMSYSERR_NOERROR) {
				midiInStart(midiInHandles[device]);
			} else {
				midiInHandles[device]=NULL;
			}
		}
		midiInPorts[device]=port;
		unlockMutex(midiMutex);
		configPanelWindowRefresh=true;
	}
}

static void setMidiOutPort(int device, int port) {
	if (device>=0 && device<noofMidiOutDevices) {
		lockMutex(midiMutex);
//		if (port==0) {
//      midiOutReset(midiOutHandles[device]);
//      midiOutClose(midiOutHandles[device]);
//		} else if (midiOutPorts[device]==0) {
//      midiOutOpen(&(midiOutHandles[device]), device, (DWORD)midiInProc, device, CALLBACK_FUNCTION);
//      midiOutStart(midiOutHandles[device]);
//		}
		midiOutPorts[device]=port;
		unlockMutex(midiMutex);
		configPanelWindowRefresh=true;
	}
}

static void openMidiRouter(void) {
	MIDIINCAPS midiInInfo;
	MIDIOUTCAPS midiOutInfo;
	int i;
	
	noofMidiInDevices=midiInGetNumDevs();
	midiInDeviceNames=(const char **)malloc((noofMidiInDevices+1)*sizeof(const char *));
	midiInPorts=(int *)calloc(noofMidiInDevices, sizeof(int));
	midiInHandles=(HMIDIIN *)calloc(noofMidiInDevices, sizeof(HMIDIIN));
	for(i=0;i<noofMidiInDevices;i++) {
		if (MMSYSERR_NOERROR==midiInGetDevCaps(i, &midiInInfo, (UINT)sizeof(MIDIINCAPS))) {
			midiInDeviceNames[i]=strdup(midiInInfo.szPname);
		} else {
			midiInDeviceNames[i]="(unknown)";
		}
	}
	midiInDeviceNames[noofMidiInDevices]=NULL;

	noofMidiOutDevices=midiOutGetNumDevs();
	midiOutDeviceNames=(const char **)malloc((noofMidiOutDevices+1)*sizeof(const char *));
	midiOutPorts=(int *)calloc(noofMidiOutDevices, sizeof(int));
	midiOutHandles=(HMIDIOUT *)calloc(noofMidiOutDevices, sizeof(HMIDIOUT));
	for(i=0;i<noofMidiOutDevices;i++) {
		if (MMSYSERR_NOERROR==midiOutGetDevCaps(i, &midiOutInfo, (UINT)sizeof(MIDIOUTCAPS))) {
			midiOutDeviceNames[i]=strdup(midiOutInfo.szPname);
		} else {
			midiOutDeviceNames[i]="(unknown)";
		}
	}
	midiOutDeviceNames[noofMidiOutDevices]=NULL;
}

static void closeMidiRouter(void) {
	int i;

	for(i=0;i<noofMidiInDevices;i++) {
		setMidiInPort(i, 0);
	}
	for(i=0;i<noofMidiOutDevices;i++) {
		setMidiOutPort(i, 0);
	}
}
EOF

cc('mainInit', 'openMidiRouter();');
cci('mainTerm', 'closeMidiRouter();');
cc('stfSave', '{ int i; for(i=0;i<noofMidiInDevices;i++) { storeStfBegin(loadInfo, "MidiInDevice"); storeStfInteger(loadInfo, i+1); storeStfInteger(loadInfo, midiInPorts[i]); storeStfEnd(loadInfo); } }');
cc('stfSave', '{ int i; for(i=0;i<noofMidiOutDevices;i++) { storeStfBegin(loadInfo, "MidiOutDevice"); storeStfInteger(loadInfo, i+1); storeStfInteger(loadInfo, midiOutPorts[i]); storeStfEnd(loadInfo); } }');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "MidiInDevice")==0) { int i,p; readStfInteger(loadInfo, &i); readStfInteger(loadInfo, &p); setMidiInPort(i-1, p); }');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "MidiOutDevice")==0) { int i,p; readStfInteger(loadInfo, &i); readStfInteger(loadInfo, &p); setMidiOutPort(i-1, p); }');

