##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Midi Scope
#
##########################################################################

ccModule('Midi scope');

cc('showMidiScope', 'guiShowWindow(midiScopeWindow);');
cc('routeMidiMessage', 'snoopMidiScope(aMidiMessage);');


rs(<<EOF);
static const int MAX_MIDI_SCOPE_EVENTS=4096; // Needs to be power of 2
static const int FILTERFLAGS=13;
static const int MIDICHANNELS=16;
#define MIDI_MONITOR_MASK (MAX_MIDI_SCOPE_EVENTS-1)

static int monitorTable[MAX_MIDI_SCOPE_EVENTS];
static int currentPosition;
static int lastPosition;
static bool monitorPortFlag[maxMidiPorts];
static bool monitorChannelFlag[16]={
	true,true,true,true,
	true,true,true,true,
	true,true,true,true,
	true,true,true,true
};
static bool filterFlag[FILTERFLAGS]={true, true, true, true, true, true, true, false, false, false, true, true, true};
static const char *midiScopeFilterNames[FILTERFLAGS]={"Note", "CCmsg", "Prog", "PBend", "KyAft", "ChAft", "Song", "Clock", "SMPTE", "ASens", "Tune", "Reset", "Other"};

static void snoopMidiScope(int aMidiMessage) {
	if (monitorPortFlag[(aMidiMessage>>24)-1]) {
		if (((aMidiMessage&0xF0)==0x80 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[0]) // Note Off
		 || ((aMidiMessage&0xF0)==0x90 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[0]) // Note On
		 || ((aMidiMessage&0xF0)==0xB0 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[1]) // CC message
		 || ((aMidiMessage&0xF0)==0xC0 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[2]) // Program change
		 || ((aMidiMessage&0xF0)==0xE0 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[3]) // PitchBend
		 || ((aMidiMessage&0xF0)==0xA0 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[4]) // Key aftertouch
		 || ((aMidiMessage&0xF0)==0xD0 && monitorChannelFlag[aMidiMessage&0x0F] && filterFlag[5]) // Channel aftertouch
		 || ((aMidiMessage&0xFF)==0xF2 && filterFlag[6])  // Song Position
		 || ((aMidiMessage&0xFF)==0xF3 && filterFlag[6])  // Song Select
		 || ((aMidiMessage&0xFF)==0xF8 && filterFlag[7])  // Clock
		 || ((aMidiMessage&0xFF)==0xF1 && filterFlag[8])  // SMPTE
		 || ((aMidiMessage&0xFF)==0xFE && filterFlag[9])  // Active Sense
		 || ((aMidiMessage&0xFF)==0xF6 && filterFlag[10]) // Tune request
		 || ((aMidiMessage&0xFF)==0xFF && filterFlag[11]) // Reset
		 || ((aMidiMessage&0xFF)==0xFA && filterFlag[6])  // Start
		 || ((aMidiMessage&0xFF)==0xFB && filterFlag[6])  // Continue
		 || ((aMidiMessage&0xFF)==0xFC && filterFlag[6])  // Stop
		 || ((aMidiMessage&0xFF)==0xF4 && filterFlag[12]) // Unknown
		 || ((aMidiMessage&0xFF)==0xF5 && filterFlag[12]) // Unknown
		 || ((aMidiMessage&0xFF)==0xF9 && filterFlag[12]) // Unknown
		 || ((aMidiMessage&0xFF)==0xFD && filterFlag[12]) // Unknown
			 ) {
			monitorTable[currentPosition]=aMidiMessage;
			currentPosition=(currentPosition+1)&MIDI_MONITOR_MASK;

			// Clear next row (to prevent display of very old data)
			monitorTable[currentPosition]=0;
			monitorTable[(currentPosition+1)&MIDI_MONITOR_MASK]=0;
			monitorTable[(currentPosition+2)&MIDI_MONITOR_MASK]=0;
			monitorTable[(currentPosition+3)&MIDI_MONITOR_MASK]=0;
		}
	}
}
EOF

rc(<<EOF);
static void midiScopeHandler(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
			int y;
			int x;
			int i;

			guiClearAreaList(aContext);
//      GuiRect fillRect=aContext->guiClientRect;
			int scrollpos=(MAX_MIDI_SCOPE_EVENTS-(guiGetVScrollPos(aContext->currentWindow)+15))&(~3);

//      fillRect.bottom-=66;

			guiSetTextAlignment(aContext, alignLineLeft);
			guiSelectPen1Color(aContext, 0xFFFFFF);
			guiSelectFillColor(aContext, 0xFFFFFF);
			guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom-61);

			guiDrawTransparent(aContext);
			guiSelectPen1Color(aContext, 0);

			guiSelectRouterFont(aContext);
			for(y=0;y<20;y++) {
				for(x=0;x<4;x++) {
					if (scrollpos+y*4+x<(MAX_MIDI_SCOPE_EVENTS-4)) {
						char buf[256];
						int pos=(((currentPosition)&(~3))+x-(scrollpos+y*4))&MIDI_MONITOR_MASK;

						switch(monitorTable[pos]&0xF0) {
						case 0x80:
							sprintf(buf, "%c%02d N.Off %3d %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255, (monitorTable[pos]>>16)&255);
							break;
						case 0x90:
							sprintf(buf, "%c%02d Note  %3d %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255, (monitorTable[pos]>>16)&255);
							break;
						case 0xA0:
							sprintf(buf, "%c%02d KyAft %3d %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255, (monitorTable[pos]>>16)&255);
							break;
						case 0xB0:
							sprintf(buf, "%c%02d CCmsg %3d %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255, (monitorTable[pos]>>16)&255);
							break;
						case 0xC0:
							sprintf(buf, "%c%02d Prog. %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255);
							break;
						case 0xD0:
							sprintf(buf, "%c%02d ChAft %3d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, (monitorTable[pos]>>8)&255);
							break;
						case 0xE0:
							sprintf(buf, "%c%02d PBend %6d", midiPortNames[monitorTable[pos]>>24], (monitorTable[pos]&15)+1, ((monitorTable[pos]>>16)&255)*128+((monitorTable[pos]>>8)&255));
							break;
						case 0xF0:
							switch(monitorTable[pos]&0x0F) {
							case 0x01:
								sprintf(buf, "%c-- SMPTE", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x02:
								sprintf(buf, "%c-- SongPos.", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x03:
								sprintf(buf, "%c-- SongSel.", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x04:
								sprintf(buf, "%c-- 0xF4", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x05:
								sprintf(buf, "%c-- 0xF5", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x06:
								sprintf(buf, "%c-- TuneRequest", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x07:
//                sprintf(buf, "%c-- ", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x08:
								sprintf(buf, "%c-- Clock", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x09:
								sprintf(buf, "%c-- 0xF9", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0A:
								sprintf(buf, "%c-- Start", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0B:
								sprintf(buf, "%c-- Continue", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0C:
								sprintf(buf, "%c-- Stop", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0D:
								sprintf(buf, "%c-- 0xFD", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0E:
								sprintf(buf, "%c-- Active", midiPortNames[monitorTable[pos]>>24]);
								break;
							case 0x0F:
								sprintf(buf, "%c-- Reset", midiPortNames[monitorTable[pos]>>24]);
								break;
							}
							break;
						default:
							continue;
						}
						guiDrawText(aContext, x*142+8, aContext->guiClientRect.bottom-(88+y*14), buf, strlen(buf));
					}
				}
			}

			guiSelectFillColor(aContext, -1);
			guiSelectTitleFont(aContext);

			// Draw filter buttons
			guiSelectRouterFont(aContext);
			for(i=0;i<FILTERFLAGS;i++) {
				GuiRect rect;
				rect.left=i*44;
				rect.top=aContext->guiClientRect.bottom-60;
				rect.right=i*44+44;
				rect.bottom=aContext->guiClientRect.bottom-40;
				guiDraw3dRect(aContext, rect.left, rect.top, rect.right, rect.bottom, filterFlag[i]);
				guiDrawText(
					aContext,
					i*44+2,
					aContext->guiClientRect.bottom-60,
					i*44+44,
					aContext->guiClientRect.bottom-40,
					midiScopeFilterNames[i]);
				guiAddArea(aContext, rect.left, rect.top, rect.right, rect.bottom);
			}

			// Draw port selection buttons
			for(i=0;i<maxMidiPorts;i++) {
				guiAddArea(aContext, i*22, aContext->guiClientRect.bottom-44, i*22+22, aContext->guiClientRect.bottom-22);
				GuiRect rect;
				rect.left=i*22;
				rect.top=aContext->guiClientRect.bottom-40;
				rect.right=i*22+22;
				rect.bottom=aContext->guiClientRect.bottom-20;
				guiDraw3dRect(aContext, rect.left, rect.top, rect.right, rect.bottom, monitorPortFlag[i]);
				guiDrawText(
					aContext,
					i*22+4,
					aContext->guiClientRect.bottom-40,
					i*22+22,
					aContext->guiClientRect.bottom-20,
					&midiPortNames[i+1], 1);
			}

			// When program has limited midi support (sf lite?) fill rest with blanks
			for(;i<26;i++) {
				GuiRect rect;
				rect.left=i*22;
				rect.top=aContext->guiClientRect.bottom-40;
				rect.right=i*22+22;
				rect.bottom=aContext->guiClientRect.bottom-20;
				guiDraw3dRect(aContext, rect.left, rect.top, rect.right, rect.bottom, FALSE);
			}

			// Draw channel selection buttons
			guiSelectTitleFont(aContext);
			for(i=0;i<MIDICHANNELS;i++) {
				char buf[16];
				GuiRect rect;
				rect.left=i*35;
				rect.top=aContext->guiClientRect.bottom-20;
				rect.right=i*35+35;
				rect.bottom=aContext->guiClientRect.bottom-1;
				guiDraw3dRect(aContext, rect.left, rect.top, rect.right, rect.bottom, monitorChannelFlag[i]);
				sprintf(buf, "%d", i+1);
				guiDrawText(
					aContext,
					i*35+4,
					aContext->guiClientRect.bottom-20,
					i*35+35,
					aContext->guiClientRect.bottom-1,
					buf);
				guiAddArea(aContext, rect.left, rect.top, rect.right, rect.bottom);
			}

			{
				GuiRect rect;
				rect.left=16*35;
				rect.right=aContext->guiClientRect.right;
				rect.top=aContext->guiClientRect.bottom-20;
				rect.bottom=aContext->guiClientRect.bottom-1;
				guiSelectFillColor(aContext, -1);
				guiDraw3dRect(aContext, rect.left, rect.top, rect.right, rect.bottom, false);
			}
		} break;
	case GUIEVENT_MOUSEBUTTON1DOWN: {
			if (aContext->id>0) {
				if (aContext->id>FILTERFLAGS+maxMidiPorts) {
					monitorChannelFlag[aContext->id-(FILTERFLAGS+maxMidiPorts+1)]=!monitorChannelFlag[aContext->id-(FILTERFLAGS+maxMidiPorts+1)];
					midiScopeWindowRefresh=true;
				} else if (aContext->id>FILTERFLAGS) {
					monitorPortFlag[aContext->id-(FILTERFLAGS+1)]=!monitorPortFlag[aContext->id-(FILTERFLAGS+1)];
					midiScopeWindowRefresh=true;
				} else {
					filterFlag[aContext->id-1]=!filterFlag[aContext->id-1];
					midiScopeWindowRefresh=true;
				}
			}
		} break;
	case GUIEVENT_TIMERTICK: {
			if (currentPosition!=lastPosition) {
				lastPosition=currentPosition;
				midiScopeWindowRefresh=true;
			}
		} break;
	case GUIEVENT_KEYDOWN:
		switch(aContext->id) {
		case VK_ESCAPE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		} break;
	case GUIEVENT_CLOSE:
		guiHideWindow(aContext->currentWindow);
		break;
	default:
		break;
	}
}
EOF

# !!!TODO: remove test on platformos
#if (lc $platformOs eq 'linux') {
#	genWindow('midiScopeWindow', 'MIDISCOPEWINDOW', '"Midi Scope"', 'midiScopeHandler', 572, 360, 1, 0, 1);
#} else {
genWindow('midiScopeWindow', 'MIDISCOPEWINDOW', '"Midi Scope"', 'midiScopeHandler', '572+GetSystemMetrics(SM_CXVSCROLL)', 360, 1, 0, 1);
#}

cc('windowInit', "guiVScrollRange(midiScopeWindow, 0, MAX_MIDI_SCOPE_EVENTS, 16);");
cc('windowInit', "guiVScrollWindowTo(midiScopeWindow, MAX_MIDI_SCOPE_EVENTS);");
cc('windowInit', "guiRunTimer(midiScopeWindow, 100);");

cc('stfSave', '{ int i; storeStfBegin(loadInfo, "MidiIScopeSettings"); for(i=0;i<maxMidiPorts;i++) { storeStfInteger(loadInfo, monitorPortFlag[i]?1:0); } for(i=0;i<16;i++) { storeStfInteger(loadInfo, monitorChannelFlag[i]?1:0); } for(i=0;i<FILTERFLAGS;i++) { storeStfInteger(loadInfo, filterFlag[i]?1:0); } storeStfEnd(loadInfo); }');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "MidiIScopeSettings")==0) { int i,f; for(i=0;i<maxMidiPorts;i++) { readStfInteger(loadInfo, &f); monitorPortFlag[i]=(f!=0); } for(i=0;i<16;i++) { readStfInteger(loadInfo, &f); monitorChannelFlag[i]=(f!=0); } for(i=0;i<FILTERFLAGS;i++) { readStfInteger(loadInfo, &f); filterFlag[i]=(f!=0); } }');

