##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Midi Activity Monitor
#
##########################################################################

ccModule('Midi activity monitor');

cc('showMidiActivityMonitor', 'guiShowWindow(midiActivityMonitorWindow);');
cc('routeMidiMessage', 'snoopMidiActivity(aMidiMessage);');

	rd("static const int midiActivityLedSize=10;");

# !!! hack
	

rv('int midiActivityLedOld[maxMidiPorts][17];');
rv('int midiActivityLedBlink[maxMidiPorts][17];');
rv('bool midiActivityFlag;');

rs(<<EOF);
static void snoopMidiActivity(int msg) {
	if ((msg&0xF0)==0xF0) {
		midiActivityLedBlink[(msg>>24)-1][16]=min(11,midiActivityLedBlink[(msg>>24)-1][16]+4);
	} else {
		midiActivityLedBlink[(msg>>24)-1][msg&0x0F]=min(11,midiActivityLedBlink[(msg>>24)-1][msg&0x0F]+4);
	}
	midiActivityFlag=true;
}
EOF

rc(<<EOF);
// !!! hack

static const char * const rownames="01020304050607080910111213141516RT";

static int midiActivityColor[12]={0x333333, 0x444444, 0x555555, 0x666666, 0x666666, 0x667777, 0x668888, 0x66AAAA, 0x66BBBB, 0x66CCCC, 0x66DDDD, 0x66EEEE};
static void midiActivityMonitorDrawLeds(ContextPtr aContext, bool forceUpdate) {
	int x,y;

	guiSelectPen1Color(aContext, -1);
	for(x=0;x<maxMidiPorts;x++) {
		for(y=0;y<17;y++) {
			if (forceUpdate || midiActivityLedBlink[x][y]!=midiActivityLedOld[x][y]) {
				int blink=midiActivityLedBlink[x][y];
				
				guiSelectFillColor(aContext, midiActivityColor[blink]);
				guiDrawEllipse(aContext, x*midiActivityLedSize+20, y*midiActivityLedSize+16, x*midiActivityLedSize+20+midiActivityLedSize-2, y*midiActivityLedSize+16+midiActivityLedSize-2);
				midiActivityLedOld[x][y]=midiActivityLedBlink[x][y];
			}
			if (midiActivityLedBlink[x][y]>0) {
				midiActivityLedBlink[x][y]--;
				midiActivityFlag=true; // Must turn led off later
			}
		}
	}
}

static void midiActivityMonitorHandler(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
			int x,y;

			guiSelectFillColor(aContext, 0);
			guiSelectPen1Color(aContext, 0);
			guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);

			guiSelectPen1Color(aContext, 0xFFFFFF);
			guiDrawTransparent(aContext);

			guiSetTextAlignment(aContext, alignTopCenter);
			guiSelectIOFont(aContext);
			for(x=0;x<maxMidiPorts;x++) {
				guiDrawText(
					aContext,
					x*midiActivityLedSize+20,
					0,
					x*midiActivityLedSize+midiActivityLedSize+19,
					18,
					&midiPortNames[x+1], 1);
			}
			guiSetTextAlignment(aContext, alignTopLeft);
			guiSelectIOFont(aContext);
			for(y=0;y<17;y++) {
				guiDrawText(
					aContext,
					2,
					y*midiActivityLedSize+14,
					19,
					y*midiActivityLedSize+midiActivityLedSize+14,
					&rownames[y*2], 2);
			}

			guiDrawOpaque(aContext);
			midiActivityMonitorDrawLeds(aContext, true);
		} break;
	case GUIEVENT_TIMERTICK: {
			if (midiActivityFlag) {
//        midiActivityMonitorWindowRefresh=true;
				midiActivityFlag=false;
				midiActivityMonitorDrawLeds(aContext, false);
			}
		}
		break;
	case GUIEVENT_KEYDOWN:
		switch(aContext->id) {
		case VK_ESCAPE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		} break;
	case GUIEVENT_CLOSE:
		guiHideWindow(aContext->currentWindow);
		break;
	default:
		break;
	}
}
EOF


genWindow('midiActivityMonitorWindow', 'MIDIACTIVITYWINDOW', '"Midi Activity Monitor"', 'midiActivityMonitorHandler', 'midiActivityLedSize*maxMidiPorts+20', 'midiActivityLedSize*17+16', 0, 0, 1);
cc('windowInit', "guiRunTimer(midiActivityMonitorWindow, 50);");


