##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Midi
#
##########################################################################

ccModule('Midi');

rd("static const int maxMidiPorts=26;");
rv('const char * const midiPortNames="-ABCDEFGHIJKLMNOPQRSTUVWXYZ";');

mutex('midiMutex');


rc(<<EOF);
//
// Midi message format
//                     7..0  MIDI command
//               15..8       MIDI data 1
//        23..16             MIDI data 2
// 29..24                    port (1-27)
//
static void routeMidiMessage(int aMidiMessage) {  
	lockMutex(midiMutex);
	~cc~routeMidiMessage~
	unlockMutex(midiMutex);
}

static void routeMidiMessage(int aPort, int aCommand, int aParam1, int aParam2) {
	assert(aPort >= 0);
	assert(aPort <= maxMidiPorts);
	routeMidiMessage((aPort << 24) | aCommand | (aParam1<<8) | (aParam2<<16));
}
EOF