##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Menu support for Qt
#
##########################################################################

include('<qmenudata.h>');
include('<qmenubar.h>');

cc('theCurrentLanguage', 'rebuildMenu();');

# !!!TODO forward declaration should not be necessary
rd('static void rebuildMenu(void);');

rc(<<EOF);
#if 0
static void rebuildMenus(void) {
	MenuDefPtr p = mainMenuDef;

	mainWindow->menuBar()->clear();

	while(p->menuItemType) {
		switch(p->menuItemType) {
		case -2:
			mainWindow->menuBar()->addSeperator();
			break;
		case -1:
			if (p->menuItemName[theCurrentLanguage]) {
				mainWindow->menuBar()->addMenu(p->menuItemName[theCurrentLanguage]);
			} else {
				mainWindow->menuBar()->addMenu(p->menuItemName[0]);
			}
		default:
			if (p->menuItemName[theCurrentLanguage]) {
				mainWindow->menuBar()->addAction(p->menuItemName[theCurrentLanguage]);
			} else {
				mainWindow->menuBar()->addAction(p->menuItemName[0]);
			}
		}
		p++;
	}
}
#endif

//class GuiPopupMenu: public QPopupMenu {
//public:
//	void activated ( int id ) {
//	}
//};

//class guiMenuBar: public QMenuBar {
//public:
//	guiMenuBar(QWidget *aParent): QMenuBar(aParent) {
//		logprintf("guiMenuBar in guiMenuBar\\n");
//		logprintf("loc %d\\n", (int)(void*)this);
//		this->show();
//	}

//signals:
//	void activated(int aId) {
//		logprintf("activated id = %d\\n", aId);
//	}
//
//	void highlighted(int aId) {
//		logprintf("highlighted id = %d\\n", aId);
//	}
//};


static QPopupMenu *rebuildMenuHelper(MenuDefPtr *p) {
	QPopupMenu *myMenu = new QPopupMenu;

	while((*p)->menuItemType) {
		const char *subMenuName=(*p)->menuItemName[theCurrentLanguage];
		if (!subMenuName) {
			subMenuName=(*p)->menuItemName[0];
		}

		switch((*p)->menuItemType) {
		case -2:
			myMenu->insertSeparator();
			(*p)++;
			break;
		case -1:
			(*p)++;
			myMenu->insertItem(subMenuName, rebuildMenuHelper(p));
			break;
		default:
			myMenu->insertItem(subMenuName, (*p)->menuItemType);
			(*p)++;
			break;
		}
	}
	(*p)++;

	return myMenu;
}

static void rebuildMenu(void) {
	MenuDefPtr p = mainMenuDef;

	GuiMainWindowPtr(mainWindow)->menuBar()->clear();
//	logprintf("loc %d\\n", (int)(void*)mainWindow->menuBar());

	while(p->menuItemType) {
		const char *subMenuName=p->menuItemName[theCurrentLanguage];
		if (!subMenuName) {
			subMenuName=p->menuItemName[0];
		}

		switch(p->menuItemType) {
		case -2:
			GuiMainWindowPtr(mainWindow)->menuBar()->insertSeparator();
			p++;
			break;
		case -1:
			p++;
			GuiMainWindowPtr(mainWindow)->menuBar()->insertItem(subMenuName, rebuildMenuHelper(&p));
			break;
		default:
			if (p->menuItemName[theCurrentLanguage]) {
				GuiMainWindowPtr(mainWindow)->menuBar()->insertItem(p->menuItemName[theCurrentLanguage]);
			} else {
				GuiMainWindowPtr(mainWindow)->menuBar()->insertItem(p->menuItemName[0]);
			}
			p++;
			break;
		}
	}
}
EOF
