##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Menu and submenu generation
#
##########################################################################

ccModule('menu generation');


my @menuEnum;


sub genMenuDef {
	my $menuname = shift;
	my $filename = shift;
	my @menuStruct = ();

	open(MENU, $filename) || die "Can't open $filename";
	while(<MENU>) {
		s/\r//;
		s/\n//;
		if (!m/^\#/) {
			if (m/^\+\s+(.+)/) {
				push(@menuStruct, "{-1, {$1}}");
			} elsif (m/^\-/) {
				push(@menuStruct, "{-2, {NULL}}");
			} elsif (m/^\./) {
				push(@menuStruct, "{0, {NULL}}");
			} elsif (m/^(.+?)\s+(.+)/) {
				push(@menuEnum, $1);
				push(@menuStruct, "{$1, {$2}}");
			}
		}
	}
	close(MENU);

	genTable("MenuDef", $menuname, \@menuStruct);
}

my @structdef=('int menuItemType;','const char *menuItemName[noofLanguages];');
genEnumStruct("struct", "MenuDef", \@structdef);

@menuEnum=('MENU_NONE');
# my @empty=();
genMenuDef('mainMenuDef', 'studiofactory_mainmenu.txt');
genEnumStruct("enum", "MenuEnum", \@menuEnum, ',');

# if ((lc $platformGraphics) eq 'gdi') {
cc('theCurrentLanguage', 'guiSetMenu(mainWindow, mainMenu[theCurrentLanguage]);');
cc('theCurrentCableColorIndex', 'for(int i=0;i<noofCableColors;i++) {');
cc('theCurrentCableColorIndex', "\tmarkMenuItem(mainMenu, MENU_CABLECOLOR_0+i, i==index);");
cc('theCurrentCableColorIndex', "\tmarkMenuItem(synFactoryMenu, MENU_CABLECOLOR_0+i, i==index);");
cc('theCurrentCableColorIndex', '}');


rs(<<EOF);
static GuiMenu makeMenuHelper(MenuDefPtr *menuDef1, MenuDefPtr *menuDef2, int language, bool popupMenu) {
	GuiMenu myMenu;

	if (popupMenu) {
		myMenu=guiCreatePopupMenu();
	} else {
		myMenu=guiCreateMenu();
	}

	while (menuDef1) {
		while((*menuDef1)->menuItemType!=0) {
			switch((*menuDef1)->menuItemType) {
			case -2:
				AppendMenu(myMenu, MF_SEPARATOR, 0, NULL);
				(*menuDef1)++;
				break;
			case -1: {
					GuiMenu subMenu;
					const char *subMenuName=(*menuDef1)->menuItemName[language];

					if (NULL==subMenuName) {
						subMenuName=(*menuDef1)->menuItemName[0];
					}
					(*menuDef1)++;
					subMenu=makeMenuHelper(menuDef1, NULL, language, false);
					AppendMenu(myMenu, MF_POPUP, (UINT)subMenu, subMenuName);
				} break;
			default:
				const char *subMenuName=(*menuDef1)->menuItemName[language];

				if (NULL==subMenuName) {
					subMenuName=(*menuDef1)->menuItemName[0];
				}
				AppendMenu(myMenu, MF_STRING, (MenuEnum)((*menuDef1)->menuItemType), subMenuName);
				(*menuDef1)++;
				break;
			}
		}
		(*menuDef1)++;
		menuDef1=menuDef2;
		menuDef2=NULL;
	}

	return myMenu;
}

static GuiMenu makeMenu(MenuDefPtr menuDef1, MenuDefPtr menuDef2, int language, bool popupMenu) {
	MenuDefPtr myPtr1=menuDef1;
	MenuDefPtr myPtr2=menuDef2;

	if (myPtr2) {
		return makeMenuHelper(&myPtr1, &myPtr2, language, popupMenu);
	} else {
		return makeMenuHelper(&myPtr1, NULL, language, popupMenu);
	}
}

static void markMenuItem(GuiMenu *menu, int id, bool checkmark) {
	int i;

	for(i=0;i<noofLanguages;i++) {
		CheckMenuItem(menu[i], id, MF_BYCOMMAND | ((checkmark)?MF_CHECKED:MF_UNCHECKED));
	}
}
EOF

rv('GuiMenu mainMenu[noofLanguages];');
cc('mainInit', "for(i=0;languageCodes[i];i++) { mainMenu[i] = makeMenu(mainMenuDef, NULL, i, false); }");
cci('mainTerm', "for(i=0;languageCodes[i];i++) { guiDestroyMenu(mainMenu[i]); }");

if (0) {
rc(<<EOF);
//static GuiMenu makeMenuHelper(MenuDefPtr *menuDef1, MenuDefPtr *menuDef2, int language, bool popupMenu) {
//	GuiMenu myMenu;
//
//	if (popupMenu) {
//		myMenu=guiCreatePopupMenu();
//	} else {
//		myMenu=guiCreateMenu();
//	}
//
//	while (menuDef1) {
//		while((*menuDef1)->menuItemType!=0) {
//			switch((*menuDef1)->menuItemType) {
//			case -2:
//				AppendMenu(myMenu, MF_SEPARATOR, 0, NULL);
//				(*menuDef1)++;
//				break;
//			case -1: {
//					GuiMenu subMenu;
//					const char *subMenuName=(*menuDef1)->menuItemName[language];
//
//					if (NULL==subMenuName) {
//						subMenuName=(*menuDef1)->menuItemName[0];
//					}
//					(*menuDef1)++;
//					subMenu=makeMenuHelper(menuDef1, NULL, language, false);
//					AppendMenu(myMenu, MF_POPUP, (UINT)subMenu, subMenuName);
//				} break;
//			default:
//				const char *subMenuName=(*menuDef1)->menuItemName[language];
//
//				if (NULL==subMenuName) {
//					subMenuName=(*menuDef1)->menuItemName[0];
//				}
//				AppendMenu(myMenu, MF_STRING, (MenuEnum)((*menuDef1)->menuItemType), subMenuName);
//				(*menuDef1)++;
//				break;
//			}
//		}
//		(*menuDef1)++;
//		menuDef1=menuDef2;
//		menuDef2=NULL;
//	}
//
//	return myMenu;
//}

static GuiMenu makeMenu(MenuDefPtr menuDef1, MenuDefPtr menuDef2, int language, bool popupMenu) {
//	MenuDefPtr myPtr1=menuDef1;
//	MenuDefPtr myPtr2=menuDef2;
//
//	if (myPtr2) {
//		return makeMenuHelper(&myPtr1, &myPtr2, language, popupMenu);
//	} else {
//		return makeMenuHelper(&myPtr1, NULL, language, popupMenu);
//	}
	return NULL; // !!!FIXME
}

//static void makeMainMenu(QMenuBar *mainMenuBar, MenuDefPtr aMenuDef, int language) {
//	QMenuBar myMenuBar = new QMenuBar;
//
//	mainMenuBar->clear();
//}

//static void markMenuItem(GuiMenu *menu, int id, bool checkmark) {
//	int i;
//
//	for(i=0;i<noofLanguages;i++) {
//		CheckMenuItem(menu[i], id, MF_BYCOMMAND | ((checkmark)?MF_CHECKED:MF_UNCHECKED));
//	}
//}
EOF

#	rv('GuiMenu mainMenu[noofLanguages];');
#	cc('mainInit', "for(i=0;languageCodes[i];i++) { mainMenu[i] = makeMenu(mainMenuDef, NULL, i, false); }");
#	cci('mainTerm', "for(i=0;languageCodes[i];i++) { guiDestroyMenu(mainMenu[i]); }");
}

