##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Load text-strings in multiple languages
#
##########################################################################
my @languageCodes=();
my $noofLanguages=1;

my @languageEnum=();
my @languageCodesStr=();

open(LANGUAGES, 'languages.txt') || die "Can't open languages.txt";
while(<LANGUAGES>) {
	if (m/(.+?)\s+([a-zA-Z]+)/) {
		push(@languageEnum, $1);
		push(@languageCodes, $2);
		push(@languageCodesStr, "\"$2\"");
	}
}
close(LANGUAGES);

$noofLanguages=scalar(@languageEnum);
#  genEnumStruct("enum", "Language", \@languageEnum, ',');
push(@languageCodesStr, 'NULL');
genTable("const char * const", "languageCodes", \@languageCodesStr);
rd("static const int noofLanguages=$noofLanguages;");
	
rc(<<EOF);
static void setLanguageIndex(int languageIndex) {
	theCurrentLanguage=languageIndex;
//	guiSetMenu(mainWindow, mainMenu[theCurrentLanguage]);
	~cc~theCurrentLanguage~
}

static void setLanguage(const char *languageCode) {  
	int i;

	theCurrentLanguage=0;
	for(i=0;languageCodes[i];i++) {
		if (strcmp(languageCode, languageCodes[i])==0) {
			setLanguageIndex(i);
			break;
		}
	}
}
EOF

rv('int theCurrentLanguage;');
cc('stfLoad', 'if (strcmp("ProgramLanguage", loadInfo->headerTitle)==0) { char languageCode[4]; readStfString(loadInfo, languageCode, 4); setLanguage(languageCode); }');
cc('stfSave', 'storeStfBegin(loadInfo, "ProgramLanguage"); storeStfString(loadInfo, languageCodes[theCurrentLanguage]); storeStfEnd(loadInfo);');

##########################################################################
#
# Strings
#
##########################################################################
sub genStrings {
	my @stringsEnum=();
	my @stringsTable=();
	my $language;

	ccModule('Multi-language strings');
	foreach $language (@languageCodes) {
		my $filename = lc "studiofactory_lang_${language}.txt";
		my $texFile;
		my $replaceWithNull=0;
		my $i=0;

		print "parse $filename\n";
		open(FILE, $filename) || die "can't open $filename";
		while(<FILE>) {
			s/\n//;
			s/\r//;
			if (/([a-zA-Z0-9_]+)\s+(\".*\")$/) {
				if (!defined($stringsEnum[$i]) || ($stringsEnum[$i] eq $1)) {
					$stringsEnum[$i]=$1;
					if (defined($stringsTable[$i])) {
						$stringsTable[$i] .= ",";
					}
					$stringsTable[$i] .= "$2";
				} else {
					die "enum $stringsEnum[$i] and $1 mismatch while reading $filename";
				}
				$i++;
			}
		}
		close(FILE);
	
		$filename = lc "docs/user_manual/studiofactory_${language}.tex";
		if (! -e $filename) {
			# replace with english version if specific language file doesn't exists
			print "!!!!! Missing $filename will use ";
			$filename = lc "docs/user_manual/studiofactory_en.tex";
			$replaceWithNull = 1;
		}
		print "parse $filename\n";
		$texFile = readCompleteFile($filename);
		
		# remove tabs and carriage linefeeds
		$texFile =~  s@\t@ @g;
		$texFile =~  s@\n@ @g;
		# convert tex to html
		$texFile =~ s@\$@@g;
		$texFile =~ s@\\textbf\{(.*?[^\\])\}@<B>$1</B>@g;
		$texFile =~ s@\\uline\{(.*?)\}@<U>$1</U>@g;
		$texFile =~ s@\{\\em\s(.*?)\}@<I>$1</I>@g;
		$texFile =~ s@\\leqslant@<U>&lt;</U>@g;
		$texFile =~ s@\\subsection\{(.*?)\}\s+?@<p><h1>$1</h1></p>@g;
		$texFile =~ s@\\subsubsection\{(.*?)\}\s+?@<p><h2>$1</h2></p>@g;
		$texFile =~ s@\\\%@%@g;
		$texFile =~ s@\\\#@#@g;
		$texFile =~ s@\\\{@{@g;
		$texFile =~ s@\\\}@}@g;
		$texFile =~ s@\\\\\s*@<BR>@g;
		# remove double spaces
		$texFile =~ s@\s+@ @g;
		
		while($texFile =~ s@\%\s\{\{\{\s([_A-Za-z0-9]+)\s(.*?)\%\s\}\}\}@@) {
			my $enumName = $1;
			my $helpText = $2;
			
			if (!defined($stringsEnum[$i]) || ($stringsEnum[$i] eq $enumName)) {
				$stringsEnum[$i]=$enumName;
				if (defined($stringsTable[$i])) {
					$stringsTable[$i] .= ",";
				}
				if ($replaceWithNull) {
					$stringsTable[$i] .= 'NULL';
				} else {
					while (length($helpText)>60) {
						$stringsTable[$i] .= "\n\t\"" . substr($helpText, 0, 60) . "\"";
						$helpText = substr($helpText, 60);
					}
					if (length($helpText)>0) {
						$stringsTable[$i] .= "\n\t\"" . $helpText . "\"";
					}
				}
			} else {
				die "enum $stringsEnum[$i] and $1 mismatch while reading $filename";
			}
			$i++;
		}
	}

	for(my $i=0;$i<scalar(@stringsTable);$i++) {
		$stringsTable[$i] = '{' . $stringsTable[$i] . '}';
	}

	genEnumStruct("enum", "StringIndex", \@stringsEnum, ',');
	genTable("const char * const", "strings", \@stringsTable, "[noofLanguages]");
}

genStrings();
