##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Joystick Input
#
##########################################################################

setvar('int', 'theJoystickMode');
rv('HANDLE joystickThreadHandle;');
rv('DWORD joystickThreadID;');
rv('int JoyXpos;');
rv('int JoyYpos;');
rv('int JoyZpos;');
rv('int JoyRpos;');
rv('int JoyUpos;');
rv('int JoyVpos;');
rv('int JoyBut[4];');

rc(<<EOF);
#include "sf_external.h"
HINSTANCE                 externalDLL=NULL;
external_getversion_Func  external_getversion;
external_initdll_Func     external_initdll;
external_deinitdll_Func   external_deinitdll;
external_getvalues_Func   external_getvalues;

static DWORD joystickThread(LPDWORD lpdwParam) {
  for(;;) {
    /* ScanJoystick */
    JOYINFOEX JoyStickInfo;
    JoyStickInfo.dwSize=sizeof(JoyStickInfo);
    JoyStickInfo.dwFlags=JOY_RETURNALL;    
    if (theJoystickMode==1 && JOYERR_NOERROR==joyGetPosEx(JOYSTICKID1, &JoyStickInfo)) {
      JoyXpos=limit(JoyStickInfo.dwXpos-32768);
      JoyYpos=-limit((JoyStickInfo.dwYpos-32767));
      JoyZpos=-limit((JoyStickInfo.dwZpos-32767));
      JoyRpos=limit(JoyStickInfo.dwRpos-32768);
      JoyUpos=limit(JoyStickInfo.dwUpos-32768);
      JoyVpos=limit(JoyStickInfo.dwVpos-32768);
      JoyBut[0]=(JoyStickInfo.dwButtons & JOY_BUTTON1)?32767:0;
      JoyBut[1]=(JoyStickInfo.dwButtons & JOY_BUTTON2)?32767:0;
      JoyBut[2]=(JoyStickInfo.dwButtons & JOY_BUTTON3)?32767:0;
      JoyBut[3]=(JoyStickInfo.dwButtons & JOY_BUTTON4)?32767:0;
      Sleep(50);
    } else if (theJoystickMode==2 && JOYERR_NOERROR==joyGetPosEx(JOYSTICKID2, &JoyStickInfo)) {
      JoyXpos=limit(JoyStickInfo.dwXpos-32768);
      JoyYpos=-limit((JoyStickInfo.dwYpos-32767));
      JoyZpos=-limit((JoyStickInfo.dwZpos-32767));
      JoyRpos=limit(JoyStickInfo.dwRpos-32768);
      JoyUpos=limit(JoyStickInfo.dwUpos-32768);
      JoyVpos=limit(JoyStickInfo.dwVpos-32768);
      JoyBut[0]=(JoyStickInfo.dwButtons & JOY_BUTTON1)?32767:0;
      JoyBut[1]=(JoyStickInfo.dwButtons & JOY_BUTTON2)?32767:0;
      JoyBut[2]=(JoyStickInfo.dwButtons & JOY_BUTTON3)?32767:0;
      JoyBut[3]=(JoyStickInfo.dwButtons & JOY_BUTTON4)?32767:0;
      Sleep(50);
    } else if (theJoystickMode==3 && external_getvalues && JOYERR_NOERROR==external_getvalues(&JoyStickInfo)) {
      JoyXpos=limit(JoyStickInfo.dwXpos-32768);
      JoyYpos=limit(JoyStickInfo.dwYpos-32768);
      JoyZpos=limit(JoyStickInfo.dwZpos-32768);
      JoyRpos=limit(JoyStickInfo.dwRpos-32768);
      JoyUpos=limit(JoyStickInfo.dwUpos-32768);
      JoyVpos=limit(JoyStickInfo.dwVpos-32768);
      JoyBut[0]=0;
      JoyBut[1]=0;
      JoyBut[2]=0;
      JoyBut[3]=0;
      Sleep(50);
    } else {
      JoyXpos=0;
      JoyYpos=0;
      JoyZpos=0;
      JoyRpos=0;
      JoyUpos=0;
      JoyVpos=0;
      JoyBut[0]=0;
      JoyBut[1]=0;
      JoyBut[2]=0;
      JoyBut[3]=0;
      Sleep(1000);
    }
  }
}

static bool openJoystick(void) {
  DWORD dwThrdParam = 1;

  if (NULL == externalDLL) {
    externalDLL=LoadLibrary("sf_external.dll");
    if (externalDLL) {
      external_getversion=(external_getversion_Func)GetProcAddress(externalDLL, "external_getversion");
      external_initdll=(external_initdll_Func)GetProcAddress(externalDLL, "external_initdll");
      external_deinitdll=(external_deinitdll_Func)GetProcAddress(externalDLL, "external_deinitdll");
      external_getvalues=(external_getvalues_Func)GetProcAddress(externalDLL, "external_getvalues");

      if (external_getversion) {
        logprintf("Loaded 'sf_external.dll'. DLL version %s.\\n", external_getversion());
      }
      if (external_initdll) {
        external_initdll(mainWindow, logprintf);
      }
    }
  }

  if (NULL == joystickThreadHandle) {
    joystickThreadHandle = CreateThread( 
      NULL,                        // no security attributes 
      0,                           // use default stack size  
      (LPTHREAD_START_ROUTINE)joystickThread, // thread function 
      &dwThrdParam,                // argument to thread function 
      CREATE_SUSPENDED,            // use default creation flags 
      &joystickThreadID);          // returns the thread identifier 
	  SetThreadPriority(joystickThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
  }

  if (NULL != joystickThreadHandle) {
    ResumeThread(joystickThreadHandle);
  }

  return true;
}

static bool closeJoystick(void) {
  if (joystickThreadHandle != NULL) {
    SuspendThread(joystickThreadHandle);
  }
  return true;
}
EOF

cc('mainInit', 'openJoystick();');
cci('mainTerm', 'closeJoystick();');
cc('stfSave', 'storeStfBegin(loadInfo, "theJoystickMode"); storeStfInteger(loadInfo, theJoystickMode); storeStfEnd(loadInfo);');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "theJoystickMode")==0) { int m; readStfInteger(loadInfo, &m); setTheJoystickMode(m); }');

