##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# HTML viewer
#
##########################################################################

ccModule('HTML viewer');

rc(<<EOF);
#define FONT_SIZE_SMALL      0x00
#define FONT_SIZE_NORMAL     0x08
#define FONT_SIZE_BIG        0x10
#define FONT_SIZE_HUGE       0x18
#define FONT_FIXEDPITCH      0x20

#define FONTMASK_UNDERLINE   0x01
#define FONTMASK_BOLD        0x02
#define FONTMASK_ITALIC      0x04
#define FONTMASK_SIZE        0x18
#define FONTMASK_FIXEDPITCH  0x20
const int FontSizes[4]={12,14,18,28};


static HFONT Fonts[64];


//
//	Render a html encoded page to the screen
//	inputs
//		aContext - Current runtime context
//		destRect - Region which must be used to render HTML page
//		ypos - Current scroll pos (negative to scrollup)
//		page - HTML page to render
//	outputs
//		ypos - maximum Ypos used to render HTML
//
static void renderHTMLPage(ContextPtr aContext, GuiRect *destRect, int *ypos, const char *page) {
//  char textBuffer[TEXTBUFFERSIZE];
	bool forceonespace=false; // If hit a cr/lf pair in none TT mode insert space instead.
	bool PREflag=false;
	bool tableMode=false;
	int fontmask=FONT_SIZE_NORMAL;
	int curX=destRect->left;
	int maxY=0;
	int nrchars;

	//
	// Restrict painting in provided space by 'destRect'
	//
//  SaveDC(aContext->hdc);
//  HRGN clipRgn=CreateRectRgnIndirect((RECT *)destRect);
//  SelectObject(aContext->hdc, clipRgn);
//  DeleteObject(clipRgn);

	//
	// Set correct painting modes
	//
	guiDrawTransparent(aContext);
	guiSetTextAlignment(aContext, alignTopLeft);
	(*ypos)+=destRect->top;

	guiSelectPen1Color(aContext, 0x000000);

	if (page) while (*page) {
		SIZE tSize;

		SelectObject(aContext->hdc, Fonts[fontmask]);
		nrchars=0;

		while (page[nrchars] && ((unsigned char)page[nrchars])>31 && page[nrchars]!='<' && page[nrchars]!='&') {
			nrchars++;
		}

		if (forceonespace) {
			if (curX>12) {
				GetTextExtentPoint32(aContext->hdc, " ", 1, &tSize);
				if (tSize.cx+curX > destRect->right) {
					(*ypos)+=maxY;
					maxY=0;
					curX=destRect->left;
				} else {
					guiDrawText(aContext, curX, (*ypos), " ", 1);
				}
				curX+=tSize.cx;
				maxY=max(maxY, tSize.cy);
			}
			forceonespace=false;
		}

		// Word wrap
		if (nrchars>0) {
			for(;;) {
				GetTextExtentPoint32(aContext->hdc, page, nrchars, &tSize);
				if (tSize.cx+curX >= destRect->right) {
					int backup=nrchars;
					nrchars--;
					while(nrchars>1 && page[nrchars-1]!=' ') {
						nrchars--;
					}
					if (nrchars<=1) {
						if (curX>0) {
							// Force newline
							(*ypos)+=maxY;
							maxY=0;
							curX=destRect->left;
						}
						nrchars=backup;
						guiDrawText(aContext, curX, (*ypos), page, nrchars);
						break;
					}
				} else {
					guiDrawText(aContext, curX, (*ypos), page, nrchars);
					break;
				}
			}

			curX+=tSize.cx;
			maxY=max(maxY, tSize.cy);
			page+=nrchars;
		}

		if (*page=='<') {
			char htmltag[32];
			int htmlcnt=0;

			page++;
			while (*page && *page!='>' && htmlcnt<31) {
				htmltag[htmlcnt++]=*page;
				page++;
			}
			htmltag[htmlcnt]='\\0';
				if (stricmp(htmltag, "FONT SIZE=-1")==0) {
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_SMALL;
				}
				if (stricmp(htmltag, "FONT SIZE=+1")==0) {
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_BIG;
				}
				if (stricmp(htmltag, "FONT SIZE=+2")==0) {
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_HUGE;
				}
				if (stricmp(htmltag, "/FONT")==0) {
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_NORMAL;
				}
				if (stricmp(htmltag, "H1")==0) {
					if (curX != destRect->left) {
						(*ypos)+=maxY+16;
						maxY=0;
						curX=destRect->left;
					}
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_HUGE | FONTMASK_BOLD | FONTMASK_UNDERLINE;
				}
				if (stricmp(htmltag, "H2")==0) {
					if (curX != destRect->left) {
						(*ypos)+=maxY+16;
						maxY=0;
						curX=destRect->left;
					}
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_BIG /*| FONTMASK_BOLD*/ | FONTMASK_UNDERLINE;
				}
				if (stricmp(htmltag, "H3")==0) {
					if (curX != destRect->left) {
						(*ypos)+=maxY+16;
						maxY=0;
						curX=destRect->left;
					}
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_NORMAL /*| FONTMASK_BOLD*/ | FONTMASK_UNDERLINE;
				}
				if ((stricmp(htmltag, "/H1")==0) || (stricmp(htmltag, "/H2")==0) || (stricmp(htmltag, "/H3")==0)) {
					fontmask &= ~FONTMASK_UNDERLINE;
					fontmask &= ~FONTMASK_BOLD;
					fontmask &= ~FONTMASK_SIZE;
					fontmask |= FONT_SIZE_NORMAL;
				}
				if (stricmp(htmltag, "TT")==0) {
					fontmask |= FONT_FIXEDPITCH;
				}
				if (stricmp(htmltag, "/TT")==0) {
					fontmask &= ~FONT_FIXEDPITCH;
				}
				if (stricmp(htmltag, "PRE")==0) {
					PREflag=true;
				}
				if (stricmp(htmltag, "/PRE")==0) {
					PREflag=false;
				}

				if (stricmp(htmltag, "BLUE")==0) {
					guiSelectPen1Color(aContext, 0x0000FF);
				}
				if (stricmp(htmltag, "RED")==0) {
					guiSelectPen1Color(aContext, 0xFF0000);
				}
				if (stricmp(htmltag, "BLACK")==0) {
					guiSelectPen1Color(aContext, 0x000000);
				}


				if (stricmp(htmltag, "BR")==0) {
					(*ypos)+=maxY;
					maxY=0;
					curX=destRect->left;
				}
/*        if (stricmp(htmltag, "P")==0) {
					if (curX==destRect->left) {
						curX+=12;
					}
				}*/
				if (stricmp(htmltag, "/P")==0 && tableMode==false) {
					(*ypos)+=maxY+16;
					maxY=0;
					curX=destRect->left;
				}
				if (stricmp(htmltag, "/UL")==0) {
					(*ypos)+=maxY+16;
					maxY=0;
					curX=destRect->left;
				}
				if (stricmp(htmltag, "HR")==0) {
					if (curX>4) {
						(*ypos)+=maxY;
						maxY=0;
						curX=destRect->left;
					}
					guiDrawLine(aContext, destRect->left+4, (*ypos), destRect->right-4, (*ypos));
					(*ypos)+=4; 
				}
				if (stricmp(htmltag, "LI")==0) {
					if (curX>0) {
						(*ypos)+=maxY+16;
						maxY=0;
						curX=destRect->left;
					}
					GetTextExtentPoint32(aContext->hdc, "* ", 2, &tSize);
					guiDrawText(aContext, curX, (*ypos), "* ", 2);
					curX+=tSize.cx;
					maxY=max(maxY, tSize.cy);
				}
				//
				// Tables
				if (stricmp(htmltag, "/TR")==0) {
					(*ypos)+=maxY;
					maxY=0;
					curX=destRect->left;
				}
				if (stricmp(htmltag, "TH")==0) {
					tableMode=true;
					fontmask ^= FONTMASK_BOLD;
				}
				if (stricmp(htmltag, "/TH")==0) {
					tableMode=false;
					fontmask ^= FONTMASK_BOLD;
					curX = ((curX+47)/48)*48;
				}
				if (stricmp(htmltag, "TD")==0) {
					tableMode=true;
				}
				if (stricmp(htmltag, "/TD")==0) {
					tableMode=false;
					curX = ((curX+47)/48)*48;
				}
				//
				// Font types
				if (stricmp(htmltag, "B")==0) {
					fontmask |= FONTMASK_BOLD;
				}
				if (stricmp(htmltag, "/B")==0) {
					fontmask &= ~FONTMASK_BOLD;
				}
				if (stricmp(htmltag, "U")==0) {
					fontmask |= FONTMASK_UNDERLINE;
				}
				if (stricmp(htmltag, "/U")==0) {
					fontmask &= ~FONTMASK_UNDERLINE;
				}
				if (stricmp(htmltag, "I")==0) {
					fontmask |= FONTMASK_ITALIC;
				}
				if (stricmp(htmltag, "/I")==0) {
					fontmask &= ~FONTMASK_ITALIC;
				}
			if (*page=='>') {
				page++;
			}
		} else {
			if (*page=='&') {
				char htmltag[32];
				int htmlcnt=0;

				page++;
				while (*page && *page!=';' && htmlcnt<31) {
					htmltag[htmlcnt++]=*page;
					page++;
				}
				htmltag[htmlcnt]='\\0';

					if (stricmp(htmltag, "amp")==0) {
						GetTextExtentPoint32(aContext->hdc, "&", 1, &tSize);
						if (tSize.cx+curX > destRect->right) {
							(*ypos)+=maxY;
							maxY=0;
							curX=destRect->left;
						}
						guiDrawText(aContext, curX, (*ypos), "&", 1);
						curX+=tSize.cx;
						maxY=max(maxY, tSize.cy);
					}

					if (stricmp(htmltag, "lt")==0) {
						GetTextExtentPoint32(aContext->hdc, "<", 1, &tSize);
						if (tSize.cx+curX > destRect->right) {
							(*ypos)+=maxY;
							maxY=0;
							curX=destRect->left;
						}
						guiDrawText(aContext, curX, (*ypos), "<", 1);
						curX+=tSize.cx;
						maxY=max(maxY, tSize.cy);
					}

					if (stricmp(htmltag, "gt")==0) {
						GetTextExtentPoint32(aContext->hdc, ">", 1, &tSize);
						if (tSize.cx+curX > destRect->right) {
							(*ypos)+=maxY;
							maxY=0;
							curX=destRect->left;
						}
						guiDrawText(aContext, curX, (*ypos), ">", 1);
						curX+=tSize.cx;
						maxY=max(maxY, tSize.cy);
					}

					if (stricmp(htmltag, "nbsp")==0) {
						GetTextExtentPoint32(aContext->hdc, " ", 1, &tSize);
						if (tSize.cx+curX > destRect->right) {
							(*ypos)+=maxY;
							maxY=0;
							curX=destRect->left;
						}
						guiDrawText(aContext, curX, (*ypos), " ", 1);
						curX+=tSize.cx;
						maxY=max(maxY, tSize.cy);
					}

				if (*page==';') {
					page++;
				}
			}
			if ((*page==10) || (*page==13)) {
				if (PREflag) {
					(*ypos)+=maxY;
					maxY=0;
					curX=destRect->left;
					page++;
				} else {
					forceonespace=true;
				}
			}
			while (((unsigned char)*page)<32 && ((unsigned char)*page)>0) {
				page++;
			}
		}
	}

	(*ypos)+=maxY;
	(*ypos)-=destRect->top;
//  RestoreDC(aContext->hdc, -1);
}

static void initHTMLEngine(void) {
	int fontcnt;
	for(fontcnt=0; fontcnt<64; fontcnt++) {
		Fonts[fontcnt] = CreateFont(
			FontSizes[(fontcnt&FONTMASK_SIZE)>>3], 0, 0, 0, (fontcnt&FONTMASK_BOLD)?FW_BOLD:FW_THIN,
			(fontcnt&FONTMASK_ITALIC)?TRUE:FALSE, (fontcnt&FONTMASK_UNDERLINE)?TRUE:FALSE, FALSE,
			DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
			PROOF_QUALITY, ((fontcnt&FONTMASK_FIXEDPITCH)?FIXED_PITCH:VARIABLE_PITCH) | FF_DONTCARE, (fontcnt&FONTMASK_FIXEDPITCH)?"Courier New":"Arial");
	}
}

static void termHTMLEngine(void) {
	int fontcnt;
	for(fontcnt=0; fontcnt<64; fontcnt++) {
		DeleteObject(Fonts[fontcnt]);
	}
}
EOF

	cc('mainInit', "initHTMLEngine();");
	cci('mainTerm', "termHTMLEngine();");
