##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# GUI for Qt
#
##########################################################################

ccModule('Lowlevel GUI driver for Qt');

cc('ContextStruct', 'QWidget *currentWindow;');
cc('ContextStruct', 'QPainter *currentPainter;');
cc('ContextStruct', 'GuiWindowInfoPtr currentWindowInfo;');
cc('mainLoop', 'logprintf("in mainloop\n");');
cc('mainLoop', 'theApplication->exec();');

include('<qapplication.h>');
include('<qwidget.h>');
include('<qpainter.h>');
include('<qmainwindow.h>');

gStruct('GuiRect');
cc('GuiRectStruct', 'int left;');
cc('GuiRectStruct', 'int top;');
cc('GuiRectStruct', 'int right;');
cc('GuiRectStruct', 'int bottom;');

gStruct('GuiPoint');
cc('GuiPointStruct', 'int x;');
cc('GuiPointStruct', 'int y;');

rd('typedef QWidget *GuiWindowPtr;');
# rd('typedef QMainWindow *GuiMainWindow;');
rd('typedef QFont GuiFont;');
rd('typedef QMenuData *GuiMenu;');

rd('#define VK_RETURN (Qt::Key_Return)');
rd('#define VK_DELETE (Qt::Key_Delete)');
rd('#define VK_ESCAPE (Qt::Key_Escape)');
rd('#define VK_SPACE (Qt::Key_Space)');
rd('#define VK_F1 (Qt::Key_F1)');
rd('#define VK_F2 (Qt::Key_F2)');
rd('#define VK_UP (Qt::Key_Up)');
rd('#define VK_DOWN (Qt::Key_Down)');

rd('#define GUI_COPY_ROP (Qt::CopyRop)');
rd('#define GUI_XOR_ROP (Qt::XorRop)');

# Temp fixes to make it compile
rd('typedef void *HANDLE;');

rv('QPen *currentPen=NULL;');


rs(<<EOF);
static const int alignTopLeft=Qt::AlignTop | Qt::AlignLeft;
static const int alignTopCenter=Qt::AlignTop | Qt::AlignHCenter;
static const int alignTopRight=Qt::AlignTop | Qt::AlignRight;
static const int alignLineLeft=Qt::AlignVCenter | Qt::AlignLeft;
static const int alignLineCenter=Qt::AlignVCenter | Qt::AlignHCenter;
static const int alignLineRight=Qt::AlignVCenter | Qt::AlignRight;
static const int alignBottomLeft=Qt::AlignBottom | Qt::AlignLeft;
static const int alignBottomCenter=Qt::AlignBottom | Qt::AlignHCenter;
static const int alignBottomRight=Qt::AlignBottom | Qt::AlignRight;
static int currentTextAlignment = alignTopLeft;

static void guiSetTextAlignment(ContextPtr aContext, int aAlignment) {
	currentTextAlignment = aAlignment;
}

static void guiSelectPen1Color(ContextPtr aContext, int color) {
	QPen *newPen = NULL;
	if (color>=0 && color<0x1000000) {
		newPen = new QPen(QColor(color&255, (color>>8)&255, (color>>16)&255), 1);
		aContext -> currentPainter -> setPen(*newPen);
	} else {
		aContext -> currentPainter -> setPen(Qt::NoPen);
	}
	if (currentPen) delete currentPen;
	currentPen = newPen;
}

static void guiSelectPen3Color(ContextPtr aContext, int color) {
	QPen *newPen = NULL;
	if (color>=0 && color<0x1000000) {
		newPen = new QPen(QColor(color&255, (color>>8)&255, (color>>16)&255), 3);
		aContext -> currentPainter -> setPen(*newPen);
	} else {
		aContext -> currentPainter -> setPen(Qt::NoPen);
	}
	if (currentPen) delete currentPen;
	currentPen = newPen;
}

static void guiSelectFillColor(ContextPtr aContext, int color) {
	if (color>=0 && color<0x1000000) {
		aContext -> currentPainter -> setBrush(QColor(color&255, (color>>8)&255, (color>>16)&255));
	} else {
		aContext -> currentPainter -> setBrush(Qt::NoBrush);
	}
}

static void guiDrawLine(ContextPtr aContext, int left, int top, int right, int bottom) {
	aContext -> currentPainter -> drawLine(left, top, right, bottom);
}

static void guiDrawLineFrom(ContextPtr aContext, int aX, int aY) {
	aContext -> currentPainter -> moveTo(aX, aY);
}

static void guiDrawLineTo(ContextPtr aContext, int aX, int aY) {
	aContext -> currentPainter -> lineTo(aX, aY);
}

static void guiDrawRect(ContextPtr aContext, int left, int top, int right, int bottom) {
	aContext -> currentPainter -> drawRect(left, top, right-left, bottom-top);
}

static void guiDrawRoundRect(ContextPtr aContext, int left, int top, int right, int bottom, int width, int height) {
	aContext -> currentPainter -> drawRoundRect(left, top, right-left, bottom-top, width, height);
}

static void guiDrawEllipse(ContextPtr aContext, int left, int top, int right, int bottom) {
	aContext -> currentPainter -> drawEllipse(left, top, right-left, bottom-top);
}

static void guiPolygon(ContextPtr aContext, GuiPointPtr aPointList, int aCount) {
	QPointArray myPointArray(aCount);
	int i;

	for(i=0;i<aCount;i++) {
		myPointArray.setPoint(i, aPointList[i].x, aPointList[i].y);
	}
	aContext -> currentPainter -> drawPolygon(myPointArray);
}

static void guiDrawOpaque(ContextPtr aContext) {
	aContext -> currentPainter -> setBackgroundMode(Qt::OpaqueMode);
}

static void guiDrawTransparent(ContextPtr aContext) {
	aContext -> currentPainter -> setBackgroundMode(Qt::TransparentMode);
}

static void guiDrawText(ContextPtr aContext, int left, int top, int right, int bottom, const char *text, int count=-1) {
	logprintf("guiDrawText ltrb %s\\n", text);
	aContext->currentPainter->drawText(left, top, right-left, bottom-top, currentTextAlignment, QString(text), count);
}

static void guiDrawText(ContextPtr aContext, int left, int top, const char *text, int count=-1) {
	logprintf("guiDrawText lt %s\\n", text);
	aContext->currentPainter->drawText(left, top, QString(text), count);
//	aContext->currentPainter->drawText(left, top, aContext->guiClientRect.right-left, aContext->guiClientRect.bottom-top, currentTextAlignment, QString(text), count);
}

static void guiDraw3dFill(ContextPtr aContext, int left, int top, int right, int bottom) {
	QPen myPen = aContext -> currentPainter -> pen();
	QBrush myBrush = aContext -> currentPainter -> brush();
	aContext -> currentPainter -> setBrush(Qt::lightGray);
	aContext -> currentPainter -> setPen(Qt::NoPen);
	aContext -> currentPainter -> drawRect(left, top, right-left, bottom-top);
	aContext -> currentPainter -> setBrush(myBrush);
	aContext -> currentPainter -> setPen(myPen);
}

static void guiDraw3dRect(ContextPtr aContext, int left, int top, int right, int bottom, bool pressed) {
	QPen myPen = aContext -> currentPainter -> pen();
	QBrush myBrush = aContext -> currentPainter -> brush();
	aContext -> currentPainter -> setBrush(Qt::lightGray);
	if (pressed) {
		aContext -> currentPainter -> setPen(Qt::NoPen);
		aContext -> currentPainter -> drawRect(left, top, right-left, bottom-top);
		aContext -> currentPainter -> setPen(Qt::black);
		aContext -> currentPainter -> drawLine(left, top, right-1, top);
		aContext -> currentPainter -> drawLine(left, top, left, bottom-1);
		aContext -> currentPainter -> setPen(Qt::white);
		aContext -> currentPainter -> drawLine(left, bottom-1, right-1, bottom-1);
		aContext -> currentPainter -> drawLine(right-1, top, right-1, bottom-1);
	} else {
		aContext -> currentPainter -> setPen(Qt::NoPen);
		aContext -> currentPainter -> drawRect(left, top, right-left, bottom-top);
		aContext -> currentPainter -> setPen(Qt::white);
		aContext -> currentPainter -> drawLine(left, top, right-1, top);
		aContext -> currentPainter -> drawLine(left, top, left, bottom-1);
		aContext -> currentPainter -> setPen(Qt::black);
		aContext -> currentPainter -> drawLine(left, bottom-1, right-1, bottom-1);
		aContext -> currentPainter -> drawLine(right-1, top, right-1, bottom-1);
	}
	aContext -> currentPainter -> setBrush(myBrush);
	aContext -> currentPainter -> setPen(myPen);
}

// !!!TODO: remove this function after changing references to this one
static void guiDraw3dRect(ContextPtr aContext, GuiRect *rect, bool pressed) {
	guiDraw3dRect(aContext, rect->left, rect->top, rect->right, rect->bottom, pressed);
}

static Qt::RasterOp guiGetRasterOp(ContextPtr aContext) {
	return aContext->currentPainter->rasterOp();
}

static void guiSetRasterOp(ContextPtr aContext, Qt::RasterOp aRasterOp) {
	aContext->currentPainter->setRasterOp(aRasterOp);
}

static void guiRefreshWindow(GuiWindowPtr aWindow, int left, int top, int right, int bottom)  {
	aWindow->update(left, top, right, bottom);
}

static void guiRefreshWindow(GuiWindowPtr aWindow)  {
	aWindow->update();
}

static void guiSetFocus(GuiWindowPtr aWindow) {
	aWindow->setFocus();
}

static void guiHideWindow(GuiWindowPtr aWindow) {
	aWindow->hide();
	if (aWindow != mainWindow) {
		guiSetFocus(mainWindow);
	}
}

static void guiShowWindow(GuiWindowPtr aWindow) {
	aWindow->show();
}

static bool guiIsWindowVisible(GuiWindowPtr aWindow) {
	return (aWindow->isVisible());
}

static bool guiIsWindowMaximized(GuiWindowPtr aWindow) {
	return (aWindow->isMaximized());
}

static void guiDestroyWindow(GuiWindowPtr aWindow) {
	delete aWindow;
}

static void guiMaximizeWindow(GuiWindowPtr aWindow) {
	aWindow->showMaximized();
}

static inline void guiSetWindowTitle(GuiWindowPtr aWindow, const char *title) {
	aWindow->setCaption(title);
}

static void guiPositionWindow(GuiWindowPtr aWindow, int aXPosition, int aYPosition) {
	aWindow->move(aXPosition, aYPosition);
}

static void guiPositionSizeWindow(GuiWindowPtr aWindow, int aXPosition, int aYPosition, int aXSize, int aYSize) {
	aWindow->setGeometry(aXPosition, aYPosition, aXSize, aYSize);
}

static void guiGetWindowPosition(GuiWindowPtr aWindow, int *aXPositionPtr, int *aYPositionPtr, int *aXSizePtr, int *aYSizePtr) {
	*aXPositionPtr = aWindow->x();
	*aYPositionPtr = aWindow->y();
	*aXSizePtr = aWindow->width();
	*aYSizePtr = aWindow->height();
}

static void guiHScrollWindowTo(GuiWindowPtr aWindow, int pos) {
}

static void guiVScrollWindowTo(GuiWindowPtr window, int pos) {
}

static void guiHScrollRange(GuiWindowPtr aWindow, int aMininum, int aMaximum, int aPage) {
}

static void guiVScrollRange(GuiWindowPtr aWindow, int aMininum, int aMaximum, int aPage) {
}

static int guiGetHScrollPos(GuiWindowPtr aWindow) {
	return 0;
}

static int guiGetVScrollPos(GuiWindowPtr aWindow) {
	return 0;
}

static void guiSetHScrollPos(GuiWindowPtr aWindow, int pos) {
}

static void guiSetVScrollPos(GuiWindowPtr aWindow, int pos) {
}

static void guiRunTimer(GuiWindowPtr aWindow, int aTimeMs) {
	aWindow->startTimer(aTimeMs);
}

static void guiClearAreaList(ContextPtr aContext) {
	assert(aContext->currentWindowInfo);	
	aContext->currentWindowInfo->areaListCount = 0;
}

static void guiAddArea(ContextPtr aContext, int left, int top, int right, int bottom) {
	assert(aContext->currentWindowInfo);	
	if (aContext->currentWindowInfo->areaListCount == aContext->currentWindowInfo->areaListSize) {
		aContext->currentWindowInfo->areaListSize += 64;
		aContext->currentWindowInfo->areaList =
			(GuiRectPtr)realloc(aContext->currentWindowInfo->areaList, sizeof(GuiRect) * aContext->currentWindowInfo->areaListSize);		
	}
	aContext->currentWindowInfo->areaList[aContext->currentWindowInfo->areaListCount].left=left;
	aContext->currentWindowInfo->areaList[aContext->currentWindowInfo->areaListCount].top=top;
	aContext->currentWindowInfo->areaList[aContext->currentWindowInfo->areaListCount].right=right;
	aContext->currentWindowInfo->areaList[aContext->currentWindowInfo->areaListCount].bottom=bottom;
	aContext->currentWindowInfo->areaListCount++;
}

static int guiGetAreaListLen(ContextPtr aContext) {
	assert(aContext->currentWindowInfo);	
	return aContext->currentWindowInfo->areaListCount;
}

static void guiDoubleBuffer(GuiWindowPtr aWindow, bool aFlag) {
}

static bool ctrlPressed(void) {
	return false;
}

static void guiHideMouse(ContextPtr aContext) {
}

static void guiShowMouse(ContextPtr aContext) {
}

static void guiSetMenu(GuiWindowPtr aWindow, GuiMenu aMenu) {
}

static void guiFillContextDefaults(ContextPtr aContext, QWidget *aWindow) {
	aContext->currentWindow = aWindow;
	aContext->guiClientRect.left = 0;
	aContext->guiClientRect.right = aWindow->width();
	aContext->guiClientRect.top = 0;
	aContext->guiClientRect.bottom = aWindow->height();
}

static void guiFillIdFromAreaList(ContextPtr aContext, int x, int y) {
	assert(aContext->currentWindowInfo);	
	int len = aContext->currentWindowInfo->areaListCount;
	GuiRectPtr list = aContext->currentWindowInfo->areaList;

	if (NULL!=list) {
		int i;

		aContext->id=0;
		for(i=0;i<len;i++) {
			if (x>=list[i].left && x<=list[i].right
			&& y>=list[i].top && y<=list[i].bottom) {
				aContext->id=i+1;
			}
		}
	}
}

static void guiFillContextWithMouseData(ContextPtr aContext, QMouseEvent *aEvent) {
	aContext->mouseClientX=aEvent->x();
	aContext->mouseClientY=aEvent->y();
	aContext->mouseX=aEvent->pos().x();
	aContext->mouseY=aEvent->pos().y();
	guiFillIdFromAreaList(aContext, aEvent->x(), aEvent->y());
}
EOF

rc(<<EOF);
static void refreshWindows(void) {
	~cc~refreshFunctions~
}
EOF

gStruct('GuiWindowInfo');
cc('GuiWindowInfoStruct', 'int areaListCount;');
cc('GuiWindowInfoStruct', 'int areaListSize;');
cc('GuiWindowInfoStruct', 'GuiRectPtr areaList;');

rc(<<EOF);
class GuiToolWindow: public QWidget {
public:
	GuiToolWindow(QWidget *aParent=0, EventFunc aEventFunction=0, WFlags flags=0): QWidget(aParent, 0, flags) {
		logprintf("GuiToolWindow\\n");
		m_eventFunction = aEventFunction;
		memset(&m_guiWindowInfo, 0, sizeof(m_guiWindowInfo));
	}

	~GuiToolWindow() {
		if (m_guiWindowInfo.areaList) {
			free(m_guiWindowInfo.areaList);
		}
	}

protected:
	virtual void mouseDoubleClickEvent(QMouseEvent *aEvent) {
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			guiFillContextWithMouseData(&myContext, aEvent);
			switch(aEvent->button()) {
			case LeftButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1DCLK;
				break;
			case RightButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON2DCLK;
				break;
			default:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1DCLK;
				break;
			}
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	virtual void mousePressEvent(QMouseEvent *aEvent) {
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			guiFillContextWithMouseData(&myContext, aEvent);
			switch(aEvent->button()) {
			case LeftButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1DOWN;
				break;
			case RightButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON2DOWN;
				break;
			default:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1DOWN;
				break;
			}
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	virtual void mouseReleaseEvent(QMouseEvent *aEvent) {
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			guiFillContextWithMouseData(&myContext, aEvent);
			switch(aEvent->button()) {
			case LeftButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1UP;
				break;
			case RightButton:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON2UP;
				break;
			default:
				myContext.guiEvent = GUIEVENT_MOUSEBUTTON1UP;
				break;
			}
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	virtual void paintEvent(QPaintEvent *aEvent) {
		logprintf("painEvent\\n");
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			myContext.guiEvent = GUIEVENT_REFRESH;
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	virtual void timerEvent(QTimerEvent *aEvent) {
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			myContext.guiEvent = GUIEVENT_TIMERTICK;
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}


	virtual void closeEvent(QCloseEvent *aEvent) {
		logprintf("in closeEvent\\n");
		if (m_eventFunction) {
			aEvent->ignore();
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.guiEvent = GUIEVENT_CLOSE;
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	EventFunc m_eventFunction;
	GuiWindowInfo m_guiWindowInfo;
};
EOF

rd('class GuiMainWindow;');
# rd('typedef GuiMainWindow *GuiMainWindowPtr;');
rc(<<EOF);
class GuiMainWindow: public QMainWindow {
public:
	GuiMainWindow(QWidget *aParent=0, EventFunc aEventFunction=0, WFlags flags=WType_TopLevel): QMainWindow(0, 0, flags) {
		logprintf("GuiMainWindow\\n");
		m_eventFunction = aEventFunction;
		memset(&m_guiWindowInfo, 0, sizeof(m_guiWindowInfo));
	}

	~GuiMainWindow() {
		if (m_guiWindowInfo.areaList) {
			free(m_guiWindowInfo.areaList);
		}
	}

protected:
	virtual void paintEvent(QPaintEvent *aEvent) {
		if (m_eventFunction) {
			QPainter myPainter(this);
			Context myContext;

			guiFillContextDefaults(&myContext, this);
			myContext.currentWindowInfo = &m_guiWindowInfo;
			myContext.currentPainter = &myPainter;
			myContext.guiEvent = GUIEVENT_REFRESH;
			m_eventFunction(&myContext);
			refreshWindows();
		}
	}

	EventFunc m_eventFunction;
	GuiWindowInfo m_guiWindowInfo;
};
EOF
rc('typedef GuiMainWindow *GuiMainWindowPtr;');

rv('QApplication *theApplication;');
cc('mainInit', 'theApplication=new QApplication(argc, argv, true);');
cci('mainTerm', 'delete theApplication;');

