##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2007  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# GUI for Microsoft Windows GDI API
#
##########################################################################

ccModule('Lowlevel GUI driver for GDI');

# dependencies
cc('ContextStruct', 'HWND currentWindow;');
cc('ContextStruct', 'HDC hdc;');
cc('mainLoop', 'mainLoop();');

# data structures


userInclude('resource.h');

rd('typedef RECT GuiRect;');
rd('typedef POINT GuiPoint;');
rd('typedef POINT *GuiPointPtr;');
rd('typedef HWND GuiWindow;');
rd('typedef HWND GuiMainWindow;');
rd('typedef HWND GuiWindowPtr;');
rd('typedef HFONT GuiFont;');
rd('typedef HMENU GuiMenu;');

rd('#define GUI_COPY_ROP (R2_COPYPEN)');
rd('#define GUI_XOR_ROP (R2_XORPEN)');


rv("const char * const mainWindowClass=\"StudioFactoryMainClass\";");
rv('ATOM mainClassAtom;');


rv('HPEN currentPen=NULL;');
rv('HBRUSH currentBrush=NULL;');
rv('int currentAlignment = DT_TOP | DT_LEFT;');


rs(<<EOF);
static const int alignTopLeft=(DT_TOP | DT_LEFT);
static const int alignTopCenter=(DT_TOP | DT_CENTER);
static const int alignTopRight=(DT_TOP | DT_RIGHT);
static const int alignLineLeft=(DT_VCENTER | DT_LEFT);
static const int alignLineCenter=(DT_VCENTER | DT_CENTER);
static const int alignLineRight=(DT_VCENTER | DT_RIGHT);
static const int alignBottomLeft=(DT_BOTTOM | DT_LEFT);
static const int alignBottomCenter=(DT_BOTTOM | DT_CENTER);
static const int alignBottomRight=(DT_BOTTOM | DT_RIGHT);


static inline void guiSetTextAlignment(ContextPtr aContext, int aAlignment) {
	currentAlignment = aAlignment;
}

static void guiSelectPen1Color(ContextPtr aContext, int color) {
	HPEN newPen=NULL;
	if (color>=0 && color<0x1000000) {
		newPen=CreatePen(PS_SOLID, 1, 0x02000000 | color);
		SelectObject(aContext->hdc, newPen);
		SetTextColor(aContext->hdc, 0x02000000 | color);
	} else {
		SelectObject(aContext->hdc, GetStockObject(NULL_PEN));
	}
	if (currentPen) DeleteObject(currentPen);
	currentPen=newPen;
}

static void guiSelectPen3Color(ContextPtr aContext, int color) {
	HPEN newPen=NULL;
	if (color>=0 && color<0x1000000) {
		newPen=CreatePen(PS_SOLID, 3, 0x02000000 | color);
		SelectObject(aContext->hdc, newPen);
		SetTextColor(aContext->hdc, 0x02000000 | color);
	} else {
		SelectObject(aContext->hdc, GetStockObject(NULL_PEN));
	}
	if (currentPen) DeleteObject(currentPen);
	currentPen=newPen;
}

static void guiSelectFillColor(ContextPtr aContext, int color) {
	HBRUSH newBrush=NULL;
	if (color>=0 && color<0x1000000) {
		newBrush=CreateSolidBrush(0x02000000 | color);
		SelectObject(aContext->hdc, newBrush);
		SetBkColor(aContext->hdc, 0x02000000 | color);
	} else {
		SelectObject(aContext->hdc, GetStockObject(NULL_BRUSH));
	}
	if (currentBrush) DeleteObject(currentBrush);
	currentBrush=newBrush;
}

static void guiDrawLine(ContextPtr aContext, int aStartX, int aStartY, int aEndX, int aEndY) {
	(void)MoveToEx(aContext->hdc, aStartX, aStartY, NULL);
	(void)LineTo(aContext->hdc, aEndX, aEndY);
}

static void guiDrawLineFrom(ContextPtr aContext, int aX, int aY) {
	(void)MoveToEx(aContext->hdc, aX, aY, NULL);
}

static void guiDrawLineTo(ContextPtr aContext, int aX, int aY) {
	(void)LineTo(aContext->hdc, aX, aY);
}

static void guiDrawRect(ContextPtr aContext, int left, int top, int right, int bottom) {
	(void)Rectangle(aContext->hdc, left, top, right+((currentPen)?0:1), bottom+((currentPen)?0:1));
}

static void guiDrawRoundRect(ContextPtr aContext, int left, int top, int right, int bottom, int width, int height) {
	(void)RoundRect(aContext->hdc, left, top, right, bottom, width, height);
}

static void guiDrawEllipse(ContextPtr aContext, int left, int top, int right, int bottom) {
	(void)Ellipse(aContext->hdc, left, top, right+((currentPen)?0:1), bottom+((currentPen)?0:1));
}

static void guiPolygon(ContextPtr aContext, GuiPointPtr aPointList, int aCount) {
	(void)Polygon(aContext->hdc, aPointList, aCount);
}

static void guiDrawOpaque(ContextPtr aContext) {
	SetBkMode(aContext->hdc, OPAQUE);
}

static void guiDrawTransparent(ContextPtr aContext) {
	SetBkMode(aContext->hdc, TRANSPARENT);
}

static void guiDrawText(ContextPtr aContext, int left, int top, int right, int bottom, const char *text, size_t count=-1) {
	RECT myRect={left, top, right, bottom};
	DrawText(aContext->hdc, text, (int)count, &myRect, currentAlignment | DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP);
}

static void guiDrawText(ContextPtr aContext, int left, int top, const char *text, size_t count=-1) {
	RECT myRect={left, top, left, top};
	DrawText(aContext->hdc, text, (int)count, &myRect, DT_SINGLELINE | DT_NOPREFIX | DT_NOCLIP);
}

static void guiCalcTextSize(ContextPtr aContext, int *xSize, int *ySize, const char *text, int count) {
	SIZE mySize;
	GetTextExtentPoint32(aContext->hdc, text, count, &mySize);
	if (xSize) *xSize = mySize.cx;
	if (ySize) *ySize = mySize.cy;
}

static void guiDraw3dFill(ContextPtr aContext, int left, int top, int right, int bottom) {
	RECT myRect={left, top, right, bottom};
	DrawEdge(aContext->hdc, &myRect, EDGE_SUNKEN, BF_MIDDLE);
}

void guiDraw3dRect(ContextPtr aContext, int left, int top, int right, int bottom, bool pressed) {
	RECT myRect={left, top, right, bottom};
	if (currentBrush) {
		(void)FillRect(aContext->hdc, &myRect, currentBrush);
		DrawEdge(aContext->hdc, &myRect, (pressed)?EDGE_SUNKEN:EDGE_RAISED, BF_RECT);
	} else {
		DrawEdge(aContext->hdc, &myRect, (pressed)?EDGE_SUNKEN:EDGE_RAISED, BF_RECT | BF_MIDDLE);
	}
}

static void guiRefreshWindow(GuiWindowPtr window, int left, int top, int right, int bottom)  {
	RECT myRect={left, top, right, bottom};
	(void)InvalidateRect(window, &myRect, FALSE);
}

static void guiRefreshWindow(GuiWindowPtr window) {
	(void)InvalidateRect(window, (RECT *)NULL, FALSE);
}

static void guiSetFocus(GuiWindowPtr window) {
	(void)SetFocus(window);
}

static void guiHideWindow(GuiWindowPtr aWindow) {
	(void)ShowWindow(aWindow, SW_HIDE);
	if (aWindow!=mainWindow) {
		guiSetFocus(mainWindow);
	}
}

static void guiShowWindow(GuiWindowPtr aWindow) {
	(void)ShowWindow(aWindow, SW_SHOW);
	(void)SetFocus(aWindow);
}

static bool guiIsWindowVisible(GuiWindowPtr aWindow) {
	return (IsWindowVisible(aWindow)==TRUE);
}

static bool guiIsWindowMaximized(GuiWindowPtr aWindow) {
	WINDOWPLACEMENT winpos;
	winpos.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(aWindow, &winpos);
	return (SW_SHOWMAXIMIZED==winpos.showCmd);
}

static void guiDestroyWindow(GuiWindowPtr window) {
	DestroyWindow(window);
}

static void guiMaximizeWindow(GuiWindowPtr aWindow) {
	ShowWindow(aWindow, SW_MAXIMIZE);
}

static void guiSetWindowTitle(GuiWindowPtr window, const char *title) {
	SetWindowText(window, title);
}

static void guiPositionWindow(GuiWindowPtr window, int aXPosition, int aYPosition) {
	SetWindowPos(window, NULL, aXPosition, aYPosition, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
}

static void guiPositionSizeWindow(GuiWindowPtr window, int aXPosition, int aYPosition, int aXSize, int aYSize) {
	SetWindowPos(window, NULL, aXPosition, aYPosition, aXSize, aYSize, SWP_NOZORDER);
}

static void guiGetWindowPosition(GuiWindowPtr aWindow, int *aXPositionPtr, int *aYPositionPtr, int *aXSizePtr, int *aYSizePtr) {
	WINDOWPLACEMENT winpos;
	winpos.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(aWindow, &winpos);
	*aXPositionPtr = winpos.rcNormalPosition.left;
	*aYPositionPtr = winpos.rcNormalPosition.top;
	*aXSizePtr = winpos.rcNormalPosition.right-winpos.rcNormalPosition.left;
	*aYSizePtr = winpos.rcNormalPosition.bottom-winpos.rcNormalPosition.top;
}

static void guiHScrollWindowTo(GuiWindowPtr window, int pos) {
	SCROLLINFO myScrollInfo;
	int oldPos;
	int page;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_TRACKPOS | SIF_PAGE | SIF_RANGE;
	GetScrollInfo(window, SB_HORZ, &myScrollInfo);

	oldPos = myScrollInfo.nPos;
	myScrollInfo.nPos=pos;
	page=(int)myScrollInfo.nPage;

	if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
	if (myScrollInfo.nPos>myScrollInfo.nMax-page) myScrollInfo.nPos=max(myScrollInfo.nMin, myScrollInfo.nMax-page);
	if (oldPos != myScrollInfo.nPos) {
		myScrollInfo.cbSize=sizeof(myScrollInfo);
		myScrollInfo.fMask=SIF_POS;
		SetScrollInfo(window, SB_HORZ, &myScrollInfo, TRUE);
		guiRefreshWindow(window);
	}
}

static void guiVScrollWindowTo(GuiWindowPtr window, int pos) {
	SCROLLINFO myScrollInfo;
	int oldPos;
	int page;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_TRACKPOS | SIF_PAGE | SIF_RANGE;
	GetScrollInfo(window, SB_VERT, &myScrollInfo);

	oldPos = myScrollInfo.nPos;
	myScrollInfo.nPos = pos;
	page=(int)myScrollInfo.nPage;

	if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
	if (myScrollInfo.nPos>myScrollInfo.nMax-page) myScrollInfo.nPos=max(myScrollInfo.nMin, myScrollInfo.nMax-page);
	if (oldPos != myScrollInfo.nPos) {
		myScrollInfo.cbSize=sizeof(myScrollInfo);
		myScrollInfo.fMask=SIF_POS;
		SetScrollInfo(window, SB_VERT, &myScrollInfo, TRUE);
		guiRefreshWindow(window);
	}
}

static void guiHScrollRange(GuiWindowPtr window, int aMininum, int aMaximum, int aPage) {
	SCROLLINFO myScrollInfo;
	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_PAGE | SIF_RANGE;
	GetScrollInfo(window, SB_HORZ, &myScrollInfo);
	myScrollInfo.nMin=aMininum;
	myScrollInfo.nMax=aMaximum;
	myScrollInfo.nPage=aPage;

	if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
	if (myScrollInfo.nPos>myScrollInfo.nMax-aPage) myScrollInfo.nPos=max(myScrollInfo.nMin, myScrollInfo.nMax-aPage);
	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_PAGE | SIF_RANGE | SIF_DISABLENOSCROLL;
	SetScrollInfo(window, SB_HORZ, &myScrollInfo, TRUE);
}

static void guiVScrollRange(GuiWindowPtr window, int aMininum, int aMaximum, int aPage) {
	SCROLLINFO myScrollInfo;
	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_PAGE | SIF_RANGE;
	GetScrollInfo(window, SB_VERT, &myScrollInfo);
	myScrollInfo.nMin=aMininum;
	myScrollInfo.nMax=aMaximum;
	myScrollInfo.nPage=aPage;

	if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
	if (myScrollInfo.nPos>myScrollInfo.nMax-aPage) myScrollInfo.nPos=max(myScrollInfo.nMin, myScrollInfo.nMax-aPage);
	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS | SIF_PAGE | SIF_RANGE | SIF_DISABLENOSCROLL;
	SetScrollInfo(window, SB_VERT, &myScrollInfo, TRUE);
}

static int guiGetHScrollPos(GuiWindowPtr window) {
	SCROLLINFO myScrollInfo;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS;
	GetScrollInfo(window, SB_HORZ, &myScrollInfo);
	return myScrollInfo.nPos;
}

static int guiGetVScrollPos(GuiWindowPtr window) {
	SCROLLINFO myScrollInfo;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS;
	GetScrollInfo(window, SB_VERT, &myScrollInfo);
	return myScrollInfo.nPos;
}

static void guiSetHScrollPos(GuiWindowPtr window, int pos) {
	SCROLLINFO myScrollInfo;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS;
	myScrollInfo.nPos=pos;
	SetScrollInfo(window, SB_HORZ, &myScrollInfo, TRUE);
	guiRefreshWindow(window);
}

static void guiSetVScrollPos(GuiWindowPtr window, int pos) {
	SCROLLINFO myScrollInfo;

	myScrollInfo.cbSize=sizeof(myScrollInfo);
	myScrollInfo.fMask=SIF_POS;
	myScrollInfo.nPos=pos;
	SetScrollInfo(window, SB_VERT, &myScrollInfo, TRUE);
	guiRefreshWindow(window);
}

static void guiRunTimer(GuiWindowPtr window, int aTimeMs) {
	SetTimer(window, 0, aTimeMs, NULL);
}

static void guiClearAreaList(ContextPtr aContext) {
	if (GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST)) {
		free((void*)GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST));
		SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST, 0);
		SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTUSEDLEN, 0);
		SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTMAXLEN, 0);
	}
}

static void guiAddArea(ContextPtr aContext, int left, int top, int right, int bottom) {
	GuiRect *ptr=(GuiRect *)GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST);
	int usedLen=GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTUSEDLEN);
	int maxLen=GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTMAXLEN);

	if (usedLen==maxLen) {
		maxLen+=64; // equals 1 kbyte
		ptr=(GuiRect *)realloc(ptr, sizeof(GuiRect)*maxLen);
		SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST, (LONG)(void*)ptr);
		SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTMAXLEN, maxLen);
	}
	ptr[usedLen].left=left;
	ptr[usedLen].top=top;
	ptr[usedLen].right=right;
	ptr[usedLen].bottom=bottom;
	SetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTUSEDLEN, usedLen+1);
}

static int guiGetAreaListLen(ContextPtr aContext) {
	return GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTUSEDLEN);
}

static void guiDoubleBuffer(GuiWindowPtr aWindow, bool aFlag) {
	SetWindowLong(aWindow, WNDEXTRA_DOUBLEBUFFERFLAG, (aFlag)?-1L:0L);
}

static bool ctrlPressed(void) {
	return (HIWORD(GetKeyState(VK_CONTROL))!=0);
}

static void guiHideMouse(ContextPtr aContext) {
	ShowCursor(FALSE);
}

static void guiShowMouse(ContextPtr aContext) {
	ShowCursor(TRUE);
}

static void guiSetMenu(GuiWindowPtr aWindow, GuiMenu aMenu) {
	SetMenu(aWindow, aMenu);
}

static GuiMenu guiCreateMenu(void) {
	return CreateMenu();
}

static GuiMenu guiCreatePopupMenu(void) {
	return CreatePopupMenu();
}

static void guiDestroyMenu(GuiMenu aMenu) {
	DestroyMenu(aMenu);
}

EOF


rc(<<EOF);
static void fillIdFromAreaList(ContextPtr aContext, int x, int y) {
	int len=GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALISTUSEDLEN);
	RECT *list=(RECT*)GetWindowLong(aContext->currentWindow, WNDEXTRA_AREALIST);

	if (NULL!=list) {
		int i;

		aContext->id=0;
		for(i=0;i<len;i++) {
			if (x>=list[i].left && x<=list[i].right
			&& y>=list[i].top && y<=list[i].bottom) {
				aContext->id=i+1;
			}
		}    
	}  
}

static void dispatchMouseButton(HWND hwnd, GuiEvent aGuiEvent, int x, int y) {
	EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);
	if (NULL != eventFunc) {
		Context myContext;

		myContext.currentWindow=hwnd;
		myContext.userData=(void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
		myContext.hdc = GetDC(hwnd);
		myContext.mouseClientX=x;
		myContext.mouseClientY=y;
		POINT p={x,y};
		ClientToScreen(hwnd, &p);
		myContext.mouseX=p.x;
		myContext.mouseY=p.y;
		myContext.guiEvent=aGuiEvent;
		fillIdFromAreaList(&myContext, x, y);
		eventFunc(&myContext);

		SelectObject(myContext.hdc, GetStockObject(SYSTEM_FONT));
		SelectObject(myContext.hdc, GetStockObject(BLACK_PEN));
		SelectObject(myContext.hdc, GetStockObject(BLACK_BRUSH));
		ReleaseDC(hwnd, myContext.hdc);
	}
}

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL 0x020A
#endif

static int virtualMouseSpeed = 1;
static LRESULT CALLBACK stdWindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	HBITMAP myDoubleBufferBitmap=(HBITMAP)GetWindowLong(hwnd, WNDEXTRA_DOUBLEBUFFERBITMAP);
	LONG myDoubleBufferFlag=GetWindowLong(hwnd, WNDEXTRA_DOUBLEBUFFERFLAG);
	Context myContext;
	
//	logprintf("hwnd %08x  msg %d  lParam %d  wParam %d\\n", hwnd, uMsg, lParam, wParam);

	switch(uMsg) {
	case WM_CREATE:
		break;
	case WM_ACTIVATE: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (NULL != eventFunc) {
				myContext.currentWindow=hwnd;
				myContext.userData=(void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				POINT p;
				GetCursorPos(&p);
				myContext.mouseX=p.x;
				myContext.mouseY=p.y;
				ScreenToClient(hwnd, &p);
				myContext.mouseClientX=p.x;
				myContext.mouseClientY=p.y;
				if (LOWORD(wParam)==WA_INACTIVE) {
					myContext.guiEvent=GUIEVENT_LOSTFOCUS;
				} else {
					myContext.guiEvent=GUIEVENT_GETFOCUS;
				}
				eventFunc(&myContext);
			}
		} break;
	case WM_SIZE: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (myDoubleBufferBitmap) {
				DeleteObject(myDoubleBufferBitmap);
				myDoubleBufferBitmap=NULL;
			}

			if (NULL != eventFunc) {
				myContext.currentWindow=hwnd;
				myContext.userData=(void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				myContext.guiEvent=GUIEVENT_RESIZE;
				eventFunc(&myContext);
				InvalidateRect(hwnd, NULL, FALSE);
			}
		} break;
	case WM_DESTROYCLIPBOARD:
		if (clipboardHandle) {
			GlobalFree(clipboardHandle);
			clipboardHandle=NULL;
		}
		break;
	case WM_COMMAND: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (NULL != eventFunc) {
				myContext.currentWindow=hwnd;
				myContext.userData=(void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				switch(HIWORD(wParam)) {
				case 0: // Menu or button
					if (0 == lParam) {
						POINT p;
						GetCursorPos(&p);
						myContext.mouseX=p.x;
						myContext.mouseY=p.y;
						ScreenToClient(hwnd, &p);
						myContext.mouseClientX=p.x;
						myContext.mouseClientY=p.y;
						// Menu
						myContext.guiEvent=GUIEVENT_MENU;
						myContext.id=LOWORD(wParam);
						eventFunc(&myContext);
					} else {
						// Control
	//            dispatchControlEvent(hwnd, (HWND)lParam, HIWORD(wParam));
					}
					break;
				case 1: // Accelarator
					break;
				default: // Control
	//          dispatchControlEvent(hwnd, (HWND)lParam, HIWORD(wParam));
					break;
				}
			}
		} break;
	case WM_MOUSEWHEEL:
		guiVScrollWindowTo(hwnd, guiGetVScrollPos(hwnd)-((short)HIWORD(wParam))/4);
		break;
	case WM_HSCROLL: {
			SCROLLINFO myScrollInfo;
			myScrollInfo.cbSize=sizeof(myScrollInfo);
			myScrollInfo.fMask=SIF_POS | SIF_TRACKPOS | SIF_PAGE | SIF_RANGE;
			GetScrollInfo(hwnd, SB_HORZ, &myScrollInfo);
			int page=(int)myScrollInfo.nPage;
			int oldPos=myScrollInfo.nPos;
		
			switch(LOWORD(wParam)) {
			case SB_PAGEUP:
				myScrollInfo.nPos-=myScrollInfo.nPage;
				break;
			case SB_LINEUP:
				myScrollInfo.nPos-=16;
				break;
			case SB_PAGEDOWN:
				myScrollInfo.nPos+=myScrollInfo.nPage;
				break;
			case SB_LINEDOWN:
				myScrollInfo.nPos+=16;
				break;
			case SB_THUMBTRACK:
				myScrollInfo.nPos=myScrollInfo.nTrackPos;
				break;
			default:
				break;
			}

			if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
			if (myScrollInfo.nPos>myScrollInfo.nMax-page) myScrollInfo.nPos=myScrollInfo.nMax-page;
			if (oldPos != myScrollInfo.nPos) {
				myScrollInfo.cbSize=sizeof(myScrollInfo);
				myScrollInfo.fMask=SIF_POS;
				SetScrollInfo(hwnd, SB_HORZ, &myScrollInfo, TRUE);
				InvalidateRect(hwnd, NULL, FALSE);
			}
		} break;
	case WM_VSCROLL: {
			SCROLLINFO myScrollInfo;
			myScrollInfo.cbSize=sizeof(myScrollInfo);
			myScrollInfo.fMask=SIF_POS | SIF_TRACKPOS | SIF_PAGE | SIF_RANGE;
			GetScrollInfo(hwnd, SB_VERT, &myScrollInfo);
			int page=(int)myScrollInfo.nPage;
			int oldPos=myScrollInfo.nPos;
		
			switch(LOWORD(wParam)) {
			case SB_PAGEUP:
				myScrollInfo.nPos-=myScrollInfo.nPage;
				break;
			case SB_LINEUP:
				myScrollInfo.nPos-=16;
				break;
			case SB_PAGEDOWN:
				myScrollInfo.nPos+=myScrollInfo.nPage;
				break;
			case SB_LINEDOWN:
				myScrollInfo.nPos+=16;
				break;
			case SB_THUMBTRACK:
				myScrollInfo.nPos=myScrollInfo.nTrackPos;
				break;
			default:
				break;
			}

			if (myScrollInfo.nPos<myScrollInfo.nMin) myScrollInfo.nPos=myScrollInfo.nMin;
			if (myScrollInfo.nPos>myScrollInfo.nMax-page) myScrollInfo.nPos=max(myScrollInfo.nMin, myScrollInfo.nMax-page);
			if (oldPos != myScrollInfo.nPos) {
				myScrollInfo.cbSize=sizeof(myScrollInfo);
				myScrollInfo.fMask=SIF_POS;
				SetScrollInfo(hwnd, SB_VERT, &myScrollInfo, TRUE);
				InvalidateRect(hwnd, NULL, FALSE);
			}
		} break;
	case WM_PAINT: {
			PAINTSTRUCT ps;
			HDC hdc=BeginPaint(hwnd, &ps);
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (NULL != eventFunc) {
				GetClientRect(hwnd, &(myContext.guiClientRect));

				if (myDoubleBufferFlag && NULL==myDoubleBufferBitmap) {
				      myDoubleBufferBitmap=CreateCompatibleBitmap(hdc, myContext.guiClientRect.right, myContext.guiClientRect.bottom);
				}
				if ((!myDoubleBufferFlag) && myDoubleBufferBitmap) {
					DeleteObject(myDoubleBufferBitmap);
					myDoubleBufferBitmap=NULL;
				}
				if (myDoubleBufferBitmap) {
					myContext.hdc = CreateCompatibleDC(hdc);
					SelectObject(myContext.hdc, myDoubleBufferBitmap);
				} else {
					myContext.hdc = hdc;
				}

				myContext.currentWindow = hwnd;
				myContext.userData = (void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				POINT p;
				GetCursorPos(&p);
				myContext.mouseX=p.x;
				myContext.mouseY=p.y;
				ScreenToClient(hwnd, &p);
				myContext.mouseClientX=p.x;
				myContext.mouseClientY=p.y;
				myContext.guiEvent = GUIEVENT_REFRESH;
				eventFunc(&myContext);

				// Restore HDC to stock objects
				SelectObject(myContext.hdc, GetStockObject(SYSTEM_FONT));
				SelectObject(myContext.hdc, GetStockObject(BLACK_PEN));
				SelectObject(myContext.hdc, GetStockObject(BLACK_BRUSH));

				if (myDoubleBufferBitmap) {
					BitBlt(hdc, 0, 0, myContext.guiClientRect.right, myContext.guiClientRect.bottom, myContext.hdc, 0, 0, SRCCOPY);
					DeleteDC(myContext.hdc);
				}
			}

			EndPaint(hwnd, &ps);    
		} break;
	case WM_LBUTTONDOWN: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON1DOWN, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_LBUTTONUP: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON1UP, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_LBUTTONDBLCLK: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON1DCLK, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_RBUTTONDOWN: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON2DOWN, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_RBUTTONUP: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON2UP, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_RBUTTONDBLCLK: {
			dispatchMouseButton(hwnd, GUIEVENT_MOUSEBUTTON2DCLK, GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
		} break;
	case WM_KEYDOWN: {
			POINT pt;
			switch(wParam) {
			case VK_LEFT:
				if (GetKeyState(VK_CONTROL) < 0) {
					GetCursorPos(&pt);
					pt.x -= virtualMouseSpeed/2+1;
					SetCursorPos(pt.x, pt.y); 
				}
				break;
			case VK_RIGHT:
				if (GetKeyState(VK_CONTROL) < 0) {
					GetCursorPos(&pt);
					pt.x += virtualMouseSpeed/2+1;
					SetCursorPos(pt.x, pt.y);
				}
				break;
			case VK_UP:
				if (GetKeyState(VK_CONTROL) < 0) {
					GetCursorPos(&pt);
					pt.y -= virtualMouseSpeed/2+1;
					SetCursorPos(pt.x, pt.y); 
				}
				break;
			case VK_DOWN:
				if (GetKeyState(VK_CONTROL) < 0) {
					GetCursorPos(&pt);
					pt.y += virtualMouseSpeed/2+1;
					SetCursorPos(pt.x, pt.y);
				}
				break;
			default: {
					EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

					if (NULL != eventFunc) {
						myContext.currentWindow = hwnd;
						myContext.userData = (void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
						POINT p;
						GetCursorPos(&p);
						myContext.mouseX=p.x;
						myContext.mouseY=p.y;
						ScreenToClient(hwnd, &p);
						myContext.mouseClientX=p.x;
						myContext.mouseClientY=p.y;
						myContext.id=wParam;
						myContext.guiEvent = GUIEVENT_KEYDOWN;
						eventFunc(&myContext);
					}
				} break;
			}
			if (virtualMouseSpeed<16) virtualMouseSpeed++;
		} break;
	case WM_KEYUP: {
/*        switch(wParam) {
			case VK_ESCAPE:
				break;
			default: {
					EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);
					if (NULL != eventFunc) {
						ContextDef myContext=mainContext;
						GuiEvent guiEvent;

						guiEvent.guiEventType=GUIEVENT_KEYUP;
						myContext.currentWindow=hwnd;
						myContext.userData=(void*)GetWindowLong(hwnd, WNDEXTRA_USER_DATA);
						myContext.key=wParam;
						eventFunc(&myContext, &guiEvent);
					}
				} break;
			}*/
			virtualMouseSpeed = 1;
		} break;
	case WM_CHAR: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);
			if (NULL != eventFunc) {
				myContext.currentWindow = hwnd;
				myContext.userData = (void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				POINT p;
				GetCursorPos(&p);
				myContext.mouseX=p.x;
				myContext.mouseY=p.y;
				ScreenToClient(hwnd, &p);
				myContext.mouseClientX=p.x;
				myContext.mouseClientY=p.y;
				myContext.id=wParam;
				myContext.keyRepeatFlag=(lParam&0x40000000)?true:false;
				myContext.guiEvent = GUIEVENT_CHAR;
				eventFunc(&myContext);
			}
		} break;
	case WM_TIMER: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (NULL != eventFunc) {
				GetClientRect(hwnd, &(myContext.guiClientRect));
				myContext.currentWindow = hwnd;
				myContext.userData = (void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				POINT p;
				GetCursorPos(&p);
				myContext.mouseX=p.x;
				myContext.mouseY=p.y;
				ScreenToClient(hwnd, &p);
				myContext.mouseClientX=p.x;
				myContext.mouseClientY=p.y;
				myContext.id = 0;
				myContext.guiEvent = GUIEVENT_TIMERTICK;
				myContext.hdc = GetDC(hwnd);
				eventFunc(&myContext);
				// Restore HDC to stock objects
				SelectObject(myContext.hdc, GetStockObject(SYSTEM_FONT));
				SelectObject(myContext.hdc, GetStockObject(BLACK_PEN));
				SelectObject(myContext.hdc, GetStockObject(BLACK_BRUSH));
				ReleaseDC(hwnd, myContext.hdc);
			}
		} break;
	case WM_CLOSE: {
			EventFunc eventFunc=(EventFunc)GetWindowLong(hwnd, WNDEXTRA_EVENTFUNC);

			if (NULL != eventFunc) {
				myContext.currentWindow = hwnd;
				myContext.userData = (void*)GetWindowLong(hwnd, WNDEXTRA_USERDATA);
				myContext.guiEvent = GUIEVENT_CLOSE;
				eventFunc(&myContext);
			}
		} break;
	case WM_DESTROY: {
			RECT *list=(RECT*)GetWindowLong(hwnd, WNDEXTRA_AREALIST);

			if (list) {
				free(list);
			}
			if (myDoubleBufferBitmap) {
				DeleteObject(myDoubleBufferBitmap);
				myDoubleBufferBitmap=NULL;
			}
		} break;
	default:
		return DefWindowProc(hwnd, uMsg, wParam, lParam);
	}
	SetWindowLong(hwnd, WNDEXTRA_DOUBLEBUFFERBITMAP, (LONG)(void*)myDoubleBufferBitmap);
	~cc~refreshFunctions~
	return 0;
}

EOF

rv('bool quitFlag=false;');
rc(<<EOF);
static void mainLoop(void) {

	while (!quitFlag) {
		MSG myMsg;
		switch (GetMessage(&myMsg,NULL,0,0)) {
		case FALSE:
			quitFlag=true;
			break;
		case TRUE:
//      if (0==IsDialogMessage(configPanelWindow, &myMsg)) {
//       if (!TranslateMDISysAccel((HWND)GetWindowLong(context->mainWindow, WNDEXTRA_MDI_CLIENT), &myMsg)) {
			TranslateMessage(&myMsg);
			DispatchMessage(&myMsg);
//       }
			break;
		default:
			quitFlag=true;
			break;
		}
	}
}
EOF

my @wndExtraFields = qw(WNDEXTRA_EVENTFUNC WNDEXTRA_DOUBLEBUFFERFLAG WNDEXTRA_DOUBLEBUFFERBITMAP WNDEXTRA_AREALIST WNDEXTRA_AREALISTUSEDLEN WNDEXTRA_AREALISTMAXLEN WNDEXTRA_USERDATA);
my $wndExtraSize = scalar(@wndExtraFields)*4;
my $i;
for($i=0;$i<scalar(@wndExtraFields);$i++) {
	rv("const int $wndExtraFields[$i] = " . ($i*4) . ";");
}

rc(<<EOF);
static void createWindowClass(void) {
	WNDCLASSEX myClass;
	myClass.cbSize=sizeof(myClass);
	myClass.style=CS_DBLCLKS; /* Enable double click processing */
	myClass.lpfnWndProc=stdWindowProc;
	myClass.cbClsExtra=0;
	myClass.cbWndExtra=$wndExtraSize;
	myClass.hInstance=theInstance;
	myClass.hIcon=LoadIcon(theInstance, MAKEINTRESOURCE(IDI_MAINICON));
	myClass.hCursor=LoadCursor(NULL, IDC_ARROW);
	myClass.hbrBackground=NULL; // (HBRUSH)GetStockObject(GRAY_BRUSH);
	myClass.lpszMenuName=NULL;
	myClass.lpszClassName=mainWindowClass;
	myClass.hIconSm=NULL;
	mainClassAtom=RegisterClassEx(&myClass);
}
EOF

cc('mainInit', "createWindowClass();");
cci('mainTerm', "if (currentPen) DeleteObject(currentPen);");
cci('mainTerm', "if (currentBrush) DeleteObject(currentBrush);");

