##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Font related functions implemented for Qt
#
##########################################################################

ccModule('Font routines for Qt');

rv('GuiFont *titleFont;');
rv('GuiFont *potFont;');
rv('GuiFont *ioFont;');
rv('GuiFont *routerFont;');

rc(<<EOF);
static void guiSelectTitleFont(ContextPtr aContext) {
	aContext->currentPainter->setFont(*titleFont);
}

static void guiSelectPotFont(ContextPtr aContext) {
	aContext->currentPainter->setFont(*potFont);
}

static void guiSelectIOFont(ContextPtr aContext) {
	aContext->currentPainter->setFont(*ioFont);
}

static void guiSelectRouterFont(ContextPtr aContext) {
	aContext->currentPainter->setFont(*routerFont);
}

EOF

cc('mainInit', 'titleFont=new QFont("Courier New", 16);');
cci('mainTerm', 'delete titleFont;');
cc('mainInit', 'potFont=new QFont("Arial", 14);');
cci('mainTerm', 'delete potFont;');
# cc('mainInit', 'ioFont=new QFont("Arial", 12);');
cc('mainInit', 'ioFont=new QFont("Arial", 10, QFont::Light);');
cci('mainTerm', 'delete ioFont;');
cc('mainInit', 'routerFont=new QFont("Courier New", 14);');
cci('mainTerm', 'delete routerFont;');

