##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2005  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Font related functions implemented for Microsoft Windows GDI API
#
##########################################################################

rv('HFONT TitleFont;');
rv('HFONT PotFont;');
rv('HFONT IOFont;');
rv('HFONT RouterFont;');


rc(<<EOF);

static bool guiSelectTitleFont(ContextPtr context) {
	if (NULL!=context->hdc && NULL!=TitleFont) {
		SelectObject(context->hdc, TitleFont);
		return true;
	}
	return false;
}

static bool guiSelectPotFont(ContextPtr context) {
	if (NULL!=context->hdc && NULL!=PotFont) {
		SelectObject(context->hdc, PotFont);
		return true;
	}
	return false;
}

static bool guiSelectIOFont(ContextPtr context) {
	if (NULL!=context->hdc && NULL!=IOFont) {
		SelectObject(context->hdc, IOFont);
		return true;
	}
	return false;
}

static bool guiSelectRouterFont(ContextPtr context) {
	if (NULL!=context->hdc && NULL!=RouterFont) {
		SelectObject(context->hdc, RouterFont);
		return true;
	}
	return false;
}
EOF

cc('mainInit', "PotFont = CreateFont(");
cc('mainInit', "\t14, 0, 0, 0, FW_THIN, FALSE, FALSE, FALSE,");
cc('mainInit', "\tDEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,");
cc('mainInit', "\tPROOF_QUALITY, VARIABLE_PITCH | FF_DONTCARE, \"Arial\");");
cci('mainTerm', "DeleteObject(PotFont);");

cc('mainInit', "TitleFont = CreateFont(");
cc('mainInit', "\t16, 12, 0, 0, FW_THIN, FALSE, FALSE, FALSE,");
cc('mainInit', "\tDEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,");
cc('mainInit', "\tPROOF_QUALITY, FIXED_PITCH | FF_DONTCARE, \"Courier New\");");
cci('mainTerm', "DeleteObject(TitleFont);");

cc('mainInit', "IOFont = CreateFont(");
cc('mainInit', "\t12, 6, 0, 0, FW_THIN, FALSE, FALSE, FALSE,");
cc('mainInit', "\tDEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,");
cc('mainInit', "\tPROOF_QUALITY, VARIABLE_PITCH | FF_DONTCARE, \"Arial\");");
cci('mainTerm', "DeleteObject(IOFont);");

cc('mainInit', "RouterFont = CreateFont(");
cc('mainInit', "\t14,  0, 0, 0, FW_THIN, FALSE, FALSE, FALSE,");
cc('mainInit', "\tDEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,");
cc('mainInit', "\tPROOF_QUALITY, FIXED_PITCH | FF_DONTCARE, \"Courier New\");");
cci('mainTerm', "DeleteObject(RouterFont);");

