##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# StudioFactory file load/save routines
#
##########################################################################

ccModule('Load/Save STF files');


rd('static const int maxHeaderTitleSize=32;');

gEnum('LoadError');
cc('LoadErrorEnum', 'LOADERROR_OK', ',');
cc('LoadErrorEnum', 'LOADERROR_FILENOTOPEN', ',');
cc('LoadErrorEnum', 'LOADERROR_OTHERFORMAT', ',');
cc('LoadErrorEnum', 'LOADERROR_UNEXPECTED_EOF', ',');

gStruct('LoadInfo');
cc('LoadInfoStruct', 'LoadError loadError;');
cc('LoadInfoStruct', 'const char *filename;');
cc('LoadInfoStruct', 'FILE *file;');
cc('LoadInfoStruct', 'unsigned char *buffer;');
cc('LoadInfoStruct', 'int bufferSize;');
cc('LoadInfoStruct', 'int bufferPos;');
cc('LoadInfoStruct', 'int headerPos;');
cc('LoadInfoStruct', 'int dataSize;');
cc('LoadInfoStruct', 'char headerTitle[maxHeaderTitleSize];');
cc('LoadInfoStruct', 'bool saveSelectedOnly;');
cc('LoadInfoStruct', 'bool generatePatches;');
cc('LoadInfoStruct', 'bool copyPasteFlag;');
cc('LoadInfoStruct', 'bool mergeFlag;');
cc('LoadInfoStruct', 'int project;');
cc('LoadInfoStruct', 'int linkLoadId[maxDspObjects];');
cc('LoadInfoStruct', 'int linkCable[maxDspObjects][maxObjectIo];');
cc('LoadInfoStruct', 'int linkMyObject[maxDspObjects];');



rs(<<EOF);
static void loadReset(LoadInfo *loadInfo) {
	if (loadInfo->file) {
		fseek(loadInfo->file, 0, SEEK_SET);
	}
	loadInfo->bufferPos=0;
}

static void storeStfInteger(LoadInfo *loadInfo, int aValue) {
	unsigned char myBuffer[4];

	myBuffer[0]=(aValue >> 24) & 255;
	myBuffer[1]=(aValue >> 16) & 255;
	myBuffer[2]=(aValue >> 8) & 255;
	myBuffer[3]=aValue & 255;
	if (loadInfo->file) fwrite(myBuffer, 4, 1, loadInfo->file);
	if (loadInfo->buffer) memcpy(loadInfo->buffer+loadInfo->bufferPos, myBuffer, 4);
	loadInfo->bufferPos+=4;
}

static void storeStfBuffer(LoadInfo *loadInfo, const char *aBuffer, int aBufferSize) {
	if (aBuffer) {
		storeStfInteger(loadInfo, aBufferSize);
		if (loadInfo->file) fwrite(aBuffer, aBufferSize, 1, loadInfo->file);
		if (loadInfo->buffer) memcpy(loadInfo->buffer+loadInfo->bufferPos, aBuffer, aBufferSize);
		loadInfo->bufferPos+=aBufferSize;
	} else {
		storeStfInteger(loadInfo, 0);
	}
}

static void storeStfString(LoadInfo *loadInfo, const char *aString) {
	if (aString) {
		storeStfBuffer(loadInfo, aString, strlen(aString));
	} else {
		storeStfBuffer(loadInfo, NULL, 0);
	}
}

static bool readLittleEndianLong(LoadInfo *loadInfo, int *aValuePtr) {
	unsigned char myBuffer[4];

	if (loadInfo->file && fread(myBuffer, 4, 1, loadInfo->file)==1) {
		(*aValuePtr)=(myBuffer[3]<<24)+(myBuffer[2]<<16)+(myBuffer[1]<<8)+(myBuffer[0]);
		return true;
	} if (loadInfo->buffer && loadInfo->bufferPos<loadInfo->bufferSize) {
		(*aValuePtr) =(loadInfo->buffer[loadInfo->bufferPos++]);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]<<8);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]<<16);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]<<24);    
		return true;
	} else {
		(*aValuePtr)=0;
		return false;
	}
}

static bool readBigEndianShort(LoadInfo *loadInfo, int *aValuePtr) {
	unsigned char myBuffer[2];

	if (loadInfo->file && fread(myBuffer, 2, 1, loadInfo->file)==1) {
		(*aValuePtr)=(myBuffer[0]<<8)+(myBuffer[1]);
		return true;
	} if (loadInfo->buffer && loadInfo->bufferPos<loadInfo->bufferSize) {
		(*aValuePtr) =(loadInfo->buffer[loadInfo->bufferPos++]<<8);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]);    
		return true;
	} else {
		(*aValuePtr)=0;
		return false;
	}
}

static bool readBigEndianLong(LoadInfo *loadInfo, int *aValuePtr) {
	unsigned char myBuffer[4];

	if (loadInfo->file && fread(myBuffer, 4, 1, loadInfo->file)==1) {
		(*aValuePtr)=(myBuffer[0]<<24)+(myBuffer[1]<<16)+(myBuffer[2]<<8)+(myBuffer[3]);
		return true;
	} if (loadInfo->buffer && loadInfo->bufferPos<loadInfo->bufferSize) {
		(*aValuePtr) =(loadInfo->buffer[loadInfo->bufferPos++]<<24);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]<<16);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]<<8);
		(*aValuePtr)+=(loadInfo->buffer[loadInfo->bufferPos++]);    
		return true;
	} else {
		(*aValuePtr)=0;
		return false;
	}
}

static bool readBuffer(LoadInfo *loadInfo, char *aBuffer, int aBufferLength) {
	bool myReturnValue=false;

	if (loadInfo->file) {
		if (fread(aBuffer, aBufferLength, 1, loadInfo->file)==1) {
			myReturnValue=true;
		}
	} else {
		// !!! test if enough bytes are in readBuffer
		memcpy(aBuffer, loadInfo->buffer+loadInfo->bufferPos, aBufferLength);
		loadInfo->bufferPos+=aBufferLength;
		myReturnValue=true;
	}

	return myReturnValue;
}

static bool readStfInteger(LoadInfo *loadInfo, int *aValuePtr) {
	return readBigEndianLong(loadInfo, aValuePtr);
}

static bool readStfString(LoadInfo *loadInfo, char *buffer, int bufferLength) {
	int curPos;
	int loadStringLength;
	int len;
	
	if ((!readStfInteger(loadInfo, &loadStringLength)) || loadStringLength<0) return false;
	if (loadInfo->file) {
		curPos=ftell(loadInfo->file);
		len=min(loadStringLength, bufferLength-1);
		memset(buffer, 0, bufferLength);
		if (len>0) {
			fread(buffer, len, 1, loadInfo->file);
			fseek(loadInfo->file, curPos+loadStringLength, SEEK_SET);
		}
	} else {
		len=min(loadStringLength, bufferLength-1);
		memset(buffer, 0, bufferLength);
		memcpy(buffer, loadInfo->buffer+loadInfo->bufferPos, len);
		loadInfo->bufferPos+=loadStringLength;
	}
	return true;
}

static bool allocateStfString(LoadInfo *loadInfo, char **string) {
	int len;
	char *str;

	if ((!readStfInteger(loadInfo, &len)) || len<0) return false;
	str=(char*)malloc(len+1);
	if (loadInfo->file) {
		memset(str, 0, len+1);
		fread(str, len, 1, loadInfo->file);
	} else {
		str[len]='\\0';
		memcpy(str, loadInfo->buffer+loadInfo->bufferPos, len);
		loadInfo->bufferPos+=len;
	}
	*string=str;
	return true;
}

static void storeStfBegin(LoadInfo *loadInfo, const char *aHeaderTitle) {
	storeStfString(loadInfo, aHeaderTitle);
	if (loadInfo->file) {
		loadInfo->headerPos=ftell(loadInfo->file);
	} else {
		loadInfo->headerPos=loadInfo->bufferPos;
	}
	storeStfInteger(loadInfo, 0);
}

static void storeStfEnd(LoadInfo *loadInfo) {
	int curPos;

	if (loadInfo->file) {
		curPos=ftell(loadInfo->file);
		fseek(loadInfo->file, loadInfo->headerPos, SEEK_SET);
		storeStfInteger(loadInfo, curPos-(loadInfo->headerPos+4));
		fseek(loadInfo->file, curPos, SEEK_SET);
	} else {
		curPos=loadInfo->bufferPos;
		loadInfo->bufferPos=loadInfo->headerPos;
		storeStfInteger(loadInfo, curPos-(loadInfo->headerPos+4));
		loadInfo->bufferPos=curPos;
	}
}

static bool readStfHeader(LoadInfo *loadInfo) {
	bool result=readStfString(loadInfo, loadInfo->headerTitle, maxHeaderTitleSize);
	readStfInteger(loadInfo, &(loadInfo->dataSize));
	if (loadInfo->file) {
		loadInfo->headerPos = ftell(loadInfo->file);
	} else {
		loadInfo->headerPos = loadInfo->bufferPos;
	}
	return result;
}

EOF


rc(<<EOF);
static void loadClearRewireTables(LoadInfo *loadInfo) {
	memset(loadInfo->linkLoadId, 0, sizeof(loadInfo->linkLoadId));
	memset(loadInfo->linkMyObject, 0, sizeof(loadInfo->linkMyObject));
	memset(loadInfo->linkCable, 0, sizeof(loadInfo->linkCable));
}

static void loadRewire(LoadInfo *loadInfo, int patch) {
	// connect the cables
	int idsp,odsp,input;
	for(idsp=0;idsp<maxDspObjects;idsp++) {
		if (loadInfo->linkMyObject[idsp]>=0) {
			for(input=0;input<maxObjectIo;input++) {
				if (loadInfo->linkCable[idsp][input]) {
					for(odsp=0;odsp<maxDspObjects;odsp++) {
						if (loadInfo->linkLoadId[odsp]==loadInfo->linkCable[idsp][input]) {
							selectOutput(&(projects[theCurrentProject].patches[patch]), loadInfo->linkMyObject[odsp], projects[theCurrentProject].patches[patch].objects[loadInfo->linkMyObject[idsp]].connections[input].fromOutput);
							connectCable(theCurrentProject, patch, loadInfo->linkMyObject[idsp], input, projects[theCurrentProject].patches[patch].objects[loadInfo->linkMyObject[idsp]].connections[input].cableColor);
						}
					}
				}
			}
		}
	}
}

static void loadStf(LoadInfo *loadInfo) {
	int patch=currentPatch;
	int module=-1;
	bool savedModified=false;
	// When cloning we want the new objects to be selected, so they can be moved to a new location.
	// selectNew is true when we paste in existing patch. secondObject is a flag set after the first object is created so a existing
	// selection can first be removed. Then this flag prevents the previous inserted object(s) from de-selection.
	bool secondObject=false;
	bool selectNew=true;
	bool firstProject=true;
	readStfHeader(loadInfo);

	loadClearRewireTables(loadInfo);

	if (strcmp(loadInfo->headerTitle, "STUDIOFACTORY100")!=0) {
		logprintf("Not a StudioFactory (STF) file. File doesn't start with STUDIOFACTORY100 chunk.\\n");
		return;
	}

	loadInfo->loadError=LOADERROR_OK;
	loadInfo->project=theCurrentProject;
	while (readStfHeader(loadInfo)) {
		~cc~stfLoad100~
		~cc~stfLoad~
		if (strcmp(loadInfo->headerTitle, "ProjectBegin")==0) {
			if (loadInfo->project<0 || !firstProject || !loadInfo->mergeFlag) {
				loadInfo->project=createProject(NULL);
				if (loadInfo->project>=0) {
					allocateStfString(loadInfo, &projects[loadInfo->project].projectName);
				}
				// We just loaded it from disk so can clear modifiedFlag.
				// One small problem for autoload.stf which can contain unsaved projects.
				// savedModified is set by adding a ProjectModified chunk. Chunk only found in autoload.stf
				savedModified=false;
				patch=-1;
			}
			firstProject=false;
		}
		if (strcmp(loadInfo->headerTitle, "ProjectPath")==0) {
			allocateStfString(loadInfo, &projects[loadInfo->project].projectPath);
		}
		if (strcmp(loadInfo->headerTitle, "ProjectModified")==0) {
			savedModified=true;
		}
		if (strcmp(loadInfo->headerTitle, "PatchBegin")==0) {
			patch=createSynfactoryPatch();
			selectNew=false;
//      loadClearRewireTables(loadInfo);
		}
		if (strcmp(loadInfo->headerTitle, "PatchMidi")==0 && patch>=0) {
			readStfInteger(loadInfo, &projects[loadInfo->project].patches[patch].midiPort);
			readStfInteger(loadInfo, &projects[loadInfo->project].patches[patch].midiChannel);
			if (loadInfo->dataSize>=12) {
				readStfInteger(loadInfo, &projects[loadInfo->project].patches[patch].sustainCC);
			}
		}
		if (strcmp(loadInfo->headerTitle, "ModuleBegin")==0) {
			if (patch<0) {
				// hack
				if (projects[loadInfo->project].maxPatches>0) {
					patch=0;
				} else {
					patch=createSynfactoryPatch();
					selectNew=false;
				}
			}
			ObjectType type=OBJ_NONE;
			char moduleTypeString[32];
			int loadId=-1;
			int i;

			readStfInteger(loadInfo, &loadId);
			readStfString(loadInfo, moduleTypeString, 32);

			for(i=0;objectLoadNames[i];i++) {
				if (strcmp(objectLoadNames[i], moduleTypeString)==0) {
					type=(ObjectType)i;
					break;
				}
			}
			if (type!=OBJ_NONE) {
				module=addSynFactoryObject(patch, type, secondObject && selectNew);
				secondObject=true;
				if (module>=0 && projects[theCurrentProject].patches[patch].objects[module].dsp) {
					loadInfo->linkLoadId[projects[theCurrentProject].patches[patch].objects[module].dsp]=loadId;
					loadInfo->linkMyObject[projects[theCurrentProject].patches[patch].objects[module].dsp]=module;
				}
			}
		}
		if (strcmp(loadInfo->headerTitle, "ModulePosition") == 0 && module>=0 && patch>=0) {
			int x=0,y=0;
			readStfInteger(loadInfo, &x);
			readStfInteger(loadInfo, &y);
			projects[theCurrentProject].patches[patch].objects[module].x=x+projects[theCurrentProject].patches[patch].offsX;
			projects[theCurrentProject].patches[patch].objects[module].y=y+projects[theCurrentProject].patches[patch].offsY;
		}
		if (strcmp(loadInfo->headerTitle, "ModuleLabel") == 0 && module>=0 && patch>=0) {
			int f=0;
			readStfInteger(loadInfo, &f);
			projects[theCurrentProject].patches[patch].objects[module].showLabel=(f!=0);
		}
		if (strcmp(loadInfo->headerTitle, "ModuleCable") == 0 && module>=0 && patch>=0) {
			int i=-1,n,o,c;
			readStfInteger(loadInfo, &i);
			readStfInteger(loadInfo, &n);
			readStfInteger(loadInfo, &o);
			readStfInteger(loadInfo, &c);
			if (i>=0 && i<maxObjectIo) {
				loadInfo->linkCable[projects[theCurrentProject].patches[patch].objects[module].dsp][i]=n;
				projects[theCurrentProject].patches[patch].objects[module].connections[i].fromOutput=o;
				projects[theCurrentProject].patches[patch].objects[module].connections[i].cableColor=c;
			}
		}
		if (strcmp(loadInfo->headerTitle, "ModuleKnob") == 0 && module>=0 && patch>=0) {
			int i=-1,v;
			readStfInteger(loadInfo, &i);
			readStfInteger(loadInfo, &v);
			if (i>=0 && i<maxObjectIo && projects[theCurrentProject].patches[patch].objects[module].dsp) {
				projects[theCurrentProject].dsp[projects[theCurrentProject].patches[patch].objects[module].dsp].io[i].knob=v;
			}
		}
		if (strcmp(loadInfo->headerTitle, "ModuleName") == 0 && module>=0 && patch>=0) {
			allocateStfString(loadInfo, &(projects[theCurrentProject].patches[patch].objects[module].name));
			if (projects[theCurrentProject].patches[patch].objects[module].dsp) {
				updateModuleLabel(&(projects[theCurrentProject].patches[patch]), module, 0);
			}
		}
		if (strcmp(loadInfo->headerTitle, "ModuleScript") == 0 && module>=0 && patch>=0 && projects[theCurrentProject].patches[patch].objects[module].objectType==OBJ_NOTESCRIPT) {
			lockMutex(theAudioMutex);
			allocateStfString(loadInfo, &(projects[theCurrentProject].dsp[projects[theCurrentProject].patches[patch].objects[module].dsp].scriptInfo->script));
			unlockMutex(theAudioMutex);
		}
		if (strcmp(loadInfo->headerTitle, "ModuleBuffer") == 0 && module>=0 && patch>=0) {
			readStfString(loadInfo, (char *)projects[theCurrentProject].dsp[projects[theCurrentProject].patches[patch].objects[module].dsp].buffer, objectBufferSize(projects[theCurrentProject].patches[patch].objects[module].objectType));
		}
		if (strcmp(loadInfo->headerTitle, "ModuleSize") == 0 && module>=0 && patch>=0 && projects[theCurrentProject].patches[patch].objects[module].dsp==0) {
			readStfInteger(loadInfo, &(projects[theCurrentProject].patches[patch].objects[module].xs));
			readStfInteger(loadInfo, &(projects[theCurrentProject].patches[patch].objects[module].ys));
		}
		if (strcmp(loadInfo->headerTitle, "ModuleColor") == 0 && module>=0 && patch>=0 && projects[theCurrentProject].patches[patch].objects[module].dsp==0) {
			readStfInteger(loadInfo, &(projects[theCurrentProject].patches[patch].objects[module].mainColor));
			readStfInteger(loadInfo, &(projects[theCurrentProject].patches[patch].objects[module].borderColor));
		}
		if (strcmp(loadInfo->headerTitle, "ModuleMode") == 0 && module>=0 && patch>=0) {
			int m=0;
			readStfInteger(loadInfo, &m);
			setMode(theCurrentProject, patch, module, m);
		}
		if (strcmp(loadInfo->headerTitle, "ModuleEnd")==0) {
			module=-1;
		}
		if (strcmp(loadInfo->headerTitle, "PatchEnd")==0) {
			loadRewire(loadInfo, patch);
			loadClearRewireTables(loadInfo);
			module=-1;
			patch=-1;
		}
		if (strcmp(loadInfo->headerTitle, "ProjectEnd")==0) {
			if (patch>=0) {
				loadRewire(loadInfo, patch);
				loadClearRewireTables(loadInfo);
			}
			module=-1;
			patch=-1;
			// We just loaded it from disk so can clear modifiedFlag.
			// One small problem for autoload.stf which can contain unsaved projects.
			// savedModified is set by adding a ProjectModified chunk. Chunk only found in autoload.stf
			setProjectModifiedFlag(theCurrentProject, savedModified);
		}
		if (strcmp(loadInfo->headerTitle, "STUDIOFACTORYEND")==0) {
			if (patch>=0) {
				loadRewire(loadInfo, patch);
			}
			if (!(loadInfo->mergeFlag) && theCurrentProject>=0 && NULL==projects[theCurrentProject].projectPath) {
				setProjectPath(theCurrentProject, loadInfo->filename);
			}
			// leave loop (end of file)
			break;
		}
		if (loadInfo->file) {
			fseek(loadInfo->file, loadInfo->headerPos+loadInfo->dataSize, SEEK_SET);
		} else {
			loadInfo->bufferPos=loadInfo->headerPos+loadInfo->dataSize;
		}
	}
}
EOF
