rs(<<EOF);
#include "lame_enc.h"
static HINSTANCE        LameDLL=NULL;
static BEINITSTREAM     beInitStream=NULL;
static BEENCODECHUNK		beEncodeChunk=NULL;
static BEDEINITSTREAM   beDeinitStream=NULL;
static BECLOSESTREAM    beCloseStream=NULL;
static BEVERSION        beVersion=NULL;
//static BEWRITEVBRHEADER	beWriteVBRHeader=NULL;
static BYTE mp3buffer[20000];
static bool initLameDLLReady=false;
static HBE_STREAM mp3StreamID =0;

//
// Open Lame encoder and set various work variables
//
static void initLameDLL(void) {
  BE_VERSION Version;

  if (!initLameDLLReady) {
    logprintf("Initialising Lame encoder.\\n");
    if (LameDLL==NULL) {
      LameDLL = LoadLibrary("lame_enc.dll");
      if (LameDLL==NULL) {
        logprintf("Failed to load 'lame_enc.dll'.\\n");
        return;
      }
    }

    // Get Interface functions from the DLL
    if (beInitStream==NULL) beInitStream=(BEINITSTREAM)GetProcAddress(LameDLL, TEXT_BEINITSTREAM);
    if (beEncodeChunk==NULL) beEncodeChunk=(BEENCODECHUNK)GetProcAddress(LameDLL, TEXT_BEENCODECHUNK);
    if (beDeinitStream==NULL) beDeinitStream=(BEDEINITSTREAM)GetProcAddress(LameDLL, TEXT_BEDEINITSTREAM);
    if (beCloseStream==NULL) beCloseStream=(BECLOSESTREAM)GetProcAddress(LameDLL, TEXT_BECLOSESTREAM);
    if (beVersion==NULL) beVersion=(BEVERSION)GetProcAddress(LameDLL, TEXT_BEVERSION);
//	  if (beWriteVBRHeader==NULL) beWriteVBRHeader=(BEWRITEVBRHEADER)GetProcAddress(LameDLL, TEXT_BEWRITEVBRHEADER);

//    if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion || !beWriteVBRHeader) {
    if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion) {
		  logprintf("Error was unable to get all interfaces to Lame encoder.\\n");
		  return;
    }

    // Get the version number
    memset(&Version, 0, sizeof(Version));
    (*beVersion)(&Version);

    logprintf(
      "lame_enc.dll version %u.%02u (%u/%u/%u)\\n"
      "lame_enc Engine %u.%02u\\n"
      "lame_enc homepage at %s\\n",	
      Version.byDLLMajorVersion, Version.byDLLMinorVersion,
      Version.byDay, Version.byMonth, Version.wYear,
      Version.byMajorVersion, Version.byMinorVersion,
      Version.zHomepage);

    logprintf("Activated Lame encoder\\n");
    initLameDLLReady=true;
  }
}

static void createMp3File(Sample *sample, const char *filename) {
      initLameDLL();
      if (initLameDLLReady) {
        DWORD  dwSamples   =0;
        DWORD  dwMP3Buffer =0;
        BE_ERR err         =0;
        BE_CONFIG beConfig;

        memset(&beConfig,0,sizeof(beConfig));  // clear all fields

        // use the MP3 config structure, since this is the only one supported right now
        beConfig.dwConfig = BE_CONFIG_MP3;

        beConfig.format.mp3.dwSampleRate = 44100;               // SAMPLE RATE
        beConfig.format.mp3.byMode       = BE_MP3_MODE_STEREO;  // STEREO
        beConfig.format.mp3.wBitrate     = 128;                 // BITRATE
        beConfig.format.mp3.bOriginal    = TRUE;                // SET ORIGINAL FLAG

        err = beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &mp3StreamID);

        // Check result
        if(err != BE_ERR_SUCCESSFUL) {
          logprintf("Error opening MP3 encoding stream (%lu)\\n", err);
        } else {
          sample->file=fopen(filename, "wb");
        }
      }
}

static void closeMp3File(Sample *aSample) {
        DWORD bytesEncoded;

        beDeinitStream(mp3StreamID, mp3buffer, &bytesEncoded);
        if (bytesEncoded > 0 ) {
          fwrite(mp3buffer, bytesEncoded, 1, aSample->file);
        }
        beCloseStream(mp3StreamID);
}

static void writeMp3Data(Sample *sample, void *sampleData, int nrSamples) {
        DWORD bytesEncoded;

        beEncodeChunk(mp3StreamID, nrSamples, (short *)sampleData, mp3buffer, &bytesEncoded);
        sample->storedNoofSamples+=nrSamples;
        if (bytesEncoded>0) {
          fwrite(mp3buffer, bytesEncoded, 1, sample->file);
        }
}

EOF
