##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Standard midi file load/save routines
#
##########################################################################

gModule('Load/Save MID files');

rc(<<EOF);

static const unsigned char chunk_MThd[8]={'M','T','h','d', 0, 0, 0, 6};
static const unsigned char chunk_MTrk[4]={'M','T','r','k'};
static void loadMid(LoadInfo *loadInfo) {
	unsigned char tmp[256];
	int myFileType;
	int myNumTracks;
	int myDivision;

	if (!readAndCompare(loadInfo, tmp, 8, chunk_MThd, 8)) {
		logprintf("Not a standard MIDI file. The MThd chunk is missing.\\n");
		return;
	}
	readBigEndianShort(loadInfo, &myFileType);
	readBigEndianShort(loadInfo, &myNumTracks);
	readBigEndianShort(loadInfo, &myDivision);
	logprintf("file type %d  numtracks %d\\n", myFileType, myNumTracks);

	createProject(newProjectName);
	createSequencer(newSequencerName);
	do {
		if (!readBuffer(loadInfo, (char *)tmp, 4)) {
			goto loadMidEofError;
		}
		if (memcmp(tmp, chunk_MTrk, 4)==0) {
			myNumTracks--;
			//createTrack();
			// createSection();
		}
	} while(myNumTracks>0);
	loadInfo->loadError=LOADERROR_OK;
	return;
loadMidEofError:
	loadInfo->loadError=LOADERROR_UNEXPECTED_EOF;
	return;
}

EOF
