##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2007  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Config panel
#
##########################################################################

cc('showConfigPanel', 'guiShowWindow(configPanelWindow);');
cc('globalConfig', 'configPanelWindowRefresh = true;');
cc('theCurrentCableType', 'configPanelWindowRefresh = true;');
cc('theCurrentLanguage', 'configPanelWindowRefresh = true;');

rv('const int colorSteps=16;');

my %configCategories=();


sub configAddCategory {
	my $panel = shift;
	my $category = shift;

	# category already known for this (config)panel? If not add to list.
	if (!defined($configCategories{"${panel}${category}"})) {
		cc("${panel}Draw", "~cc~${panel}${category}Draw~");
		cc("${panel}Button1", "~cc~${panel}${category}Button1~");
		$configCategories{"${panel}${category}"}++;

		cc("${panel}${category}Draw", "configWindowHeader(aContext, x+4, &y, $category);");
	}
}

#sub configAddStringArray {
#}

#sub configAddStringPointerArray {
#	my $panel = shift;
#	my $category = shift;
#	my $itemDescription = shift;
#	my $itemName = shift;
#	my $listName = shift;
#
#	configAddCategory($panel, $category);
#
#	cc("$itemName", "~cc~${panel}~");
#}

sub configAddColorSelector {
	my $panel = shift;
	my $category = shift;
	my $itemDescription = shift;
	my $itemName = shift;

	configAddCategory($panel, $category);

	cc("${panel}${category}Draw", "configWindowHeader(aContext, x+12, \&y, $itemDescription);");
	cc("${panel}${category}Draw", "configDrawColorBar(aContext, x, &y, $itemName);");
	cc("${panel}${category}Button1", "for(j=0;j<colorSteps;j++) {");
	cc("${panel}${category}Button1", "\tfor(i=0;i<3;i++) {");
	cc("${panel}${category}Button1", "\t\tmyId++;");
	cc("${panel}${category}Button1", "\t\tif (myId==aContext->id) {");
	cc("${panel}${category}Button1", "\t\t\tint newColor = $itemName;");
	cc("${panel}${category}Button1", "\t\t\tnewColor &= colorNotMask[i];");
	cc("${panel}${category}Button1", "\t\t\tnewColor |= colorSelector[i][j];");
	cc("${panel}${category}Button1", "\t\t\t" . nameSetFunction($itemName) . '(newColor);');
	cc("${panel}${category}Button1", "\t\t}");
	cc("${panel}${category}Button1", "\t}");
	cc("${panel}${category}Button1", "}");
	cc("$itemName", "~cc~${panel}~");
}

rs(<<EOF);
static const char * const midiUnSelectedPortNames=      " off   A    B    C    D    E    F    G    H    I    J    K    L    M    N    O    P    Q    R    S    T    U    V    W    X    Y    Z  ";
static const char * const midiSelectedPortNames=        "[off][ A ][ B ][ C ][ D ][ E ][ F ][ G ][ H ][ I ][ J ][ K ][ L ][ M ][ N ][ O ][ P ][ Q ][ R ][ S ][ T ][ U ][ V ][ W ][ X ][ Y ][ Z ]";
static const char * const midiUnSelectedChannelAllNames=" all   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16 ";
static const char * const midiSelectedChannelAllNames=  "[all][ 1 ][ 2 ][ 3 ][ 4 ][ 5 ][ 6 ][ 7 ][ 8 ][ 9 ][ 10][ 11][ 12][ 13][ 14][ 15][ 16]";
static const char * const midiUnSelectedChannelOffNames=" off   1    2    3    4    5    6    7    8    9    10   11   12   13   14   15   16 ";
static const char * const midiSelectedChannelOffNames=  "[off][ 1 ][ 2 ][ 3 ][ 4 ][ 5 ][ 6 ][ 7 ][ 8 ][ 9 ][ 10][ 11][ 12][ 13][ 14][ 15][ 16]";

static void configWindowAddHitArea(ContextPtr aContext, int x1, int y, int x2) {
	guiAddArea(aContext, x1, y, x2, y+14);
}
static void configWindowHeader(ContextPtr aContext, int x, int *y, int stringIndex) {
	guiSelectPen1Color(aContext, 0x004466);
	guiDrawText(aContext, x, *y, strings[stringIndex][theCurrentLanguage], strlen(strings[stringIndex][theCurrentLanguage]));
	(*y)+=14;
}
static void configWindowHeader2(ContextPtr aContext, int x, int *y, int stringIndex) {
	guiSelectPen1Color(aContext, 0x446688);
	guiDrawText(aContext, x, *y, strings[stringIndex][theCurrentLanguage], strlen(strings[stringIndex][theCurrentLanguage]));
	(*y)+=14;
}
static void configWindowHeaderStr(ContextPtr aContext, int x, int *y, const char *str) {
	guiSelectPen1Color(aContext, 0x446688);
	guiDrawText(aContext, x, *y, str, strlen(str));
	(*y)+=14;
}
static void configWindowItem(ContextPtr aContext, int x, int *y, bool select, int stringIndex) {
	guiSelectPen1Color(aContext, 0x000000);
	if (select) {
		guiDrawText(aContext, x+20, *y, "==>", 3);
	}
	guiDrawText(aContext, x+40, *y, strings[stringIndex][theCurrentLanguage], strlen(strings[stringIndex][theCurrentLanguage]));
	configWindowAddHitArea(aContext, aContext->guiClientRect.left, *y, aContext->guiClientRect.right);
	(*y)+=14;
}
static void configWindowItemStr(ContextPtr aContext, int x, int *y, bool select, const char *str) {
	guiSelectPen1Color(aContext, 0x000000);
	if (select) {
		guiDrawText(aContext, x+20, *y, "==>", 3);
	}
	guiDrawText(aContext, x+40, *y, str, strlen(str));
	configWindowAddHitArea(aContext, aContext->guiClientRect.left, *y, aContext->guiClientRect.right);
	(*y)+=14;
}
static int colorNotMask[3]={0xFFFF00,0xFF00FF,0x00FFFF};
static int colorMask[3]={0x0000FF,0x00FF00,0xFF0000};
static int colorSelector[3][colorSteps]={
	{0x000000,0x000011,0x000022,0x000033,0x000044,0x000055,0x000066,0x000077,0x000088,0x000099,0x0000AA,0x0000BB,0x0000CC,0x0000DD,0x0000EE,0x0000FF},
	{0x000000,0x001100,0x002200,0x003300,0x004400,0x005500,0x006600,0x007700,0x008800,0x009900,0x00AA00,0x00BB00,0x00CC00,0x00DD00,0x00EE00,0x00FF00},
	{0x000000,0x110000,0x220000,0x330000,0x440000,0x550000,0x660000,0x770000,0x880000,0x990000,0xAA0000,0xBB0000,0xCC0000,0xDD0000,0xEE0000,0xFF0000}};
static void configDrawColorBar(ContextPtr aContext, int x, int *y, int current) {
	int i,j;

	guiSelectPen1Color(aContext, -1);
	for(i=0;i<colorSteps;i++) {
		for(j=0;j<3;j++) {
			guiSelectFillColor(aContext, (current&colorNotMask[j])+colorSelector[j][i]);
			guiDrawRect(aContext, x+30+i*14, (*y)+20*j, x+30+i*14+10, (*y)+20*j+12);
			guiSelectFillColor(aContext, ((current&colorMask[j])==colorSelector[j][i])?0:0xFFFFFF);
			guiDrawRect(aContext, x+30+i*14, (*y)+20*j+13, x+30+i*14+10, (*y)+20*j+15);
			guiAddArea(aContext, x+30+i*14, (*y)+20*j, x+30+i*14+10, (*y)+20+20*j);
		}
	}
	(*y)+=60;
}

EOF
rc(<<EOF);
static void configWindowHandler(ContextPtr aContext) {
	static int maxxsize=0;
	static int maxy=0;
	static int maxysize=0;

	switch (aContext->guiEvent) {
		case GUIEVENT_REFRESH: {
			int y=-guiGetVScrollPos(aContext->currentWindow);
			int x=-guiGetHScrollPos(aContext->currentWindow);
			int i;

			guiClearAreaList(aContext);

			guiSelectFillColor(aContext, 0xFFFFFF);
			guiSelectPen1Color(aContext, -1);
			guiDrawRect(
				aContext,
				aContext->guiClientRect.left,
				aContext->guiClientRect.top,
				aContext->guiClientRect.right,
				aContext->guiClientRect.bottom);
			guiSelectPotFont(aContext);
			guiDrawTransparent(aContext);

			configWindowHeader(aContext, x+ 4, &y, STRING_GENERAL_SETTINGS);
			configWindowHeader(aContext, x+12, &y, STRING_LANGUAGE);
			for(i=0;languageCodes[i];i++) {
				configWindowItemStr(aContext, x, &y, theCurrentLanguage==i, strings[STRING_LANGUAGE_NAME][i]);
			}
			configWindowHeader(aContext, x+12, &y, STRING_CABLE_TYPE);
			for(i=0;cableTypeList[i]!=STRING_;i++) {
				configWindowItemStr(aContext, x, &y, theCurrentCableType==i, strings[cableTypeList[i]][theCurrentLanguage]);
			}
	//		configWindowHeader(aContext, x+12, &y, STRING_DOUBLE_BUFFER_MAIN);
	//		configWindowItem(aContext, x, &y, false, STRING_YES);
	//		configWindowItem(aContext, x, &y, false, STRING_NO);
			~cc~globalConfigDraw~

			configWindowHeader(aContext, x+ 4, &y, STRING_AUDIO_SETTINGS);
			configWindowHeader(aContext, x+12, &y, STRING_AUDIO_INPUT);
			configWindowHeader(aContext, x+20, &y, STRING_AUDIO_IN_DEVICE);
			for(i=0;audioInDeviceNames[i];i++) {
				configWindowItemStr(aContext, x, &y, currentAudioInDevice==i, audioInDeviceNames[i]);
			}
			configWindowHeader(aContext, x+20, &y, STRING_BUFFER_SIZE);
			for(i=0;audioBufferLengthTable[i];i++) {
				char tmp[32];
				itoa(audioBufferLengthTable[i], tmp, 10);
				configWindowItemStr(aContext, x, &y, nextAudioInBufferSize==audioBufferLengthTable[i], tmp);
			}
			configWindowHeader(aContext, x+12, &y, STRING_AUDIO_OUTPUT);
			configWindowHeader(aContext, x+20, &y, STRING_AUDIO_OUT_DEVICE);
			for(i=0;audioOutDeviceNames[i];i++) {
				configWindowItemStr(aContext, x, &y, currentAudioOutDevice==i, audioOutDeviceNames[i]);
			}
			if (currentAudioOutDevice>1) {
				configWindowHeader(aContext, x+20, &y, STRING_NOOF_BUFFERS);
				for(i=2;i<9;i++) {
					char tmp[32];
					itoa(i, tmp, 10);
					configWindowItemStr(aContext, x, &y, DSP_NewNoofBuffers==i, tmp);
				}
			}
			configWindowHeader(aContext, x+20, &y, STRING_BUFFER_SIZE);
			for(i=0;audioBufferLengthTable[i];i++) {
				char tmp[32];
				itoa(audioBufferLengthTable[i], tmp, 10);
				configWindowItemStr(aContext, x, &y, nextAudioOutBufferSize==audioBufferLengthTable[i], tmp);
			}
			configWindowHeader(aContext, x+20, &y, STRING_LATENCY);
			{
				char tmp[32];
				if (currentAudioOutDevice>1) {
					sprintf(tmp, "%d ms / %d ms", (nextAudioOutBufferSize*1000)/88200, (DSP_NewNoofBuffers*nextAudioOutBufferSize*1000)/88200);
				} else {
					sprintf(tmp, "%d ms", (nextAudioOutBufferSize*1000)/88200);
				}
				configWindowHeaderStr(aContext, x+20, &y, tmp);
			}
			configWindowHeader(aContext, x+12, &y, STRING_JOYSTICK);
			for(i=0;i<4;i++) {
				configWindowItemStr(aContext, x, &y, theJoystickMode==i, strings[STRING_JOYSTICK0+i][theCurrentLanguage]);
			}

			configWindowHeader(aContext,  x+4, &y, STRING_MIDI_SETTINGS);

	// Virtual keyboard
			configWindowHeader(aContext, x+12, &y, STRING_MIDI_VIRTUAL_KEYBOARD);
			configWindowHeader2(aContext, x+20, &y, STRING_MIDI_PORT);
			guiSelectPen1Color(aContext, 0);
			for(i=0;i<27;i++) {
				if (i==theVirtualMidiKeyboardPort) {
					guiDrawText(aContext, x+30+(i%9)*25, y+(i/9)*14, midiSelectedPortNames+i*5, 5);
				} else {
					guiDrawText(aContext, x+30+(i%9)*25, y+(i/9)*14, midiUnSelectedPortNames+i*5, 5);
				}
				configWindowAddHitArea(aContext, x+30+(i%9)*25, y+(i/9)*14, x+30+25+(i%9)*25);
			}
			y+=42;
			configWindowHeader2(aContext, x+20, &y, STRING_MIDI_CHANNEL);
			guiSelectPen1Color(aContext, 0);
			for(i=0;i<17;i++) {
				if (i==theVirtualMidiKeyboardChannel) {
					guiDrawText(aContext, x+30+(i%9)*25, y+(i/9)*14, midiSelectedChannelOffNames+i*5, 5);
				} else {
					guiDrawText(aContext, x+30+(i%9)*25, y+(i/9)*14, midiUnSelectedChannelOffNames+i*5, 5);
				}
				configWindowAddHitArea(aContext, x+30+(i%9)*25, y+(i/9)*14, x+30+25+(i%9)*25);
			}
			y+=28;

	// Midi input devices
			if (midiInDeviceNames) {
				configWindowHeader(aContext, x+12, &y, STRING_MIDI_IN_DEVICES);
				for(i=0;midiInDeviceNames[i];i++) {
					int j;
					configWindowHeaderStr(aContext, x+20, &y, midiInDeviceNames[i]);
					guiSelectPen1Color(aContext, 0);
					for(j=0;j<27;j++) {
						if (j==midiInPorts[i]) {
							guiDrawText(aContext, x+30+(j%9)*25, y+(j/9)*14, midiSelectedPortNames+j*5, 5);
						} else {
							guiDrawText(aContext, x+30+(j%9)*25, y+(j/9)*14, midiUnSelectedPortNames+j*5, 5);
						}
						configWindowAddHitArea(aContext, x+30+(j%9)*25, y+(j/9)*14, x+30+25+(j%9)*25);
					}
					y+=42;
				}
			}
			if (midiOutDeviceNames) {
				configWindowHeader(aContext, x+12, &y, STRING_MIDI_OUT_DEVICES);
				for(i=0;midiOutDeviceNames[i];i++) {
					int j;
					configWindowHeaderStr(aContext, x+20, &y, midiOutDeviceNames[i]);
					guiSelectPen1Color(aContext, 0);
					for(j=0;j<27;j++) {
						if (j==midiOutPorts[i]) {
							guiDrawText(aContext, x+30+(j%9)*25, y+(j/9)*14, midiSelectedPortNames+j*5, 5);
						} else {
							guiDrawText(aContext, x+30+(j%9)*25, y+(j/9)*14, midiUnSelectedPortNames+j*5, 5);
						}
						configWindowAddHitArea(aContext, x+30+(j%9)*25, y+(j/9)*14, x+30+25+(j%9)*25);
					}
					y+=42;
				}
			}

			if (/*y+guiGetVScrollPos(aContext->currentWindow)!=maxy ||*/ (aContext->guiClientRect.right-aContext->guiClientRect.left)!=maxxsize) {
	//          maxx=250;
				maxxsize=aContext->guiClientRect.right-aContext->guiClientRect.left;
				guiHScrollRange(aContext->currentWindow, 0, 250/*maxy*/, maxxsize);
			}
			if (y+guiGetVScrollPos(aContext->currentWindow)!=maxy || aContext->guiClientRect.bottom!=maxysize) {
				maxy=y+guiGetVScrollPos(aContext->currentWindow);
				maxysize=aContext->guiClientRect.bottom;
				guiVScrollRange(aContext->currentWindow, 0, maxy, maxysize);
			}
		} break;
		case GUIEVENT_MOUSEBUTTON1DOWN: {
			int myId=0;
			int i,j;

			for(i=0;languageCodes[i];i++) {
				myId++;
				if (myId==aContext->id) {
					setLanguageIndex(i);
				}
			}
			for(i=0;cableTypeList[i]!=STRING_;i++) {
				myId++;
				if (myId==aContext->id) {
					setTheCurrentCableType(i);
				}
			}
			~cc~globalConfigButton1~
			for(i=0;audioInDeviceNames[i];i++) {
				myId++;
				if (myId==aContext->id) {
					setAudioInDevice(i);
				}
			}
			for(i=0;audioBufferLengthTable[i];i++) {
				myId++;
				if (myId==aContext->id) {
					setAudioInBufferSize(audioBufferLengthTable[i]);
				}
			}
			for(i=0;audioOutDeviceNames[i];i++) {
				myId++;
				if (myId==aContext->id) {
					setAudioOutDevice(i);
				}
			}
			if (currentAudioOutDevice>1) {
				for(i=2;i<9;i++) {
					myId++;
					if (myId==aContext->id) {
						DSP_NewNoofBuffers=i;
						configPanelWindowRefresh=true;
					}
				}
			}
			for(i=0;audioBufferLengthTable[i];i++) {
				myId++;
				if (myId==aContext->id) {
					setAudioOutBufferSize(audioBufferLengthTable[i]);
				}
			}
			for(i=0;i<4;i++) {
				myId++;
				if (myId==aContext->id) {
					setTheJoystickMode(i);
				}
			}
			for(i=0;i<27;i++) {
				myId++;
				if (myId==aContext->id) {
					setTheVirtualMidiKeyboardPort(i);
				}
			}
			for(i=0;i<17;i++) {
				myId++;
				if (myId==aContext->id) {
					setTheVirtualMidiKeyboardChannel(i);
				}
			}
			for(i=0;midiInDeviceNames[i];i++) {
				for(j=0;j<27;j++) {
					myId++;
					if (myId==aContext->id) {
						setMidiInPort(i, j);
					}
				}
			}
			for(i=0;midiOutDeviceNames[i];i++) {
				for(j=0;j<27;j++) {
					myId++;
					if (myId==aContext->id) {
						setMidiOutPort(i, j);
					}
				}
			}
		} break;
		case GUIEVENT_KEYDOWN: {
			switch(aContext->id) {
				case VK_ESCAPE:
					guiHideWindow(aContext->currentWindow);
					break;
				default:
					break;
			}
		} break;
		case GUIEVENT_CLOSE: {
			guiHideWindow(aContext->currentWindow);
		} break;
		default: {
		} break;
	}
}
EOF

genWindow('configPanelWindow', 'CONFIGWINDOW', '"Configuration and Settings"', 'configWindowHandler', undef, undef, 1, 1, undef);


