##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Color selector window
#
##########################################################################

ccModule('Color selector window');

cc('showColorSelector', 'guiShowWindow(colorSelectorWindow);');
cc('theCurrentCableColorIndex', 'colorSelectorWindowRefresh=true;');

my $noofCableColors=8;

rd("static const int noofCableColors=$noofCableColors;");
rv('int theCurrentCableColorIndex=0;');
#  $rv .= "static int cablePenColors[noofCableColors] ={0000,0004,0040,0400,0044,0404,0440,0444};\n";
#  $rv .= "static int cableFillColors[noofCableColors]={0333,0007,0070,0700,0077,0707,0770,0xFFFFFF};\n";
rv('int cablePenColors[noofCableColors] ={0x000000,0x000088,0x008800,0x880000,0x008888,0x880088,0x888800,0x888888};');
rv('int cableFillColors[noofCableColors]={0x666666,0x0000BB,0x00BB00,0xBB0000,0x00BBBB,0xBB00BB,0xBBBB00,0xFFFFFF};');
rc(<<EOF);
static void setCurrentCableColor(int index) {
	theCurrentCableColorIndex=index;
	~cc~theCurrentCableColorIndex~
}

static void cableColorHandler(ContextPtr aContext) {
	switch (aContext->guiEvent) {
	case GUIEVENT_REFRESH: {
		guiClearAreaList(aContext);
		guiSelectFillColor(aContext, -1);
		guiDraw3dFill(
			aContext,
			aContext->guiClientRect.left,
			aContext->guiClientRect.top,
			aContext->guiClientRect.right,
			aContext->guiClientRect.bottom);

		guiSelectFillColor(aContext, -1);
		for(int i=0; i<noofCableColors; i++) {
			int top = ((i*2)/noofCableColors)*32+2;
			int bottom = ((i*2)/noofCableColors)*32+30;
			int left = (i&(noofCableColors/2-1))*32+34;
			int right = (i&(noofCableColors/2-1))*32+62;

			guiSelectFillColor(aContext, -1);
			guiDraw3dRect(aContext, left, top, right, bottom, (i==theCurrentCableColorIndex));
			guiSelectPen3Color(aContext, cablePenColors[i]);
			guiSelectFillColor(aContext, cableFillColors[i]);
			guiDrawEllipse(aContext, ((i==theCurrentCableColorIndex)?1:0)+left+6, ((i==theCurrentCableColorIndex)?1:0)+top+6, ((i==theCurrentCableColorIndex)?1:0)+left+21, ((i==theCurrentCableColorIndex)?1:0)+top+21);
			guiAddArea(aContext, left, top, right, bottom);
		}
      
		int offs=(showResizeMarkers)?1:0;
		guiSelectFillColor(aContext, -1);
		guiDraw3dRect(aContext, 2, 2, 30, 30, showResizeMarkers);
		guiSelectPen1Color(aContext, 0x000000);
		guiSelectFillColor(aContext, -1);
		guiDrawRect(aContext, 10+offs, 10+offs, 20+offs, 20+offs);
		guiSelectPen1Color(aContext, 0x000000);
		guiSelectFillColor(aContext, 0xFFFFFF);
		guiDrawRect(aContext,  6+offs,  6+offs, 10+offs, 10+offs);
		guiDrawRect(aContext,  6+offs, 20+offs, 10+offs, 24+offs);
		guiDrawRect(aContext, 20+offs,  6+offs, 24+offs, 10+offs);
		guiDrawRect(aContext, 20+offs, 20+offs, 24+offs, 24+offs);
		guiAddArea(aContext, 2, 2, 30, 30);
		} break;
	case GUIEVENT_MOUSEBUTTON1DOWN:
		if (aContext->id>0 && aContext->id<=noofCableColors) {
			setCurrentCableColor(aContext->id-1);
		}
		if (aContext->id>noofCableColors) {
			showResizeMarkers=!showResizeMarkers;
			colorSelectorWindowRefresh=true;
			mainWindowRefresh=true;
		}
		break;
	case GUIEVENT_KEYDOWN:
		switch(aContext->id) {
		case VK_ESCAPE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		}
		break;
	case GUIEVENT_CLOSE:
		guiHideWindow(aContext->currentWindow);
		break;
	default:
		break;
	}
}
EOF

genWindow('colorSelectorWindow', 'COLORSELECTORWINDOW', '"Color Selector"', 'cableColorHandler', ($noofCableColors+2)*16, 64, 0, 0, 1);
cc('mainInit', "setCurrentCableColor(0);\n");
