##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Lowlevel audio routines for Microsoft Windows.
#
##########################################################################

ccModule('Lowlevel audio routines for Win32');
	
rv('const char **audioInDeviceNames;');
rv('int currentAudioInDevice;');
rv('const char **audioOutDeviceNames;');
rv('int currentAudioOutDevice;');

mutex('theAudioMutex');

rv(<<EOF);
int audioBufferLengthTable[]={
	 256,  512,  768,
	1024, 1280, 1536, 1792,
	2048, 2304, 2560, 2816,
	3072, 3328, 3584, 3840,
	4096, 4608, 5120, 5632,
	6144, 6656, 7168, 8192,
//   9216,10240,11264,12288,13312,14336,15360,16384,
	   0
};
EOF

rc(<<EOF);
static void updatePlayModeMenu(void) {
	markMenuItem(mainMenu, MENU_STOP, PLAYMODE_PLAY != thePlayMode);
	markMenuItem(synFactoryMenu, MENU_STOP, PLAYMODE_PLAY != thePlayMode);
	markMenuItem(mainMenu, MENU_PLAY, PLAYMODE_PLAY == thePlayMode);
	markMenuItem(synFactoryMenu, MENU_PLAY, PLAYMODE_PLAY == thePlayMode);
}

static void setPlayMode(PlayMode newPlayMode) {
	logprintf("setPlayMode %d (current is %d)\\n", (int)newPlayMode, (int)thePlayMode);
	if ((thePlayMode!=newPlayMode || thePlayingProject!=theCurrentProject) && theCurrentProject<maxProjects) {
		lockMutex(theAudioMutex);
		lockMutex(midiMutex);
		switch(newPlayMode) {
		case PLAYMODE_PLAY:
			thePlayingProject=theCurrentProject;
			~cc~recalcDsp~
			break;
		default:
			thePlayingProject=-1;
			break;
		}
		thePlayMode=newPlayMode;
		unlockMutex(midiMutex);
		unlockMutex(theAudioMutex);
		updatePlayModeMenu();
		~cc~thePlayMode~
	}
}

static void setRecordMode(RecordMode newRecordMode) {
	if (newRecordMode != theRecordMode) {
		switch(newRecordMode) {
		case RECORDMODE_STOP:
			if (captureSample.file) {
				closeSampleFile(&captureSample);
			}
			theRecordMode=RECORDMODE_STOP;
			markMenuItem(mainMenu, MENU_RECORD, false);
			markMenuItem(synFactoryMenu, MENU_RECORD, false);
			break;
		case RECORDMODE_RECORD:
			if (captureFileSelect()) {
				captureBufWritePos=0;
				captureBufReadPos=0;
				theRecordMode=RECORDMODE_RECORD;
				markMenuItem(mainMenu, MENU_RECORD, true);
				markMenuItem(synFactoryMenu, MENU_RECORD, true);
			}
			break;
		default:
			break;
		}
		~cc~theRecordMode~
	}
}
EOF

rd(<<EOF);
typedef enum _audioBlockUse {
	AUDIOBLOCK_UNAVAILABLE,
	AUDIOBLOCK_UNUSED,
	AUDIOBLOCK_CARDINPUT,
	AUDIOBLOCK_CARDOUTPUT,
	AUDIOBLOCK_ZEROS,
	AUDIOBLOCK_INPUTRING,
	AUDIOBLOCK_CAPTURE,
} audioBlockUse;
EOF


rv('const int waveBlockSize=8192;');
rv('const int noofWaveBlocks=32;');
rv('LPSTR         DSP_DriverBlock[noofWaveBlocks];');
rv('audioBlockUse DSP_BlockUse[noofWaveBlocks];');
rv('int           DSP_BlockSize[noofWaveBlocks];');

rv('volatile bool audioInReady=false;');
rv('volatile bool audioOutReady=false;');
rv('Sample captureSample;');

#
# Audio input ringbuffer
#
rv('const int audioInputRingSize=(noofWaveBlocks);');
rv('int audioInputRing[audioInputRingSize];');
rv('int audioInputRingWritePos;');
rv('int audioInputRingReadPos;');
rv('int audioInputBufferPos;');
rv('int captureBufWritePos;');
rv('int captureBufReadPos;');
rv('int audioInputBufferSubPos;');

rv('int nextAudioOutBufferSize=waveBlockSize;');
rv('int currentAudioOutBufferSize=waveBlockSize;');
rv('int nextAudioInBufferSize=waveBlockSize;');
rv('int currentAudioInBufferSize=waveBlockSize;');

rc(<<EOF);
#define WM_DSPRESTART    WM_USER+4

//
// Audio output definition
//
#define PLAYBACKTHREAD_WIN32 1
#define PLAYBACKRATE 44100



static int           DSP_NewNoofBuffers = 5;
static int           DSP_CurNoofBuffers = DSP_NewNoofBuffers;
static volatile int  DSP_NrActive=0;  /* number of active blocks currently in playback queue */
static int           noofInputBuffersOnCard=0;

static HANDLE        audioInThreadHandle;
static HANDLE        audioOutThreadHandle;
static DWORD         audioInThreadID;
static DWORD         audioOutThreadID;
static HWAVEIN       waveInHandle;
static HWAVEOUT      waveOutHandle;
static WAVEHDR       DSP_DriverBlockHDR[noofWaveBlocks];

// DSound.DLL function pointers
#include "sf_dsound.h"
static HINSTANCE         dsoundDLL=NULL;
static bool              dsound_ready=false;
static getVersionFunc    dsound_getVersion;
static initDLLFunc       dsound_initDLL;
static setBufferSizeFunc dsound_setBufferSize;
static audioLoopFunc     dsound_audioLoop;
static openDSoundFunc    dsound_open;
static closeDSoundFunc   dsound_close;

//
// Audio capture of output
//
static const int caputureBufferSize=(noofWaveBlocks+2);
static int captureBufNrBuffer[caputureBufferSize]; /* This buffer keeps the audio buffers in correct order. */

static void resetPlayback(void) {
	lockMutex(theAudioMutex);
	if (0 <= thePlayingProject) {
		dspResetAll(&(projects[thePlayingProject].dsp[1]));
	} else if (0 <= theCurrentProject) {
		dspResetAll(&(projects[theCurrentProject].dsp[1]));
	}
	unlockMutex(theAudioMutex);
}

//
// Update capture file buffer
//
static void BufferToCaptureFile(int bufnr) {
	if (theRecordMode==RECORDMODE_RECORD && (DSP_BlockUse[bufnr]==AUDIOBLOCK_CARDOUTPUT)) {
		DSP_BlockUse[bufnr]=AUDIOBLOCK_CAPTURE;
		captureBufNrBuffer[captureBufWritePos++]=bufnr;
		if (captureBufWritePos>=caputureBufferSize) {
			// Wrap around at end of buffer
			captureBufWritePos=0;    
		}
	} else {
		DSP_BlockUse[bufnr]=AUDIOBLOCK_UNUSED;
	}
}



//
// Calculate and process single block of audio
// returns true if block has audio or false if block only contains zeros (playback stopped or paused)
// This flag is used to decide which blocks need to be written to disk during capturing mode.
//
static inline bool calculateBlock(signed short *MemoryBlock, signed short *EndMemoryBlock) {
	// If this flag is set, we have generated audio, this information is used when
	// allocating audio blocks
	bool hasaudio=false;

	switch(thePlayMode) {
	case PLAYMODE_PLAY:
//    case CAPTURE_RECORD:
		// !!! hack
		if (theDcFilterEnabled) {
			dspCalculateBlockDcFilter(&(projects[thePlayingProject].dsp[1]), MemoryBlock, EndMemoryBlock);
		} else {
			dspCalculateBlock(&(projects[thePlayingProject].dsp[1]), MemoryBlock, EndMemoryBlock);
		}
		hasaudio=true;
		break;
	default:
		dspCalculateZeroBlock(MemoryBlock, EndMemoryBlock);
		updateVuMeter(0, 0);
		break;
	}
	return hasaudio;
}


static void WINAPI dsoundCalc(signed short *MemoryBlock, signed short *EndMemoryBlock) {
	lockMutex(theAudioMutex);
	switch(thePlayMode) {
	case PLAYMODE_PLAY:
		if (theRecordMode == RECORDMODE_RECORD) {
			// find suitable block
			for (int i=0; i<noofWaveBlocks; i++) {
				if (DSP_BlockUse[i] == AUDIOBLOCK_UNUSED) {
					// !!! hack
					if (theDcFilterEnabled) {
						dspCalculateBlockDcFilter(&(projects[thePlayingProject].dsp[1]), (signed short *)DSP_DriverBlock[i], ((signed short *)DSP_DriverBlock[i])+(EndMemoryBlock-MemoryBlock));
					} else {
						dspCalculateBlock(&(projects[thePlayingProject].dsp[1]), (signed short *)DSP_DriverBlock[i], ((signed short *)DSP_DriverBlock[i])+(EndMemoryBlock-MemoryBlock));
					}
//          dspCalculateZeroBlock(&OBJs[1], (signed short *)DSP_DriverBlock[i], ((signed short *)DSP_DriverBlock[i])+(EndMemoryBlock-MemoryBlock));
					DSP_BlockUse[i]=AUDIOBLOCK_CARDOUTPUT;
					DSP_BlockSize[i]=EndMemoryBlock-MemoryBlock;
					memcpy(MemoryBlock, DSP_DriverBlock[i], (EndMemoryBlock-MemoryBlock)*sizeof(signed short));
					BufferToCaptureFile(i);
					break;
				}      
			}
		} else {
			if (theDcFilterEnabled) {
				dspCalculateBlockDcFilter(&(projects[thePlayingProject].dsp[1]), MemoryBlock, EndMemoryBlock);
			} else {
				dspCalculateBlock(&(projects[thePlayingProject].dsp[1]), MemoryBlock, EndMemoryBlock);
			}
		}
//      hasaudio=true;
//      allclear=false;
		break;
	default:
		dspCalculateZeroBlock(MemoryBlock, EndMemoryBlock);
		updateVuMeter(0, 0);
		break;
	}
	unlockMutex(theAudioMutex);
}

//
// Send block to audio device.
//
static inline void DSP_SendBlock(int blocknr) {
	if (DSP_DriverBlock[blocknr]!=NULL) {
		bool hasaudio;
		currentAudioOutBufferSize = nextAudioOutBufferSize;
		hasaudio=calculateBlock((signed short *)DSP_DriverBlock[blocknr], ((signed short *)DSP_DriverBlock[blocknr])+currentAudioOutBufferSize);
		DSP_BlockUse[blocknr]=(hasaudio)?AUDIOBLOCK_CARDOUTPUT:AUDIOBLOCK_ZEROS;
		DSP_BlockSize[blocknr]=currentAudioOutBufferSize;

		DSP_DriverBlockHDR[blocknr].lpData = DSP_DriverBlock[blocknr];
		DSP_DriverBlockHDR[blocknr].dwBufferLength = currentAudioOutBufferSize*sizeof(signed short);
		DSP_DriverBlockHDR[blocknr].dwFlags = 0;
		DSP_DriverBlockHDR[blocknr].dwUser=blocknr;
		waveOutPrepareHeader(waveOutHandle, &DSP_DriverBlockHDR[blocknr], sizeof(WAVEHDR));
		waveOutWrite(waveOutHandle, &DSP_DriverBlockHDR[blocknr], sizeof(WAVEHDR));

#ifdef PLAYBACKTHREAD_ARTS
		arts_write(artsStream, DSP_DriverBlock[blocknr], currentAudioOutBufferSize*sizeof(signed short));
#endif
	}
}


//
// Flush cached audio data to disk.
//
void flushCaptureFile(void) {
	bool needrestart=false;

	while (captureBufReadPos!=captureBufWritePos) {
		int bufnr=captureBufNrBuffer[captureBufReadPos++];

		writeSampleData(&captureSample, (signed short *)(DSP_DriverBlock[bufnr]), DSP_BlockSize[bufnr]);
		DSP_BlockUse[bufnr]=AUDIOBLOCK_UNUSED;
		needrestart=true;

		if (captureBufReadPos>=caputureBufferSize) {
			captureBufReadPos=0;
		}
	}
	if (needrestart) {
		PostThreadMessage(audioOutThreadID, WM_DSPRESTART, 0, 0);
	}
}


static void setAudioOutBufferSize(int aBufferSize) {
	if (aBufferSize>0 && aBufferSize<=waveBlockSize) {
		nextAudioOutBufferSize=aBufferSize;
		if (dsound_setBufferSize) {
			dsound_setBufferSize(aBufferSize);
		}
		configPanelWindowRefresh=true;
	}
}


static void setAudioInBufferSize(int aBufferSize) {
	if (aBufferSize>0 && aBufferSize<=waveBlockSize) {
		nextAudioInBufferSize=aBufferSize;
		configPanelWindowRefresh=true;
	}
}


//
// Fill PCMformat struct with one of two configurations depending on
// MONOSYNTH define.
//
static void FillPCMformatStruct(WAVEFORMATEX *myPCMformat) {
#ifdef MONOSYNTH
	myPCMformat->wFormatTag=WAVE_FORMAT_PCM;
	myPCMformat->nChannels=1;          // Mono (single channel)
	myPCMformat->nSamplesPerSec=PLAYBACKRATE;
	myPCMformat->nAvgBytesPerSec=PLAYBACKRATE*2;
	myPCMformat->nBlockAlign=2;
	myPCMformat->wBitsPerSample=16;    // 16 bits audio
	myPCMformat->cbSize=0;             // No extra info
#else
	myPCMformat->wFormatTag=WAVE_FORMAT_PCM;
	myPCMformat->nChannels=2;          // Stereo (dual channel)
	myPCMformat->nSamplesPerSec=PLAYBACKRATE;
	myPCMformat->nAvgBytesPerSec=PLAYBACKRATE*4;
	myPCMformat->nBlockAlign=4;
	myPCMformat->wBitsPerSample=16;    // 16 bits audio
	myPCMformat->cbSize=0;             // No extra info
#endif
}

static void setAudioInDevice(int audioInDevice) {
	if (audioInReady) {
		audioInReady=false;
		if (currentAudioInDevice>0) {
			while(noofInputBuffersOnCard>0) {
				Sleep(100);
			}
			waveInReset(waveInHandle);
			waveInClose(waveInHandle);
		}
	}

	logprintf("AudioInDevice set to %d ", audioInDevice);
	currentAudioInDevice=audioInDevice;

	if (currentAudioInDevice==0) {
		logprintf("(Disabled).\\n");
	}

	if (audioInDevice>0) {
		WAVEFORMATEX myPCMformat;
		WAVEINCAPS caps;
		MMRESULT error;
		FillPCMformatStruct(&myPCMformat);

		logprintf("(MME).\\n");

		waveInGetDevCaps(audioInDevice-1, &caps, sizeof(caps));
		logprintf("caps: 0x%x\\n", caps.dwFormats);
		error=waveInOpen(&waveInHandle, audioInDevice-1, &myPCMformat,(unsigned long)audioInThreadID, 0, CALLBACK_THREAD);
		if (error != MMSYSERR_NOERROR) {
			char tmp[MAXERRORLENGTH ];
			logprintf("ERROR waveInOpen failed, check WAVE-Input settings!\\n");
			waveInGetErrorText(error, tmp, MAXERRORLENGTH);
			logprintf("Error %d '%s'\\n", error, tmp);
			MessageBox(mainWindow, "waveInOpen failed, check WAVE-Input settings", NULL,MB_OK | MB_ICONEXCLAMATION);
		} else {
			logprintf("waveInOpen ok. Sending start message to audio thread.\\n");
			audioInReady=true;
			waveInStart(waveInHandle);
			while (PostThreadMessage(audioInThreadID, WM_DSPRESTART, 0, 0)==0) {
				logprintf("Post startmessage failed, repeating.\\n");
				Sleep(500);
			}
		}
	}
	configPanelWindowRefresh=true;
}


//
// (Re)Open wave device
//
static void setAudioOutDevice(int audioOutDevice) {
	if (audioOutReady) {
		if (currentAudioOutDevice==1) {
			audioOutReady=false;
			dsound_close();
		}
		if (currentAudioOutDevice>1) {
			audioOutReady=false;
			while (DSP_NrActive>0) {
				Sleep(100);
			}
			waveOutClose(waveOutHandle);
		}
	}

	logprintf("AudioOutDevice set to %d ", audioOutDevice);
	currentAudioOutDevice=audioOutDevice;

	if (currentAudioOutDevice==0) {
		logprintf("(Disabled).\\n");
	}

	// Use sf_dsound.dll
	if (currentAudioOutDevice==1) {
		logprintf("(DirectSound).\\n");
		
		if (NULL==dsoundDLL) {
			logprintf("Loading 'sf_dsound.dll'.\\n");
			dsoundDLL=LoadLibrary("sf_dsound.dll");
			if (dsoundDLL) {
				dsound_getVersion=(getVersionFunc)GetProcAddress(dsoundDLL, "getVersion");
				dsound_initDLL=(initDLLFunc)GetProcAddress(dsoundDLL, "initDLL");
				dsound_setBufferSize=(setBufferSizeFunc)GetProcAddress(dsoundDLL, "setBufferSize");
				dsound_audioLoop=(audioLoopFunc)GetProcAddress(dsoundDLL, "audioLoop");
				dsound_open=(openDSoundFunc)GetProcAddress(dsoundDLL, "openDSound");
				dsound_close=(closeDSoundFunc)GetProcAddress(dsoundDLL, "closeDSound");
				if (dsound_getVersion &&
						dsound_initDLL &&
						dsound_setBufferSize &&
						dsound_open &&
						dsound_close) {
					logprintf("Direct sound driver loaded. DLL version '%s'.\\n", dsound_getVersion());
					if (strcmp("SF_DSOUND.DLL V1.16", dsound_getVersion())==0 ||
							strcmp("SF_DSOUND.DLL V2.00", dsound_getVersion())==0) {
						dsound_ready=true;
					} else {
						logprintf("Failed to initialise 'sf_dsound.dll', because it has the wrong version information.\\n");
					}
				}
			} else {
				logprintf("Failed to load 'sf_dsound.dll', check StudioFactory installation.\\n");
			}
		}
		if (dsound_ready) {
			(*dsound_initDLL)(mainWindow, logprintf, dsoundCalc);
			(*dsound_setBufferSize)(nextAudioOutBufferSize);
			(*dsound_open)();

			audioOutReady=true;
			PostThreadMessage(audioOutThreadID, WM_DSPRESTART, 0, 0);
		}
	}

	// Use MME drivers
	if (currentAudioOutDevice>1) {
		WAVEFORMATEX myPCMformat;
		FillPCMformatStruct(&myPCMformat);

		logprintf("(MME).\\n");

		if (waveOutOpen(&waveOutHandle, (currentAudioOutDevice==2)?WAVE_MAPPER:(currentAudioOutDevice-3), (LPWAVEFORMATEX)&myPCMformat,(unsigned long)audioOutThreadID,0,CALLBACK_THREAD) != MMSYSERR_NOERROR) {
			logprintf("ERROR waveOutOpen failed, check WAVE-Output settings!\\n");
			MessageBox(mainWindow, "waveOutOpen failed, check WAVE-Output settings",NULL,MB_OK | MB_ICONEXCLAMATION);
		} else {
			logprintf("waveOutOpen ok. Sending start message to audio thread.\\n");
			audioOutReady=true;
			// Mmm waveOutOpen should result in a MM_WOM_OPEN but never got it.
			// Following postmessage kicks it on anyway.
			while (PostThreadMessage(audioOutThreadID, WM_DSPRESTART, 0, 0)==0) {
				logprintf("Post startmessage failed, repeating.\\n");
				Sleep(500);
			}
		}
	}
	configPanelWindowRefresh=true;
}


static DWORD audioInThread(LPDWORD lpdwParam) {
	MSG msg;
	int i;
	int inUse;

	// Run in loop processing wave data
	logprintf("Audio input thread %d started\\n", audioInThreadID);

	for(;;) {
		int getMessageResult=GetMessage(&msg, NULL, 0, 0);

		if (msg.message==MM_WIM_DATA) {
			int noofBuffers=audioInputRingWritePos-audioInputRingReadPos;
			if (noofBuffers<0) noofBuffers+=audioInputRingSize;

			waveInUnprepareHeader(waveInHandle, ((WAVEHDR *)msg.lParam), sizeof(WAVEHDR));
			if (noofBuffers>6) {
				DSP_BlockUse[((WAVEHDR *)msg.lParam)->dwUser]=AUDIOBLOCK_UNUSED;
			} else {
				DSP_BlockUse[((WAVEHDR *)msg.lParam)->dwUser]=AUDIOBLOCK_INPUTRING;
				audioInputRing[audioInputRingWritePos++]=((WAVEHDR *)msg.lParam)->dwUser;
				if (audioInputRingWritePos>=audioInputRingSize) audioInputRingWritePos=0;
			}
			noofInputBuffersOnCard--;
		}

		lockMutex(theAudioMutex);
		inUse=0;
		currentAudioOutBufferSize=nextAudioOutBufferSize;
		for (i=0;i<noofWaveBlocks && noofInputBuffersOnCard<8 && audioInReady;i++) {
			if (DSP_BlockUse[i]==AUDIOBLOCK_UNUSED) {
				DSP_BlockUse[i]=AUDIOBLOCK_CARDINPUT;
				DSP_BlockSize[i]=currentAudioOutBufferSize;
				DSP_DriverBlockHDR[i].lpData = DSP_DriverBlock[i];
				DSP_DriverBlockHDR[i].dwBufferLength = DSP_BlockSize[i]*sizeof(signed short);
				DSP_DriverBlockHDR[i].dwFlags = 0;
				DSP_DriverBlockHDR[i].dwUser=i;
				waveInPrepareHeader(waveInHandle, &DSP_DriverBlockHDR[i], sizeof(WAVEHDR));
				waveInAddBuffer(waveInHandle, &DSP_DriverBlockHDR[i], sizeof(WAVEHDR));
				noofInputBuffersOnCard++;
			}
		}
		unlockMutex(theAudioMutex);
	}
	return 0;
}

static DWORD audioOutThread(LPDWORD lpdwParam) {
	MSG msg;
	int cnt;

	// Run in loop processing wave data
	logprintf("Audio output thread %d started\\n", audioOutThreadID);
	for(;;) {
		int getMessageResult=GetMessage(&msg, NULL, 0, 0);
		
		if (getMessageResult==0 || getMessageResult==-1) {
			logprintf("Audio thread terminated %d\\n", getMessageResult);
		}

		if (msg.message==MM_WOM_DONE) {
			waveOutUnprepareHeader(waveOutHandle, ((WAVEHDR *)msg.lParam), sizeof(WAVEHDR));
			BufferToCaptureFile(((WAVEHDR *)msg.lParam)->dwUser);
			DSP_NrActive--;
//      logprintf("NrActive %d\\n", DSP_NrActive);
		}

		if (currentAudioOutDevice==1 && audioOutReady) {
			// Use sf_dsound.dll loop
			(*dsound_audioLoop)();
		}

		// find unused block(s) to send
		if (currentAudioOutDevice>1 && audioOutReady) {
			DSP_CurNoofBuffers=DSP_NewNoofBuffers;
			lockMutex(theAudioMutex);
			for (cnt=0; cnt<noofWaveBlocks && DSP_NrActive<DSP_CurNoofBuffers; cnt++) {
				if (DSP_BlockUse[cnt]==AUDIOBLOCK_UNUSED) {
//          logprintf("SendBlock %d\\n", cnt);
					DSP_SendBlock(cnt);
					DSP_NrActive++;
//          logprintf("NrActive %d\\n", DSP_NrActive);
				}      
			}
			unlockMutex(theAudioMutex);
		}
	}
	return 0;
} 

static int noofAudioInDevices;
static int noofAudioOutDevices;
static void openAudioDriver(void) {
	WAVEINCAPS audioInInfo;
	WAVEOUTCAPS audioOutInfo;
	int i;

#ifdef _beginthreadex
	audioInThreadHandle = _beginthreadex(NULL, 0, (LPTHREAD_START_ROUTINE)audioInThread, NULL, CREATE_SUSPENDED, &audioInThreadID);
	audioOutThreadHandle = _beginthreadex(NULL, 0, (LPTHREAD_START_ROUTINE)audioOutThread, NULL, CREATE_SUSPENDED, &audioOutThreadID);
#else
	DWORD dwThrdParam = 1;
	audioInThreadHandle = CreateThread( 
		NULL,                        // no security attributes 
		0,                           // use default stack size  
		(LPTHREAD_START_ROUTINE)audioInThread, // thread function 
		&dwThrdParam,                // argument to thread function 
		CREATE_SUSPENDED,            // use default creation flags 
		&audioInThreadID);             // returns the thread identifier
	audioOutThreadHandle = CreateThread( 
		NULL,                        // no security attributes 
		0,                           // use default stack size  
		(LPTHREAD_START_ROUTINE)audioOutThread, // thread function 
		&dwThrdParam,                // argument to thread function 
		CREATE_SUSPENDED,            // use default creation flags 
		&audioOutThreadID);             // returns the thread identifier
#endif
//  SetPriorityClass(GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
	SetThreadPriority(audioInThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
	SetThreadPriority(audioOutThreadHandle, THREAD_PRIORITY_TIME_CRITICAL);
	ResumeThread(audioInThreadHandle);
	ResumeThread(audioOutThreadHandle);

#ifdef PLAYBACKTHREAD_ARTS
	arts_init();
	artsStream=arts_play_stream(44100, 16, 2, "artsc_test");
	pthread_create(&threadHandle, NULL, audioOutThread, NULL); 
#endif

	timeBeginPeriod(1); // Set timer resolution to 1 ms

	noofAudioInDevices=waveInGetNumDevs();
//  int noofAudioInDevices=0;
	audioInDeviceNames=(const char **)malloc((noofAudioInDevices+2)*sizeof(const char *));
	audioInDeviceNames[0]="(no audio input)";
	for(i=0;i<noofAudioInDevices;i++) {
		if (MMSYSERR_NOERROR==waveInGetDevCaps(i, &audioInInfo, (UINT)sizeof(WAVEINCAPS))) {
			audioInDeviceNames[i+1]=strdup(audioInInfo.szPname);
		} else {
			audioInDeviceNames[i+1]="(unknown)";
		}
	}
	audioInDeviceNames[noofAudioInDevices+1]=NULL;

	noofAudioOutDevices=waveOutGetNumDevs();
	audioOutDeviceNames=(const char **)malloc((noofAudioOutDevices+4)*sizeof(const char *));
	audioOutDeviceNames[0]="(no audio output)";
	audioOutDeviceNames[1]="DirectSound (sf_dsound.dll)";
	audioOutDeviceNames[2]="WaveMapper (default)";
	for(i=0;i<noofAudioOutDevices;i++) {
		if (MMSYSERR_NOERROR==waveOutGetDevCaps(i, &audioOutInfo, (UINT)sizeof(WAVEOUTCAPS))) {
			audioOutDeviceNames[i+3]=strdup(audioOutInfo.szPname);
		} else {
			audioOutDeviceNames[i+3]="(unknown)";
		}
	}
	audioOutDeviceNames[noofAudioOutDevices+3]=NULL;

}

static void closeAudioDriver(void) {
	int i;

	if (audioInDeviceNames) {
		for(i=0;i<noofAudioInDevices;i++) {
			if (audioInDeviceNames[i+1]) {
				free((void*)(audioInDeviceNames[i+1]));
			}
		}
		free(audioInDeviceNames);
		audioInDeviceNames=NULL;
	}
	if (audioOutDeviceNames) {
		for(i=0;i<noofAudioOutDevices;i++) {
			if (audioOutDeviceNames[i+3]) {
				free((void*)(audioOutDeviceNames[i+3]));
			}
		}
		free(audioOutDeviceNames);
		audioOutDeviceNames=NULL;
	}
}

//
//
//
static void allocateBuffers(void) {
	int i;

	for(i=0; i<noofWaveBlocks; i++) {
		if ((DSP_DriverBlock[i]=(LPSTR)GlobalAlloc(GMEM_FIXED | GMEM_SHARE, waveBlockSize*2))==NULL) {
			logprintf("Error allocating DSP MemoryBlock\\n");
//      MessageBox(hwnd, "Error allocating MemoryBlock", NULL, MB_OK | MB_ICONEXCLAMATION);
			DSP_BlockUse[i]=AUDIOBLOCK_UNAVAILABLE;
		} else {
			logprintf("Allocated dsp block %d\\n", i);
			DSP_BlockUse[i]=AUDIOBLOCK_UNUSED;
		}
	}
}


//
//
//
static void deallocateBuffers(void) {
	int i;

	for(i=0; i<noofWaveBlocks; i++) {
		if (DSP_DriverBlock[i]) {
			logprintf("Freeing dsp block %d\\n", i);
			GlobalFree(DSP_DriverBlock[i]);
			DSP_DriverBlock[i] = NULL;
			DSP_BlockUse[i]=AUDIOBLOCK_UNAVAILABLE;
		}
	}
}


EOF

cc('mainInit', 'allocateBuffers();');
cci('mainTerm', 'deallocateBuffers();');

cc('mainInit', 'updatePlayModeMenu();');
cc('mainInit', 'openAudioDriver();');
cci('mainTerm',, 'closeAudioDriver();');

cci('mainTerm', 'setAudioOutDevice(0);');
cci('mainTerm', 'setAudioInDevice(0);');

cci('mainTerm', 'setPlayMode(PLAYMODE_STOP);');
cci('mainTerm', 'setRecordMode(RECORDMODE_STOP);');

cc('stfSave', 'storeStfBegin(loadInfo, "AudioInputDevice"); storeStfInteger(loadInfo, 1); storeStfInteger(loadInfo, currentAudioInDevice); storeStfInteger(loadInfo, DSP_NewNoofBuffers); storeStfInteger(loadInfo, nextAudioInBufferSize); storeStfEnd(loadInfo);');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "AudioInputDevice")==0) { int i,d,n,b; readStfInteger(loadInfo, &i); if (i==1) { readStfInteger(loadInfo, &d); setAudioInDevice(d); readStfInteger(loadInfo, &n); readStfInteger(loadInfo, &b); setAudioInBufferSize(b); } }');
cc('stfSave', 'storeStfBegin(loadInfo, "AudioOutputDevice"); storeStfInteger(loadInfo, 1); storeStfInteger(loadInfo, currentAudioOutDevice); storeStfInteger(loadInfo, DSP_NewNoofBuffers); storeStfInteger(loadInfo, nextAudioOutBufferSize); storeStfEnd(loadInfo);');
cc('stfLoad', 'if (strcmp(loadInfo->headerTitle, "AudioOutputDevice")==0) { int i,d,n,b; readStfInteger(loadInfo, &i); if (i==1) { readStfInteger(loadInfo, &d); readStfInteger(loadInfo, &n); readStfInteger(loadInfo, &b); setAudioOutDevice(d); setAudioOutBufferSize(b); DSP_NewNoofBuffers=n; } }');
