##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Four channel scope
#
##########################################################################

rc(<<EOF);

static void fourChanScopeHandler(ContextPtr aContext) {
	_DspObject *object=(_DspObject*)aContext->userData;
	if (object) {
		switch (aContext->guiEvent) {
		case GUIEVENT_REFRESH: {
				int cnt;
				int xRange;
				int yRange;
				int value[4]={0,0,0,0};
				int low[4]={0,0,0,0};
				int high[4]={0,0,0,0};
				char tmpstr[64];

				guiSelectPen1Color(aContext, 0x000000);
				guiSelectFillColor(aContext, 0x000000);
				guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);
				xRange=((aContext->guiClientRect.right-16)/2);
				yRange=((aContext->guiClientRect.bottom-16)/4);

				// Draw base lines
				guiSelectPen1Color(aContext, 0x008888);
				guiDrawLine(aContext, 0, yRange, xRange, yRange);
				guiDrawLine(aContext, xRange+16, yRange, aContext->guiClientRect.right, yRange);
				guiDrawLine(aContext, 0, 3*yRange+16, xRange, 3*yRange+16);
				guiDrawLine(aContext, xRange+16, 3*yRange+16, aContext->guiClientRect.right, 3*yRange+16);

				if (object->io[0].intern==SCOPEBUFSIZE) {
					guiSelectPen1Color(aContext, 0x00FFFF);

					// Channel 1
					guiDrawLineFrom(aContext, 0, yRange-(object->buffer[0]*yRange)/32768);
					value[0]=object->buffer[0];
					low[0]=object->buffer[0];
					high[0]=object->buffer[0];
					for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
						value[0]+=object->buffer[cnt];
						if (object->buffer[cnt]<low[0])
							low[0]=object->buffer[cnt];
						if (object->buffer[cnt]>high[0])
							high[0]=object->buffer[cnt];
						guiDrawLineTo(aContext, (cnt*xRange)/SCOPEBUFSIZE, yRange-(object->buffer[cnt]*yRange)/32768);
					}

					// Channel 2
					guiDrawLineFrom(aContext, xRange+16, yRange-(object->buffer[1024]*yRange)/32768);
					value[1]=object->buffer[1024];
					low[1]=object->buffer[1024];
					high[1]=object->buffer[1024];
					for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
						value[1]+=object->buffer[1024+cnt];
						if (object->buffer[1024+cnt]<low[1])
							low[1]=object->buffer[1024+cnt];
						if (object->buffer[1024+cnt]>high[1])
							high[1]=object->buffer[1024+cnt];
						guiDrawLineTo(aContext, xRange+16+(cnt*xRange)/SCOPEBUFSIZE, yRange-(object->buffer[1024+cnt]*yRange)/32768);
					}

					// Channel 3
					guiDrawLineFrom(aContext, 0, 3*yRange+16-(object->buffer[2048]*yRange)/32768);
					value[2]=object->buffer[2048];
					low[2]=object->buffer[2048];
					high[2]=object->buffer[2048];
					for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
						value[2]+=object->buffer[2048+cnt];
						if (object->buffer[2048+cnt]<low[2])
							low[2]=object->buffer[2048+cnt];
						if (object->buffer[2048+cnt]>high[2])
							high[2]=object->buffer[2048+cnt];
						guiDrawLineTo(aContext, (cnt*xRange)/SCOPEBUFSIZE, 3*yRange+16-(object->buffer[2048+cnt]*yRange)/32768);
					}

					// Channel 4
					guiDrawLineFrom(aContext, xRange+16, 3*yRange+16-(object->buffer[3072]*yRange)/32768);
					value[3]=object->buffer[3072];
					low[3]=object->buffer[3072];
					high[3]=object->buffer[3072];
					for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
						value[3]+=object->buffer[3072+cnt];
						if (object->buffer[3072+cnt]<low[3])
							low[3]=object->buffer[3072+cnt];
						if (object->buffer[3072+cnt]>high[3])
							high[3]=object->buffer[3072+cnt];
						guiDrawLineTo(aContext, xRange+16+(cnt*xRange)/SCOPEBUFSIZE, 3*yRange+16-(object->buffer[3072+cnt]*yRange)/32768);
					}

					// Restart buffering of data
					object->io[0].intern = 0;
				}

				guiSelectTitleFont(aContext);
				guiDrawTransparent(aContext);
				guiSetTextAlignment(aContext, alignBottomLeft);
				guiSelectPen1Color(aContext, 0xFFFFFF);

				sprintf(tmpstr, "1: %d", value[0]/SCOPEBUFSIZE);
				guiDrawText(aContext, 0, yRange, tmpstr, strlen(tmpstr));
				sprintf(tmpstr, "L/H: %d %d", low[0], high[0]);
				guiDrawText(aContext, 0, yRange+16, tmpstr, strlen(tmpstr));

				sprintf(tmpstr, "2: %d", value[1]/SCOPEBUFSIZE);
				guiDrawText(aContext, xRange+16,   yRange, tmpstr, strlen(tmpstr));
				sprintf(tmpstr, "L/H: %d %d", low[1], high[1]);
				guiDrawText(aContext, xRange+16, yRange+16, tmpstr, strlen(tmpstr));

				sprintf(tmpstr, "3: %d", value[2]/SCOPEBUFSIZE);
				guiDrawText(aContext, 0, 3*yRange+16, tmpstr, strlen(tmpstr));
				sprintf(tmpstr, "L/H: %d %d", low[2], high[2]);
				guiDrawText(aContext, 0, 3*yRange+32, tmpstr, strlen(tmpstr));

				sprintf(tmpstr, "4: %d", value[3]/SCOPEBUFSIZE);
				guiDrawText(aContext, xRange+16, 3*yRange+16, tmpstr, strlen(tmpstr));
				sprintf(tmpstr, "L/H: %d %d", low[3], high[3]);
				guiDrawText(aContext, xRange+16, 3*yRange+32, tmpstr, strlen(tmpstr));
			} break;
		case GUIEVENT_TIMERTICK:
			if (object->io[0].intern==SCOPEBUFSIZE) {
				guiRefreshWindow(aContext->currentWindow);

			}
	//    if (DSP_ScopePosition==4*SCOPEBUFSIZE) {
	//      guiRefreshWindow(aContext->currentWindow, NULL);
	//    }
			break;
		case GUIEVENT_KEYDOWN:
			switch(aContext->id) {
			case VK_ESCAPE:
				guiHideWindow(aContext->currentWindow);
				break;
			default:
				break;
			}
			break;
		case GUIEVENT_CLOSE:
			guiHideWindow(aContext->currentWindow);
			break;
		default:
			break;
		}
	}
}



HWND createMultiScopeWindow(_DspObject *obj) {
	GuiWindowPtr newWindow=CreateWindowEx(
		WS_EX_TOOLWINDOW, mainWindowClass, "4 Channel Scope",
		WS_SYSMENU | WS_CLIPCHILDREN | WS_THICKFRAME | WS_OVERLAPPED,
		CW_USEDEFAULT, CW_USEDEFAULT, 512, 270,
		mainWindow, NULL, theInstance, NULL);
		SetWindowLong(newWindow, WNDEXTRA_EVENTFUNC, (LONG)fourChanScopeHandler);
		SetWindowLong(newWindow, WNDEXTRA_USERDATA, (LONG)obj);
	guiRunTimer(newWindow, 100);
	guiDoubleBuffer(newWindow, true);
	
	
/*  
	guiOpenToolWindow(
		aContext, aContext->mainWindow, "4 Channel Scope",
		512, 270,
		WF_DOUBLEBUFFER | WF_CLEARONRESIZE | WF_HIDDEN,
		eventHandler, (void*)obj);
*/

	return newWindow;
}


EOF

