##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2006  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# maker.pl
# Master buildscript
#
##########################################################################

use strict;
use warnings;

my $theProgramName = '';






my %cc=();               # Hash for string/code insertion.
my %ccSeparator=();      # Separator used for cc (gEnum)

sub cc {
	my $entry = shift;
	my $replace = shift;
	my $separator = shift;

	if (!(defined $separator) and (defined $ccSeparator{$entry})) {
		$separator = $ccSeparator{$entry};
	}
	if ((defined $cc{$entry}) and (defined $separator)) {
		$cc{$entry} .= $separator;
	}
	$cc{$entry} .= "\n" . ($replace);
}

sub cci {
	my $entry = shift;
	my $replace = shift;

	if (!defined($cc{$entry})) {
		$cc{$entry} = '';
	}
	$cc{$entry} = "\n" . ($replace) . $cc{$entry};
}

my $theTargetBaseName = '';
my @theTargetModules;
my @theTargetOptions = ('');
my $theTargetCppFilename;
my $theTargetFilename;
my $theTargetFile;

#
# Read a file from disk and return it as a string.
# input
#   filename - name of file to read
# output
#   returns string with file contents.
sub readCompleteFile {
	my $filename = shift;
	my $r;
	local $/;

	open(FILE, $filename) || die "can't open $filename";
	$r=<FILE>;
	close(FILE);
		
	return $r;
}

sub executeFile {
	my $myFilename = shift;
	my $code=readCompleteFile($myFilename);
	print "load  $myFilename\n";
	eval $code;
	if ($@) {
		print STDERR "\nError in file '$myFilename'\n";
		die $@;
	}
}

sub genTarget {
	my $i;

	for($i=0 ; $i<scalar(@theTargetModules); $i++) {
		my $moduleName = $theTargetModules[$i];
		my $option;
		my $count = 0;

		foreach $option (@theTargetOptions) {
			my $myFilename = $moduleName;
			$myFilename .= "_$option" if (!($option eq ''));
			$myFilename .= ".pl";
# print "file $myFilename\n";
			if (-e $myFilename) {
				executeFile($myFilename);
				$count++;
			}
		}
		if ($count == 0) {
			print "????? $moduleName...\n";
		}
	}
}

sub useModule {
	my $module;
	do {
		$module = shift;
		if (defined($module)) {
			push(@theTargetModules, $module);
		}
	} while (defined($module));
}

$theTargetBaseName = shift;
$theProgramName = $theTargetBaseName;
$theTargetFilename = "$theTargetBaseName";
$theTargetCppFilename = "$theTargetBaseName.cpp";

my $option = shift;
while(defined($option)) {
	push(@theTargetOptions, $option);
	$option = shift;
}

useModule("$theTargetBaseName");
genTarget();

