#
# Save the user-manual written in with OpenOffice as HTML file named studiofactory.html
# Run this script over it and the result will (hopefully) be a helpfile in a format usable for studiofactory
#
# This is NOT a generic script. It has many hardcoded stuff that can break when the manual is updated.
# Run it in a seperate directory and compare to the original studiofactory_objectshelp.txt before overwriting.
#

sub convert {
  my $language = shift;

open(OUT, ">studiofactory_objectshelp_$language.txt") || die "open out";
open(OUT_E, ">studiofactory_objectshelp_empty.txt") || die "open out";

sub readCompleteFile {
  my $filename = shift; 
  my $r;
  local $/;

  open(FILE, $filename) || die "can't open $filename";
  $r=<FILE>;
  close(FILE);

  return $r;
}

my $r = readCompleteFile("studiofactory_$language.html");

# remove CLASS, STYLE and CENTER options which are not supported in internal HTML viewer
$r =~ s@(\<[a-zA-Z0-9/]+?)\s.+?\>@$1>@g;
$r =~ s@\<\/?SPAN\>@@g;
$r =~ s@\<\/?FONT\>@@g;
$r =~ s@\<\/?OL\>@@g;
$r =~ s@\<\/?LI\>@@g;
$r =~ s@\s+\>@ >@g;

# remove tabs and carriage linefeeds
$r =~ s@\t@ @g;
$r =~ s@\n@ @g;

# remove double spaces and unnecessary spaces in html code
$r =~ s@\s+@ @g;
$r =~ s@\>\s+\<@\>\<@g;

# remove empty paragraphs
$r =~ s@\<P\>(\<BR\>)*\<\/P\>@@g;

# remove unused chapters
$r =~ s@\<H2\>.*?\<\/H2\>@@g;

# remove unused HTML source (yes we do the same search thing twice, so what? ;-)
# this round we remove stuff in front of the module descriptions
$r =~ s@(.|\s)*?SynFactory\sModules@@;
$r =~ s@(.|\s)*?SynFactory\sModules\<\/H1\>@@;

# remove unused HTML source 
# this round we remove stuff after the module descriptions
$r =~ s@\<H2\>.*\<\/H2\>\".*?\n@@g;
$r =~ s@\<H1\>(.|\s)*@@g;

# convert chapter header to enum + help header
$r =~ s@\<H3\>(.+?)(\s\-.*?)\<\/H3\>@\nSTRING_OBJECTHELP_$1 <P><H2>$1$2</H2></P>@g;
$r .= "\n";

# remove first \n
$r =~ s@\n@@;

# Hacker hacking hack. fixup some small details
$r =~ s@_OB\sVCF\s@_OBVCF @g;
$r =~ s@_S\/H\s@_SAH @g;

# Multiple modules with the same name fun fun fun ;-)
$r =~ s@_SEQ\s@_SEQ16 @;
$r =~ s@_SEQ\s@_SEQ8 @;
$r =~ s@_DeMux\s@_DeMux2 @;
$r =~ s@_DeMux\s@_DeMux4 @;
$r =~ s@_DeMux\s@_DeMux8 @;
$r =~ s@_DeMux\s@_DeMux16 @;
$r =~ s@_OUT\s@_OUTX @;
$r =~ s@_OUT\s@_OUTS @;
$r =~ s@_OUTX\s@_OUT @;
$r =~ s@_MIX\s@_MIX3 @;
$r =~ s@_MIX\s@_MIX4 @;
$r =~ s@_MIX\s@_MIX8 @;

  while ($r =~ s@(.+?)\s(.+?)\n@@) {
	  my $str=$2;
	  print OUT ($1 . "\n");	
	  print OUT_E ($1 . "\n  NULL\n");	
	  while (length($str)>60) {
		  print OUT ("  \"" . substr($str, 0, 60) . "\"\n");
		  $str = substr($str, 60);
	  }
	  if (length($str)>0) {
		  print OUT ("  \"" . $str . "\"\n");
	  }
  }
}




convert("en");
convert("nl");
