##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2004  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Track/Midi/Audio/Video sequencer
#
##########################################################################

# Songs -> Patterns -> Sections -> Phrases -> Events
#            Tracks -> Sections -> Phrases -> Events
#
# Event:
#    - Set tempo / metronoom
#    - Midi noteon/off/cc etc
#    - Play audio file + speed
#    - Change volume
#    - Play video/multimedia file
#    - Display picture
#    - Perform scripted action



my @PatternStructDef=(
  'int refCount;',
  'int maxTracks;',
);

my @SongStructDef=(
  'int maxPatterns;',
  'Pattern *patterns;',
);

genEnumStruct("struct", "Pattern", \@PatternStructDef);
genEnumStruct("struct", "Song", \@SongStructDef);





my @trackElementStructDef=('bool inUse;', 'bool selected;');
genEnumStruct("struct", "TrackElement", \@trackElementStructDef);
my @trackStructDef=('bool inUse;', 'bool selected;', 'char *trackName;', 'TrackElementPtr elements;', 'int maxElements;');
genEnumStruct("struct", "Track", \@trackStructDef);

$rc .= <<EOF;
static int createTrack(void) {
  char tmpName[256];
  int i;
  int n=-1;

  if (projects==NULL) {
    createProject(newProjectName);
  }
  for(i=0;i<projects[currentProject].maxTracks;i++) {
    if (!projects[currentProject].tracks[i].inUse) {
      n=i;
    }
  }
  if (n==-1) {
    n=projects[currentProject].maxTracks;
    projects[currentProject].maxTracks++;
    projects[currentProject].tracks=(TrackPtr)realloc(projects[currentProject].tracks, projects[currentProject].maxTracks*sizeof(Track));
  }
  memset(&(projects[currentProject].tracks[n]), 0, sizeof(Track));
  projects[currentProject].tracks[n].inUse=true;
  sprintf(tmpName, "track %d", n+1);
  projects[currentProject].tracks[n].trackName=strdup(tmpName);
  selectProjectBrowserItem(currentProject, NULL, -1, n, false);
  return n;
}

static int firstTimelineArea;
static void processTimeline(ContextPtr aContext) {
  switch (aContext->guiEvent) {
  case GUIEVENT_REFRESH: {
      firstTimelineArea=guiGetAreaListLen(aContext);

      guiSelectFillColor(aContext, -1);
      guiDraw3DRect(aContext, &(aContext->guiClientRect), 0);
      if (currentProject>=0) {
        int y=0;
        int i;

        for(i=0; i<projects[currentProject].maxTracks; i++) {
          if (projects[currentProject].tracks[i].inUse) {
            GuiRect trackrect;
            char tmpstr[256];

            trackrect.left=0;
            trackrect.right=96;
            trackrect.top=(y++)*64+32;
            trackrect.bottom=trackrect.top+64;
            guiAddArea(aContext, trackrect.left, trackrect.top, trackrect.right, trackrect.bottom);
            if (projects[currentProject].tracks[i].selected) {
              guiSelectFillColor(aContext, 4);
            } else {
              guiSelectFillColor(aContext, 15);
            }
            guiDraw3DRect(aContext, &trackrect, EDGE_ETCHED);

    //        DrawEdge(context->hdc, &trackrect, EDGE_ETCHED, BF_MIDDLE | BF_RECT);
            trackrect.left=96;
            trackrect.right=aContext->guiClientRect.right;
            guiSelectFillColor(aContext, -1);
            guiDraw3DRect(aContext, &trackrect, EDGE_SUNKEN);
    //        DrawEdge(context->hdc, &trackrect, EDGE_SUNKEN, BF_MIDDLE | BF_RECT);

            SetBkMode(aContext->hdc, TRANSPARENT);
            SetTextAlign(aContext->hdc, TA_TOP | TA_LEFT);
            guiSelectPotFont(aContext);
            sprintf(tmpstr, "track %d\\nType: Audio/Video", i+1);
            trackrect.top+=4;
            trackrect.left=4;
            trackrect.right=92;
            DrawText(aContext->hdc, tmpstr, strlen(tmpstr), &trackrect, DT_LEFT);
          }
        }
      }

    } break;
  case GUIEVENT_MOUSEBUTTON1DOWN: {
      if (currentProject>=0) {
        int areaNr=firstTimelineArea;
        int i;

        for(i=0; i<projects[currentProject].maxTracks; i++) {
          if (projects[currentProject].tracks[i].inUse) {
            if ((++areaNr) == aContext->id) {
              selectProjectBrowserItem(currentProject, NULL, -1, i, false);
            }
          }
        }
      }
    } break;
  default:
    break;
  }  
}
EOF