##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2004  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Sample editor and sample load and storage
#
##########################################################################


my @sampleEncodingDef=qw(SAMPLE_ENCODING_NONE SAMPLE_ENCODING_WAV SAMPLE_ENCODING_MP3 SAMPLE_ENCODING_OGG);
genEnumStruct("enum", "SampleEncoding", \@sampleEncodingDef, ',');

my @sampleStructDef=(
  'bool selected;',
  'SampleEncoding encoding;',
  'int sampleRate;',
  'int noofBits;',
  'int noofChannels;',
  'int noofSamples;',
  'FILE *file;',
  'int storedNoofSamples;'
);
genEnumStruct("struct", "Sample", \@sampleStructDef);


rv('int currentSample=-1;');





  $rs .= <<EOF;
#include "lame_enc.h"
static HINSTANCE        LameDLL=NULL;
static BEINITSTREAM     beInitStream=NULL;
static BEENCODECHUNK		beEncodeChunk=NULL;
static BEDEINITSTREAM   beDeinitStream=NULL;
static BECLOSESTREAM    beCloseStream=NULL;
static BEVERSION        beVersion=NULL;
//static BEWRITEVBRHEADER	beWriteVBRHeader=NULL;
static BYTE mp3buffer[20000];
static bool initLameDLLReady=false;
static HBE_STREAM mp3StreamID =0;

//
// Open Lame encoder and set various work variables
//
static void initLameDLL(void) {
  BE_VERSION Version;

  if (!initLameDLLReady) {
    logprintf("Initialising Lame encoder.\\n");
    if (LameDLL==NULL) {
      LameDLL = LoadLibrary("lame_enc.dll");
      if (LameDLL==NULL) {
        logprintf("Failed to load 'lame_enc.dll'.\\n");
        return;
      }
    }

    // Get Interface functions from the DLL
    if (beInitStream==NULL) beInitStream=(BEINITSTREAM)GetProcAddress(LameDLL, TEXT_BEINITSTREAM);
    if (beEncodeChunk==NULL) beEncodeChunk=(BEENCODECHUNK)GetProcAddress(LameDLL, TEXT_BEENCODECHUNK);
    if (beDeinitStream==NULL) beDeinitStream=(BEDEINITSTREAM)GetProcAddress(LameDLL, TEXT_BEDEINITSTREAM);
    if (beCloseStream==NULL) beCloseStream=(BECLOSESTREAM)GetProcAddress(LameDLL, TEXT_BECLOSESTREAM);
    if (beVersion==NULL) beVersion=(BEVERSION)GetProcAddress(LameDLL, TEXT_BEVERSION);
//	  if (beWriteVBRHeader==NULL) beWriteVBRHeader=(BEWRITEVBRHEADER)GetProcAddress(LameDLL, TEXT_BEWRITEVBRHEADER);

//    if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion || !beWriteVBRHeader) {
    if(!beInitStream || !beEncodeChunk || !beDeinitStream || !beCloseStream || !beVersion) {
		  logprintf("Error was unable to get all interfaces to Lame encoder.\\n");
		  return;
    }

    // Get the version number
    memset(&Version, 0, sizeof(Version));
    (*beVersion)(&Version);

    logprintf(
      "lame_enc.dll version %u.%02u (%u/%u/%u)\\n"
      "lame_enc Engine %u.%02u\\n"
      "lame_enc homepage at %s\\n",	
      Version.byDLLMajorVersion, Version.byDLLMinorVersion,
      Version.byDay, Version.byMonth, Version.wYear,
      Version.byMajorVersion, Version.byMinorVersion,
      Version.zHomepage);

    logprintf("Activated Lame encoder\\n");
    initLameDLLReady=true;
  }
}


static void createSampleFile(Sample *sample, const char *filename) {
  sample->storedNoofSamples=0;
  switch(sample->encoding) {
  case SAMPLE_ENCODING_WAV: {
      sample->file=fopen(filename, "wb");
      if (sample->file) {
        long bytespersec = sample->sampleRate * sample->noofChannels * (sample->noofBits/8);
        fprintf(sample->file, "RIFF____WAVEfmt %c%c%c%c%c%c%c%c", 0x10, 0, 0, 0, 1, 0, sample->noofChannels, 0);
        fwrite(&(sample->sampleRate), 4, 1, sample->file);
        fwrite(&bytespersec, 4, 1, sample->file);
        fprintf(sample->file, "%c%c%c%cdata____", 4, 0, sample->noofBits, 0);
      }
    } break;
  case SAMPLE_ENCODING_MP3: {
      initLameDLL();
      if (initLameDLLReady) {
        DWORD  dwSamples   =0;
        DWORD  dwMP3Buffer =0;
        BE_ERR err         =0;
        BE_CONFIG beConfig;

        memset(&beConfig,0,sizeof(beConfig));  // clear all fields

        // use the MP3 config structure, since this is the only one supported right now
        beConfig.dwConfig = BE_CONFIG_MP3;

        beConfig.format.mp3.dwSampleRate = 44100;               // SAMPLE RATE
        beConfig.format.mp3.byMode       = BE_MP3_MODE_STEREO;  // STEREO
        beConfig.format.mp3.wBitrate     = 128;                 // BITRATE
        beConfig.format.mp3.bOriginal    = TRUE;                // SET ORIGINAL FLAG

        err = beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &mp3StreamID);

        // Check result
        if(err != BE_ERR_SUCCESSFUL) {
          logprintf("Error opening MP3 encoding stream (%lu)\\n", err);
        } else {
          sample->file=fopen(filename, "wb");
        }
      }
    } break;
  default:
    break;
  }
}

static void closeSampleFile(Sample *sample) {
  if (sample->file) {
    switch(sample->encoding) {
    case SAMPLE_ENCODING_WAV: {
        long size;
        size=sample->storedNoofSamples*(sample->noofBits/8) + 0x24;
        fseek(sample->file, 0x04, SEEK_SET);
        fwrite(&size, 4, 1, sample->file);
        size=sample->storedNoofSamples*(sample->noofBits/8);
        fseek(sample->file, 0x28, SEEK_SET);
        fwrite(&size, 4, 1, sample->file);
      } break;
    case SAMPLE_ENCODING_MP3: {
        DWORD bytesEncoded;

        beDeinitStream(mp3StreamID, mp3buffer, &bytesEncoded);
        if (bytesEncoded > 0 ) {
          fwrite(mp3buffer, bytesEncoded, 1, sample->file);
        }
        beCloseStream(mp3StreamID);
      } break;
    default:
      break;
    }
    fclose(sample->file);
    sample->file=NULL;
  }
}

static void writeSampleData(Sample *sample, void *sampleData, int nrSamples) {
  if (sample->file) {
    switch(sample->encoding) {
    case SAMPLE_ENCODING_WAV: {
        sample->storedNoofSamples+=fwrite(sampleData, sample->noofBits/8, nrSamples, sample->file);
      } break;
    case SAMPLE_ENCODING_MP3: {
        DWORD bytesEncoded;

        beEncodeChunk(mp3StreamID, nrSamples, (short *)sampleData, mp3buffer, &bytesEncoded);
        sample->storedNoofSamples+=nrSamples;
        if (bytesEncoded>0) {
          fwrite(mp3buffer, bytesEncoded, 1, sample->file);
        }
      } break;
    default:
      break;
    }
  }
}
EOF




$rc .= <<EOF;

static void processSampleEditor(ContextPtr aContext) {
}

EOF
