##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2004  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################

rv('HFONT TitleFont;');
rv('HFONT PotFont;');
rv('HFONT IOFont;');
rv('HFONT RouterFont;');


$rc .= <<EOF;

static bool guiSelectPotFont(ContextPtr context) {
  if (NULL!=context->hdc && NULL!=PotFont) {
    SelectObject(context->hdc, PotFont);
    return true;
  }
  return false;
}

static bool guiSelectIOFont(ContextPtr context) {
  if (NULL!=context->hdc && NULL!=IOFont) {
    SelectObject(context->hdc, IOFont);
    return true;
  }
  return false;
}

static bool guiSelectTitleFont(ContextPtr context) {
  if (NULL!=context->hdc && NULL!=TitleFont) {
    SelectObject(context->hdc, TitleFont);
    return true;
  }
  return false;
}

static bool guiSelectRouterFont(ContextPtr context) {
  if (NULL!=context->hdc && NULL!=RouterFont) {
    SelectObject(context->hdc, RouterFont);
    return true;
  }
  return false;
}

static bool guiTextTransparent(ContextPtr context, bool flag) {
  SetBkMode(context->hdc, (flag)?TRANSPARENT:OPAQUE);
  return true;
}
EOF

my $initcode = <<EOF;
  PotFont = CreateFont(
    14, 0, 0, 0, FW_THIN, FALSE, FALSE, FALSE,
    DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
    PROOF_QUALITY, VARIABLE_PITCH | FF_DONTCARE, "Arial");

  // I/O connections font
  IOFont = CreateFont(
    12, 6, 0, 0, FW_THIN, FALSE, FALSE, FALSE,
    DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
    PROOF_QUALITY, VARIABLE_PITCH | FF_DONTCARE, "Arial");

  // Object title font
  TitleFont = CreateFont(
    16, 12, 0, 0, FW_THIN, FALSE, FALSE, FALSE,
    DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
    PROOF_QUALITY, FIXED_PITCH | FF_DONTCARE, "Courier New");

  RouterFont = CreateFont(
    14,  0, 0, 0, FW_THIN, FALSE, FALSE, FALSE,
    DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
    PROOF_QUALITY, FIXED_PITCH | FF_DONTCARE, "Courier New");
EOF

push(@initFunctions, $initcode);
push(@termFunctions, "DeleteObject(PotFont);");
push(@termFunctions, "DeleteObject(IOFont);");
push(@termFunctions, "DeleteObject(TitleFont);");
push(@termFunctions, "DeleteObject(RouterFont);");

