##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2004  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################
#
# Audio Mixer
#
##########################################################################

$rc .= <<EOF;
static void audioMixerHandler(ContextPtr aContext) {
  switch (aContext->guiEvent) {
  case GUIEVENT_REFRESH: {
      guiSelectFillColor(aContext, 0xFFFFFF);
      guiSelectPen1Color(aContext, -1);
      guiDrawRect(aContext, aContext->guiClientRect.left, aContext->guiClientRect.top, aContext->guiClientRect.right, aContext->guiClientRect.bottom);
    } break;
  case GUIEVENT_KEYDOWN:
    switch(aContext->id) {
    case VK_ESCAPE:
      guiHideWindow(aContext->currentWindow);
      break;
    default:
      break;
    } break;
  case GUIEVENT_CLOSE:
    guiHideWindow(aContext->currentWindow);
    break;
  default:
    break;
  }
}


EOF


genWindow('audioMixerWindow', 'AudioMixerWindow', '"Audio Mixer"', 'audioMixerHandler', undef, undef, 1, undef);
