##########################################################################
#
# StudioFactory
#
# The desktop Audio/Video studio.
# Copyright (C) 2002-2004  Peter Wendrich (pwsoft@syntiac.com)
# Homepage: http://www.syntiac.com/studiofactory.html
#
##########################################################################
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################

$rc .= <<EOF;

static void fourChanScopeHandler(ContextPtr aContext) {
  _DspObject *object=(_DspObject*)aContext->userData;
  if (object) {
    switch (aContext->guiEvent) {
    case GUIEVENT_REFRESH: {
        //RECT clientRect;
        GuiRect myRect;
  //      int Nr;
        int cnt;
        int xRange;
        int yRange;
        int value[4]={0,0,0,0};
        int low[4]={0,0,0,0};
        int high[4]={0,0,0,0};
        char tmpstr[64];

        //GetClientRect(hwnd, &clientRect);
        myRect=aContext->guiClientRect;
        FillRect(aContext->hdc, &myRect, (HBRUSH)GetStockObject(BLACK_BRUSH));
        xRange=((myRect.right-16)/2);
        yRange=((myRect.bottom-16)/4);

        // Draw base lines
        guiSelectPen1Color(aContext, 0x008888);
  //      SelectObject(aContext->hdc, ScopeBaseLinePen);
        MoveToEx(aContext->hdc,         0,   yRange, NULL);
        LineTo(aContext->hdc, xRange, yRange);
        MoveToEx(aContext->hdc, xRange+16,   yRange, NULL);
        LineTo(aContext->hdc, myRect.right, yRange);
        MoveToEx(aContext->hdc,         0, 3*yRange+16, NULL);
        LineTo(aContext->hdc, xRange, 3*yRange+16);
        MoveToEx(aContext->hdc, xRange+16, 3*yRange+16, NULL);
        LineTo(aContext->hdc, myRect.right, 3*yRange+16);

        if (object->io[0].intern==SCOPEBUFSIZE) {
          guiSelectPen1Color(aContext, 0x00FFFF);

          // Channel 1
          MoveToEx(aContext->hdc, 0, yRange-(object->buffer[0]*yRange)/32768, NULL);
          value[0]=object->buffer[0];
          low[0]=object->buffer[0];
          high[0]=object->buffer[0];
          for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
            value[0]+=object->buffer[cnt];
            if (object->buffer[cnt]<low[0])
              low[0]=object->buffer[cnt];
            if (object->buffer[cnt]>high[0])
              high[0]=object->buffer[cnt];
            LineTo(aContext->hdc, (cnt*xRange)/SCOPEBUFSIZE, yRange-(object->buffer[cnt]*yRange)/32768);
          }

          // Channel 2
          MoveToEx(aContext->hdc, xRange+16, yRange-(object->buffer[1024]*yRange)/32768, NULL);
          value[1]=object->buffer[1024];
          low[1]=object->buffer[1024];
          high[1]=object->buffer[1024];
          for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
            value[1]+=object->buffer[1024+cnt];
            if (object->buffer[1024+cnt]<low[1])
              low[1]=object->buffer[1024+cnt];
            if (object->buffer[1024+cnt]>high[1])
              high[1]=object->buffer[1024+cnt];
            LineTo(aContext->hdc, xRange+16+(cnt*xRange)/SCOPEBUFSIZE, yRange-(object->buffer[1024+cnt]*yRange)/32768);
          }

          // Channel 3
          MoveToEx(aContext->hdc, 0, 3*yRange+16-(object->buffer[2048]*yRange)/32768, NULL);
          value[2]=object->buffer[2048];
          low[2]=object->buffer[2048];
          high[2]=object->buffer[2048];
          for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
            value[2]+=object->buffer[2048+cnt];
            if (object->buffer[2048+cnt]<low[2])
              low[2]=object->buffer[2048+cnt];
            if (object->buffer[2048+cnt]>high[2])
              high[2]=object->buffer[2048+cnt];
            LineTo(aContext->hdc, (cnt*xRange)/SCOPEBUFSIZE, 3*yRange+16-(object->buffer[2048+cnt]*yRange)/32768);
          }

          // Channel 4
          MoveToEx(aContext->hdc, xRange+16, 3*yRange+16-(object->buffer[3072]*yRange)/32768, NULL);
          value[3]=object->buffer[3072];
          low[3]=object->buffer[3072];
          high[3]=object->buffer[3072];
          for(cnt=1; cnt<SCOPEBUFSIZE; cnt++) {
            value[3]+=object->buffer[3072+cnt];
            if (object->buffer[3072+cnt]<low[3])
              low[3]=object->buffer[3072+cnt];
            if (object->buffer[3072+cnt]>high[3])
              high[3]=object->buffer[3072+cnt];
            LineTo(aContext->hdc, xRange+16+(cnt*xRange)/SCOPEBUFSIZE, 3*yRange+16-(object->buffer[3072+cnt]*yRange)/32768);
          }

          // Restart buffering of data
          object->io[0].intern = 0;
        }



  //    SelectObject(aContext->hdc, GrayPen);
        guiSelectTitleFont(aContext);
  //      SelectObject(aContext->hdc, TitleFont);
        SetBkMode(aContext->hdc, TRANSPARENT);
        SetTextAlign(aContext->hdc, TA_BOTTOM | TA_LEFT);
        SetTextColor(aContext->hdc, PALETTERGB(255,255,255));

        sprintf(tmpstr, "1: %d", value[0]/SCOPEBUFSIZE);
        TextOut(aContext->hdc, 0, yRange, tmpstr, strlen(tmpstr));
        sprintf(tmpstr, "L/H: %d %d", low[0], high[0]);
        TextOut(aContext->hdc, 0, yRange+16, tmpstr, strlen(tmpstr));

        sprintf(tmpstr, "2: %d", value[1]/SCOPEBUFSIZE);
        TextOut(aContext->hdc, xRange+16,   yRange, tmpstr, strlen(tmpstr));
        sprintf(tmpstr, "L/H: %d %d", low[1], high[1]);
        TextOut(aContext->hdc, xRange+16, yRange+16, tmpstr, strlen(tmpstr));

        sprintf(tmpstr, "3: %d", value[2]/SCOPEBUFSIZE);
        TextOut(aContext->hdc, 0, 3*yRange+16, tmpstr, strlen(tmpstr));
        sprintf(tmpstr, "L/H: %d %d", low[2], high[2]);
        TextOut(aContext->hdc, 0, 3*yRange+32, tmpstr, strlen(tmpstr));

        sprintf(tmpstr, "4: %d", value[3]/SCOPEBUFSIZE);
        TextOut(aContext->hdc, xRange+16, 3*yRange+16, tmpstr, strlen(tmpstr));
        sprintf(tmpstr, "L/H: %d %d", low[3], high[3]);
        TextOut(aContext->hdc, xRange+16, 3*yRange+32, tmpstr, strlen(tmpstr));
      } break;
    case GUIEVENT_TIMERTICK:
      if (object->io[0].intern==SCOPEBUFSIZE) {
        guiRefreshWindow(aContext->currentWindow, NULL);

      }
  //    if (DSP_ScopePosition==4*SCOPEBUFSIZE) {
  //      guiRefreshWindow(aContext->currentWindow, NULL);
  //    }
      break;
    case GUIEVENT_KEYDOWN:
      switch(aContext->id) {
      case VK_ESCAPE:
        guiHideWindow(aContext->currentWindow);
        break;
      default:
        break;
      } break;
    case GUIEVENT_CLOSE:
      guiHideWindow(aContext->currentWindow);
      break;
    default:
      break;
    }
  }
}



HWND createMultiScopeWindow(_DspObject *obj) {
  HWND newWindow=CreateWindowEx(
    WS_EX_TOOLWINDOW, mainWindowClass, "4 Channel Scope",
    WS_SYSMENU | WS_CLIPCHILDREN | WS_THICKFRAME | WS_OVERLAPPED,
    CW_USEDEFAULT, CW_USEDEFAULT, 512, 270,
    mainWindow, NULL, myInstance, NULL);
    SetWindowLong(newWindow, WNDEXTRA_EVENTFUNC, (LONG)fourChanScopeHandler);
    SetWindowLong(newWindow, WNDEXTRA_USERDATA, (LONG)obj);
  SetTimer(newWindow, 1, 100, NULL);
  
  
/*  
  guiOpenToolWindow(
    aContext, aContext->mainWindow, "4 Channel Scope",
    512, 270,
    WF_DOUBLEBUFFER | WF_CLEARONRESIZE | WF_HIDDEN,
    eventHandler, (void*)obj);
*/

  return newWindow;
}


EOF

