#
# Save the user-manual written in with OpenOffice as HTML file named studiofactory.html
# Run this script over it and the result will (hopefully) be a helpfile in a format usable for studiofactory
#
# This is NOT a generic script. It has many hardcoded stuff that can break when the manual is updated.
# Run it in a seperate directory and compare to the original studiofactory_objectshelp.txt before overwriting.
#

open(OUT, ">studiofactory_objectshelp.txt") || die "open out";

sub readCompleteFile {
  my $filename = shift; 
  my $r;
  local $/;

  open(FILE, $filename) || die "can't open $filename";
  $r=<FILE>;
  close(FILE);

  return $r;
}

my $r = readCompleteFile("studiofactory.html");

# remove CLASS, STYLE and CENTER options which are not supported in internal HTML viewer
$r =~ s@(\<[a-zA-Z0-9/]+?)\s.+?\>@$1>@g;
$r =~ s@\<\/?SPAN\>@@g;
$r =~ s@\<\/?FONT\>@@g;
$r =~ s@\<\/?OL\>@@g;
$r =~ s@\<\/?LI\>@@g;
$r =~ s@\s+\>@ >@g;

# reformat source
$r =~ s@\n@ @g;
$r =~ s@\s+@ @g;
$r =~ s@\t@ @g;
$r =~ s@\</P\>\s*@</P>"\n  "@g;
$r =~ s@\<\/H(1|2|3)\>\s*@</H$1>"\n  "@g;
$r =~ s@\<BR\>\s*@<BR>"\n  "@g;
$r =~ s@\>\s+\<@><@g;

# remove unused HTML source (yes we do the same search thing twice, so what? ;-)
# this round we remove stuff in front of the module descriptions
$r =~ s@(.|\s)*?SynFactory\sModules@@;
$r =~ s@(.|\s)*?SynFactory\sModules\<\/H1\>\"\n@@;

# removed empty paragraphs
$r =~ s@\"\<P\>\<BR\>\"\s+@@g;
$r =~ s@\"\<BR\>\"\s+@@g;
$r =~ s@\"\<\/P\>\"\s+@@g;

# Create 'static const char *' header
$r =~ s@\"\<H3\>(.+?)(\s\-.*)\<\/H3\>\"@\nstatic const char * const objectHelp_$1=\n  "<P><H2>$1$2</H2></P>"@g;

# remove unused HTML source 
# this round we remove stuff after the module descriptions
$r =~ s@\"\<H2\>.*\<\/H2\>\".*?\n@@g;
$r =~ s@\"\<H1\>(.|\s)*@@g;

# Add ;
$r .= "\n";
$r =~ s@\"\n\s+?\n@";\n\n@g;

# Hacker hacking hack. fixup some small details
$r =~ s@_OB\sVCF\=@_OBVCF=@g;
$r =~ s@_S\/H\=@_SAH=@g;

# Multiple modules with the same name fun fun fun ;-)
$r =~ s@_SEQ\=@_SEQ16=@;
$r =~ s@_SEQ\=@_SEQ8=@;
$r =~ s@_DeMux\=@_DeMux2=@;
$r =~ s@_DeMux\=@_DeMux4=@;
$r =~ s@_DeMux\=@_DeMux8=@;
$r =~ s@_DeMux\=@_DeMux16=@;
$r =~ s@_OUT\=@_OUTX=@;
$r =~ s@_OUT\=@_OUTS=@;
$r =~ s@_OUTX\=@_OUT=@;
$r =~ s@_MIX\=@_MIX3=@;
$r =~ s@_MIX\=@_MIX4=@;
$r =~ s@_MIX\=@_MIX8=@;


print OUT $r;

