

my $sampleFreq=44100.0;
my $maxFreq=8000.0;
my $bands=20;

my @a0;
my @a1;
my @a2;
my @b1;
my @b2;

$bands++;
my $freqStep=$maxFreq/$bands;

my $pi=3.141592654;

for(my $i=1;$i<$bands;$i++) {
#  my $f=$i*$freqStep;
  my $f=$maxFreq/(2**((21-$i)/4));
  my $bw=$f/8;
  printf "band $i ($f bw=$bw)\n";
  $f=$f/$sampleFreq;
  my $BW=$bw/$sampleFreq;

  my $R=1-3*$BW;
  my $K=(1-2*$R*cos(2*$pi*$f)+$R*$R)/(2-2*cos(2*$pi*$f));

  my $a0=1-$K;
  my $a1=2*($K-$R)*cos(2*$pi*$f);
  my $a2=$R*$R-$K;
  my $b1=2*$R*cos(2*$pi*$f);
  my $b2=-$R*$R;
#  printf "a0 $a0, a1 $a1, a2 $a2, b1 $b1, b2 $b2\n";

  $a0=int($a0*16384);
  $a1=int($a1*16384);
  $a2=int($a2*16384);
  $b1=int($b1*16384);
  $b2=int($b2*16384);
  $a0[$i]=$a0;
  $a1[$i]=$a1;
  $a2[$i]=$a2;
  $b1[$i]=$b1;
  $b2[$i]=$b2;
  printf "a0 $a0, a1 $a1, a2 $a2, b1 $b1, b2 $b2\n";
}

open COOF, ">coof.txt";
printf COOF "static int a0[]={";
for(my $i=1;$i<$bands;$i++) {
  print COOF sprintf "%6d,", $a0[$i];
}
printf COOF "\n";
printf COOF "static int a1[]={";
for(my $i=1;$i<$bands;$i++) {
  print COOF sprintf "%6d,", $a1[$i];
}
printf COOF "\n";
printf COOF "static int a2[]={";
for(my $i=1;$i<$bands;$i++) {
  print COOF sprintf "%6d,", $a2[$i];
}
printf COOF "\n";
printf COOF "static int b1[]={";
for(my $i=1;$i<$bands;$i++) {
  print COOF sprintf "%6d,", $b1[$i];
}
printf COOF "\n";
printf COOF "static int b2[]={";
for(my $i=1;$i<$bands;$i++) {
  print COOF sprintf "%6d,", $b2[$i];
}
printf COOF "\n";
