SETLOCAL

:: Release value
SET RELEASETXT=0.21
SET RELEASE=021

::
SET TODIR=FPGA64_%RELEASE%
SET TOBOOT=%TODIR%\boot
SET TOSRC=%TODIR%\sources
SET TOVHDL=%TOSRC%\vhdl

::
:: Copy readme
::
mkdir %TODIR%
copy readme.txt %TODIR%

::
:: Copy boot images
::
mkdir %TOBOOT%
call make_fpga64_boot.bat
copy boot %TOBOOT%
echo FPGA64 %RELEASETXT% >%TOBOOT%\8desc.txt 

::
:: Make source tree
::
mkdir %TOSRC%
copy make_fpga64_boot.bat %TOSRC%
copy make_fpga64_release.bat %TOSRC%
copy readme.txt %TOSRC%

::
:: Copy roms
::
mkdir %TOSRC%\roms
copy roms %TOSRC%\roms

::
:: Copy quartus project
::
mkdir %TOSRC%\quartus_cone
copy quartus_cone\fpga64_top.bdf %TOSRC%\quartus_cone
copy quartus_cone\fpga64_cone.bsf %TOSRC%\quartus_cone
copy quartus_cone\gbridge.bsf %TOSRC%\quartus_cone
copy quartus_cone\gbridge.tdf %TOSRC%\quartus_cone
copy quartus_cone\quartus_cone.qpf %TOSRC%\quartus_cone
copy quartus_cone\quartus_cone.qsf %TOSRC%\quartus_cone

::
:: Copy vhdl code
::
mkdir %TOVHDL%
copy vhdl\c64rom_basic.vhd %TOVHDL%
copy vhdl\c64rom_chargen.vhd %TOVHDL%
copy vhdl\c64rom_kernal.vhd %TOVHDL%
copy vhdl\cia6526.vhd %TOVHDL%
copy vhdl\cpu65xx_e.vhd %TOVHDL%
copy vhdl\cpu65xx_fast.vhd %TOVHDL%
copy vhdl\cpu_6510.vhd %TOVHDL%
copy vhdl\fpga64_buslogic_nommu.vhd %TOVHDL%
copy vhdl\fpga64_buslogic_roms.vhd %TOVHDL%
copy vhdl\fpga64_bustiming.vhd %TOVHDL%
copy vhdl\fpga64_cone.vhd %TOVHDL%
copy vhdl\fpga64_dcm100mhz.vhd %TOVHDL%
copy vhdl\fpga64_dcm50mhz.vhd %TOVHDL%
copy vhdl\fpga64_hexy.vhd %TOVHDL%
copy vhdl\fpga64_hexy_vmode.vhd %TOVHDL%
copy vhdl\fpga64_keyboard_matrix.vhd %TOVHDL%
copy vhdl\fpga64_rgbcolor.vhd %TOVHDL%
copy vhdl\fpga64_rwram.vhd %TOVHDL%
copy vhdl\fpga64_scandoubler.vhd %TOVHDL%
copy vhdl\fpga64_singleram.vhd %TOVHDL%
copy vhdl\fpga64_xess_xsa3s1000.vhd %TOVHDL%
copy vhdl\io_ps2_keyboard.vhd %TOVHDL%
copy vhdl\vicii_6567_6569.vhd %TOVHDL%


ENDLOCAL
