library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.numeric_std.ALL;

entity c64rom_chargen is
	port (
		clk: in std_logic;
		addr: in unsigned(11 downto 0);
		do: out unsigned(7 downto 0)
	);
end c64rom_chargen;

architecture Behavioral of c64rom_chargen is
	type romDef is array(0 to 2047) of unsigned(7 downto 0);
	constant romData: romDef := (
		X"3C", X"66", X"6E", X"6E", X"60", X"62", X"3C", X"00", X"18", X"3C", X"66", X"7E", X"66", X"66", X"66", X"00", 
		X"7C", X"66", X"66", X"7C", X"66", X"66", X"7C", X"00", X"3C", X"66", X"60", X"60", X"60", X"66", X"3C", X"00", 
		X"78", X"6C", X"66", X"66", X"66", X"6C", X"78", X"00", X"7E", X"60", X"60", X"78", X"60", X"60", X"7E", X"00", 
		X"7E", X"60", X"60", X"78", X"60", X"60", X"60", X"00", X"3C", X"66", X"60", X"6E", X"66", X"66", X"3C", X"00", 
		X"66", X"66", X"66", X"7E", X"66", X"66", X"66", X"00", X"3C", X"18", X"18", X"18", X"18", X"18", X"3C", X"00", 
		X"1E", X"0C", X"0C", X"0C", X"0C", X"6C", X"38", X"00", X"66", X"6C", X"78", X"70", X"78", X"6C", X"66", X"00", 
		X"60", X"60", X"60", X"60", X"60", X"60", X"7E", X"00", X"63", X"77", X"7F", X"6B", X"63", X"63", X"63", X"00", 
		X"66", X"76", X"7E", X"7E", X"6E", X"66", X"66", X"00", X"3C", X"66", X"66", X"66", X"66", X"66", X"3C", X"00", 
		X"7C", X"66", X"66", X"7C", X"60", X"60", X"60", X"00", X"3C", X"66", X"66", X"66", X"66", X"3C", X"0E", X"00", 
		X"7C", X"66", X"66", X"7C", X"78", X"6C", X"66", X"00", X"3C", X"66", X"60", X"3C", X"06", X"66", X"3C", X"00", 
		X"7E", X"18", X"18", X"18", X"18", X"18", X"18", X"00", X"66", X"66", X"66", X"66", X"66", X"66", X"3C", X"00", 
		X"66", X"66", X"66", X"66", X"66", X"3C", X"18", X"00", X"63", X"63", X"63", X"6B", X"7F", X"77", X"63", X"00", 
		X"66", X"66", X"3C", X"18", X"3C", X"66", X"66", X"00", X"66", X"66", X"66", X"3C", X"18", X"18", X"18", X"00", 
		X"7E", X"06", X"0C", X"18", X"30", X"60", X"7E", X"00", X"3C", X"30", X"30", X"30", X"30", X"30", X"3C", X"00", 
		X"0C", X"12", X"30", X"7C", X"30", X"62", X"FC", X"00", X"3C", X"0C", X"0C", X"0C", X"0C", X"0C", X"3C", X"00", 
		X"00", X"18", X"3C", X"7E", X"18", X"18", X"18", X"18", X"00", X"10", X"30", X"7F", X"7F", X"30", X"10", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"18", X"18", X"00", X"00", X"18", X"00", 
		X"66", X"66", X"66", X"00", X"00", X"00", X"00", X"00", X"66", X"66", X"FF", X"66", X"FF", X"66", X"66", X"00", 
		X"18", X"3E", X"60", X"3C", X"06", X"7C", X"18", X"00", X"62", X"66", X"0C", X"18", X"30", X"66", X"46", X"00", 
		X"3C", X"66", X"3C", X"38", X"67", X"66", X"3F", X"00", X"06", X"0C", X"18", X"00", X"00", X"00", X"00", X"00", 
		X"0C", X"18", X"30", X"30", X"30", X"18", X"0C", X"00", X"30", X"18", X"0C", X"0C", X"0C", X"18", X"30", X"00", 
		X"00", X"66", X"3C", X"FF", X"3C", X"66", X"00", X"00", X"00", X"18", X"18", X"7E", X"18", X"18", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"30", X"00", X"00", X"00", X"7E", X"00", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"00", X"00", X"03", X"06", X"0C", X"18", X"30", X"60", X"00", 
		X"3C", X"66", X"6E", X"76", X"66", X"66", X"3C", X"00", X"18", X"18", X"38", X"18", X"18", X"18", X"7E", X"00", 
		X"3C", X"66", X"06", X"0C", X"30", X"60", X"7E", X"00", X"3C", X"66", X"06", X"1C", X"06", X"66", X"3C", X"00", 
		X"06", X"0E", X"1E", X"66", X"7F", X"06", X"06", X"00", X"7E", X"60", X"7C", X"06", X"06", X"66", X"3C", X"00", 
		X"3C", X"66", X"60", X"7C", X"66", X"66", X"3C", X"00", X"7E", X"66", X"0C", X"18", X"18", X"18", X"18", X"00", 
		X"3C", X"66", X"66", X"3C", X"66", X"66", X"3C", X"00", X"3C", X"66", X"66", X"3E", X"06", X"66", X"3C", X"00", 
		X"00", X"00", X"18", X"00", X"00", X"18", X"00", X"00", X"00", X"00", X"18", X"00", X"00", X"18", X"18", X"30", 
		X"0E", X"18", X"30", X"60", X"30", X"18", X"0E", X"00", X"00", X"00", X"7E", X"00", X"7E", X"00", X"00", X"00", 
		X"70", X"18", X"0C", X"06", X"0C", X"18", X"70", X"00", X"3C", X"66", X"06", X"0C", X"18", X"00", X"18", X"00", 
		X"00", X"00", X"00", X"FF", X"FF", X"00", X"00", X"00", X"08", X"1C", X"3E", X"7F", X"7F", X"1C", X"3E", X"00", 
		X"18", X"18", X"18", X"18", X"18", X"18", X"18", X"18", X"00", X"00", X"00", X"FF", X"FF", X"00", X"00", X"00", 
		X"00", X"00", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"FF", X"FF", X"00", X"00", X"30", X"30", X"30", X"30", X"30", X"30", X"30", X"30", 
		X"0C", X"0C", X"0C", X"0C", X"0C", X"0C", X"0C", X"0C", X"00", X"00", X"00", X"E0", X"F0", X"38", X"18", X"18", 
		X"18", X"18", X"1C", X"0F", X"07", X"00", X"00", X"00", X"18", X"18", X"38", X"F0", X"E0", X"00", X"00", X"00", 
		X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"FF", X"FF", X"C0", X"E0", X"70", X"38", X"1C", X"0E", X"07", X"03", 
		X"03", X"07", X"0E", X"1C", X"38", X"70", X"E0", X"C0", X"FF", X"FF", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", 
		X"FF", X"FF", X"03", X"03", X"03", X"03", X"03", X"03", X"00", X"3C", X"7E", X"7E", X"7E", X"7E", X"3C", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", X"00", X"36", X"7F", X"7F", X"7F", X"3E", X"1C", X"08", X"00", 
		X"60", X"60", X"60", X"60", X"60", X"60", X"60", X"60", X"00", X"00", X"00", X"07", X"0F", X"1C", X"18", X"18", 
		X"C3", X"E7", X"7E", X"3C", X"3C", X"7E", X"E7", X"C3", X"00", X"3C", X"7E", X"66", X"66", X"7E", X"3C", X"00", 
		X"18", X"18", X"66", X"66", X"18", X"18", X"3C", X"00", X"06", X"06", X"06", X"06", X"06", X"06", X"06", X"06", 
		X"08", X"1C", X"3E", X"7F", X"3E", X"1C", X"08", X"00", X"18", X"18", X"18", X"FF", X"FF", X"18", X"18", X"18", 
		X"C0", X"C0", X"30", X"30", X"C0", X"C0", X"30", X"30", X"18", X"18", X"18", X"18", X"18", X"18", X"18", X"18", 
		X"00", X"00", X"03", X"3E", X"76", X"36", X"36", X"00", X"FF", X"7F", X"3F", X"1F", X"0F", X"07", X"03", X"01", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", 
		X"00", X"00", X"00", X"00", X"FF", X"FF", X"FF", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", 
		X"CC", X"CC", X"33", X"33", X"CC", X"CC", X"33", X"33", X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"03", 
		X"00", X"00", X"00", X"00", X"CC", X"CC", X"33", X"33", X"FF", X"FE", X"FC", X"F8", X"F0", X"E0", X"C0", X"80", 
		X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"18", X"18", X"18", X"1F", X"1F", X"18", X"18", X"18", 
		X"00", X"00", X"00", X"00", X"0F", X"0F", X"0F", X"0F", X"18", X"18", X"18", X"1F", X"1F", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"F8", X"F8", X"18", X"18", X"18", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", 
		X"00", X"00", X"00", X"1F", X"1F", X"18", X"18", X"18", X"18", X"18", X"18", X"FF", X"FF", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"FF", X"FF", X"18", X"18", X"18", X"18", X"18", X"18", X"F8", X"F8", X"18", X"18", X"18", 
		X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", 
		X"07", X"07", X"07", X"07", X"07", X"07", X"07", X"07", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", 
		X"FF", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", X"FF", 
		X"03", X"03", X"03", X"03", X"03", X"03", X"FF", X"FF", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", 
		X"0F", X"0F", X"0F", X"0F", X"00", X"00", X"00", X"00", X"18", X"18", X"18", X"F8", X"F8", X"00", X"00", X"00", 
		X"F0", X"F0", X"F0", X"F0", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", X"0F", X"0F", X"0F", X"0F", 
		X"3C", X"66", X"6E", X"6E", X"60", X"62", X"3C", X"00", X"00", X"00", X"3C", X"06", X"3E", X"66", X"3E", X"00", 
		X"00", X"60", X"60", X"7C", X"66", X"66", X"7C", X"00", X"00", X"00", X"3C", X"60", X"60", X"60", X"3C", X"00", 
		X"00", X"06", X"06", X"3E", X"66", X"66", X"3E", X"00", X"00", X"00", X"3C", X"66", X"7E", X"60", X"3C", X"00", 
		X"00", X"0E", X"18", X"3E", X"18", X"18", X"18", X"00", X"00", X"00", X"3E", X"66", X"66", X"3E", X"06", X"7C", 
		X"00", X"60", X"60", X"7C", X"66", X"66", X"66", X"00", X"00", X"18", X"00", X"38", X"18", X"18", X"3C", X"00", 
		X"00", X"06", X"00", X"06", X"06", X"06", X"06", X"3C", X"00", X"60", X"60", X"6C", X"78", X"6C", X"66", X"00", 
		X"00", X"38", X"18", X"18", X"18", X"18", X"3C", X"00", X"00", X"00", X"66", X"7F", X"7F", X"6B", X"63", X"00", 
		X"00", X"00", X"7C", X"66", X"66", X"66", X"66", X"00", X"00", X"00", X"3C", X"66", X"66", X"66", X"3C", X"00", 
		X"00", X"00", X"7C", X"66", X"66", X"7C", X"60", X"60", X"00", X"00", X"3E", X"66", X"66", X"3E", X"06", X"06", 
		X"00", X"00", X"7C", X"66", X"60", X"60", X"60", X"00", X"00", X"00", X"3E", X"60", X"3C", X"06", X"7C", X"00", 
		X"00", X"18", X"7E", X"18", X"18", X"18", X"0E", X"00", X"00", X"00", X"66", X"66", X"66", X"66", X"3E", X"00", 
		X"00", X"00", X"66", X"66", X"66", X"3C", X"18", X"00", X"00", X"00", X"63", X"6B", X"7F", X"3E", X"36", X"00", 
		X"00", X"00", X"66", X"3C", X"18", X"3C", X"66", X"00", X"00", X"00", X"66", X"66", X"66", X"3E", X"0C", X"78", 
		X"00", X"00", X"7E", X"0C", X"18", X"30", X"7E", X"00", X"3C", X"30", X"30", X"30", X"30", X"30", X"3C", X"00", 
		X"0C", X"12", X"30", X"7C", X"30", X"62", X"FC", X"00", X"3C", X"0C", X"0C", X"0C", X"0C", X"0C", X"3C", X"00", 
		X"00", X"18", X"3C", X"7E", X"18", X"18", X"18", X"18", X"00", X"10", X"30", X"7F", X"7F", X"30", X"10", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"18", X"18", X"00", X"00", X"18", X"00", 
		X"66", X"66", X"66", X"00", X"00", X"00", X"00", X"00", X"66", X"66", X"FF", X"66", X"FF", X"66", X"66", X"00", 
		X"18", X"3E", X"60", X"3C", X"06", X"7C", X"18", X"00", X"62", X"66", X"0C", X"18", X"30", X"66", X"46", X"00", 
		X"3C", X"66", X"3C", X"38", X"67", X"66", X"3F", X"00", X"06", X"0C", X"18", X"00", X"00", X"00", X"00", X"00", 
		X"0C", X"18", X"30", X"30", X"30", X"18", X"0C", X"00", X"30", X"18", X"0C", X"0C", X"0C", X"18", X"30", X"00", 
		X"00", X"66", X"3C", X"FF", X"3C", X"66", X"00", X"00", X"00", X"18", X"18", X"7E", X"18", X"18", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"30", X"00", X"00", X"00", X"7E", X"00", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"18", X"18", X"00", X"00", X"03", X"06", X"0C", X"18", X"30", X"60", X"00", 
		X"3C", X"66", X"6E", X"76", X"66", X"66", X"3C", X"00", X"18", X"18", X"38", X"18", X"18", X"18", X"7E", X"00", 
		X"3C", X"66", X"06", X"0C", X"30", X"60", X"7E", X"00", X"3C", X"66", X"06", X"1C", X"06", X"66", X"3C", X"00", 
		X"06", X"0E", X"1E", X"66", X"7F", X"06", X"06", X"00", X"7E", X"60", X"7C", X"06", X"06", X"66", X"3C", X"00", 
		X"3C", X"66", X"60", X"7C", X"66", X"66", X"3C", X"00", X"7E", X"66", X"0C", X"18", X"18", X"18", X"18", X"00", 
		X"3C", X"66", X"66", X"3C", X"66", X"66", X"3C", X"00", X"3C", X"66", X"66", X"3E", X"06", X"66", X"3C", X"00", 
		X"00", X"00", X"18", X"00", X"00", X"18", X"00", X"00", X"00", X"00", X"18", X"00", X"00", X"18", X"18", X"30", 
		X"0E", X"18", X"30", X"60", X"30", X"18", X"0E", X"00", X"00", X"00", X"7E", X"00", X"7E", X"00", X"00", X"00", 
		X"70", X"18", X"0C", X"06", X"0C", X"18", X"70", X"00", X"3C", X"66", X"06", X"0C", X"18", X"00", X"18", X"00", 
		X"00", X"00", X"00", X"FF", X"FF", X"00", X"00", X"00", X"18", X"3C", X"66", X"7E", X"66", X"66", X"66", X"00", 
		X"7C", X"66", X"66", X"7C", X"66", X"66", X"7C", X"00", X"3C", X"66", X"60", X"60", X"60", X"66", X"3C", X"00", 
		X"78", X"6C", X"66", X"66", X"66", X"6C", X"78", X"00", X"7E", X"60", X"60", X"78", X"60", X"60", X"7E", X"00", 
		X"7E", X"60", X"60", X"78", X"60", X"60", X"60", X"00", X"3C", X"66", X"60", X"6E", X"66", X"66", X"3C", X"00", 
		X"66", X"66", X"66", X"7E", X"66", X"66", X"66", X"00", X"3C", X"18", X"18", X"18", X"18", X"18", X"3C", X"00", 
		X"1E", X"0C", X"0C", X"0C", X"0C", X"6C", X"38", X"00", X"66", X"6C", X"78", X"70", X"78", X"6C", X"66", X"00", 
		X"60", X"60", X"60", X"60", X"60", X"60", X"7E", X"00", X"63", X"77", X"7F", X"6B", X"63", X"63", X"63", X"00", 
		X"66", X"76", X"7E", X"7E", X"6E", X"66", X"66", X"00", X"3C", X"66", X"66", X"66", X"66", X"66", X"3C", X"00", 
		X"7C", X"66", X"66", X"7C", X"60", X"60", X"60", X"00", X"3C", X"66", X"66", X"66", X"66", X"3C", X"0E", X"00", 
		X"7C", X"66", X"66", X"7C", X"78", X"6C", X"66", X"00", X"3C", X"66", X"60", X"3C", X"06", X"66", X"3C", X"00", 
		X"7E", X"18", X"18", X"18", X"18", X"18", X"18", X"00", X"66", X"66", X"66", X"66", X"66", X"66", X"3C", X"00", 
		X"66", X"66", X"66", X"66", X"66", X"3C", X"18", X"00", X"63", X"63", X"63", X"6B", X"7F", X"77", X"63", X"00", 
		X"66", X"66", X"3C", X"18", X"3C", X"66", X"66", X"00", X"66", X"66", X"66", X"3C", X"18", X"18", X"18", X"00", 
		X"7E", X"06", X"0C", X"18", X"30", X"60", X"7E", X"00", X"18", X"18", X"18", X"FF", X"FF", X"18", X"18", X"18", 
		X"C0", X"C0", X"30", X"30", X"C0", X"C0", X"30", X"30", X"18", X"18", X"18", X"18", X"18", X"18", X"18", X"18", 
		X"33", X"33", X"CC", X"CC", X"33", X"33", X"CC", X"CC", X"33", X"99", X"CC", X"66", X"33", X"99", X"CC", X"66", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", X"F0", 
		X"00", X"00", X"00", X"00", X"FF", X"FF", X"FF", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", 
		X"CC", X"CC", X"33", X"33", X"CC", X"CC", X"33", X"33", X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"03", 
		X"00", X"00", X"00", X"00", X"CC", X"CC", X"33", X"33", X"CC", X"99", X"33", X"66", X"CC", X"99", X"33", X"66", 
		X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"03", X"18", X"18", X"18", X"1F", X"1F", X"18", X"18", X"18", 
		X"00", X"00", X"00", X"00", X"0F", X"0F", X"0F", X"0F", X"18", X"18", X"18", X"1F", X"1F", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"F8", X"F8", X"18", X"18", X"18", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", 
		X"00", X"00", X"00", X"1F", X"1F", X"18", X"18", X"18", X"18", X"18", X"18", X"FF", X"FF", X"00", X"00", X"00", 
		X"00", X"00", X"00", X"FF", X"FF", X"18", X"18", X"18", X"18", X"18", X"18", X"F8", X"F8", X"18", X"18", X"18", 
		X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"C0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", X"E0", 
		X"07", X"07", X"07", X"07", X"07", X"07", X"07", X"07", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", 
		X"FF", X"FF", X"FF", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"00", X"FF", X"FF", X"FF", 
		X"01", X"03", X"06", X"6C", X"78", X"70", X"60", X"00", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", 
		X"0F", X"0F", X"0F", X"0F", X"00", X"00", X"00", X"00", X"18", X"18", X"18", X"F8", X"F8", X"00", X"00", X"00", 
		X"F0", X"F0", X"F0", X"F0", X"00", X"00", X"00", X"00", X"F0", X"F0", X"F0", X"F0", X"0F", X"0F", X"0F", X"0F" 
	);

	signal romOut : unsigned(7 downto 0);
begin
	genRomOut: process(clk, addr)
	begin
		if rising_edge(clk) then
			romOut <= romData(to_integer(addr(11) & addr(9 downto 0))) after 2 ns;
		end if;
	end process;

	genDo: process(romOut, addr)
	begin
		do <= romOut xor (addr(10) & addr(10) & addr(10) & addr(10) & addr(10) & addr(10) & addr(10) & addr(10));
	end process;
end Behavioral;
